/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_AddHostgroup;
import sanproject.common.Robj_interface_AddLUPath;
import sanproject.common.Robj_interface_AddWWN;
import sanproject.common.Robj_interface_DelHostgroup;
import sanproject.common.Robj_interface_DelLUPath;
import sanproject.common.Robj_interface_DelWWN;
import sanproject.common.Robj_interface_RJiHostGroup;
import sanproject.common.Robj_interface_RJiHostGroupInfoDetail;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiWWN;
import sanproject.common.Robj_interface_SetHostMode;
import sanproject.common.Robj_interface_SetSecuritySwitchInfo;
import sanproject.serverux.data.SANRmiException;

public class PortandHostGroupInfo
extends AbstractBaseCommonObject
implements Comparable<PortandHostGroupInfo> {
    private static final long serialVersionUID = 1L;
    private static Class<PortandHostGroupInfo[]> clz = PortandHostGroupInfo[].class;
    private static Hashtable<Short, Set<Short>> usedHostGrpOnPort = new Hashtable();
    private static byte SECURITY_SWITCH_ON = 1;
    private ArrayList<String> mHostWWNs;
    private short mPortID;
    private short mCtrlID;
    private String systemName;
    private short mHostGroupID;
    private String clientType;
    private UnsignedInteger16 mHostMode;
    private BitSet mBTOption;
    private String mHostGroupNickName;
    private Hashtable<String, String> mWWNNickName;

    private static boolean addHostWWNs(Robj_interface_RJiHostGroup hostGroup, PortandHostGroupInfo phgi, Robj_interface_RJiWWN[] hostWWNs, String hostWWN2Match) throws Exception {
        boolean ret = false;
        for (Robj_interface_RJiWWN hostWWN : hostWWNs) {
            byte[] wwn = hostWWN.getByWWN();
            String nick = hostWWN.getStrWWNNickName();
            String hexString = ProviderLibs.getHexString(wwn);
            if (null == hexString || phgi.mHostWWNs.contains(hexString)) continue;
            if (null != hostWWN2Match) {
                if (hexString.compareTo(hostWWN2Match) != 0) continue;
                phgi.mHostWWNs = new ArrayList();
                phgi.mHostWWNs.add(hexString);
                phgi.mWWNNickName.put(hexString, nick);
                ret = true;
                break;
            }
            phgi.mHostWWNs.add(hexString);
            phgi.mWWNNickName.put(hexString, nick);
        }
        return ret;
    }

    public static int addLUPath(List<Object> pMethodList, RMIObjectCache rmiObjCache, short pPort, short pHostGroup, short ldkcNum, short pCUNum, short pLdevNum, short pLun) throws WBEMException, RemoteException, SANRmiException {
        int ret = 5;
        if (null != pMethodList && 256 > pPort && 255 > pHostGroup && 2048 > pLun) {
            if (256 <= pCUNum || 256 <= pLdevNum) {
                throw new WBEMException("Invalid CU/LDEV for addLUPath. CU #: " + pCUNum + ", LDEV #: " + pLdevNum);
            }
        } else {
            throw new WBEMException("Invalid params for addLUPath. MethodList: " + pMethodList + ", Port: " + pPort + ", HostGroup: " + pHostGroup + ", Lun: " + pLun);
        }
        Robj_interface_AddLUPath AddLUPath = (Robj_interface_AddLUPath)rmiObjCache.createObj(100728880);
        AddLUPath.setSPort(pPort);
        AddLUPath.setSHostGroup(pHostGroup);
        AddLUPath.setSLUN(pLun);
        AddLUPath.setSLDEV(pLdevNum);
        AddLUPath.setSLDKC(ldkcNum);
        AddLUPath.setSCU(pCUNum);
        pMethodList.add(AddLUPath);
        ret = 0;
        return ret;
    }

    private static void addPathToMap(HashMap<String, List<PortandHostGroupInfo>> pghiMap, PortandHostGroupInfo port) {
        String key = null;
        key = CacheLib.getPHGIClientType(port.getClientType());
        CacheLib.addToMap(pghiMap, key, port);
        key = null;
        key = CacheLib.getPHGIControlID(port.getCtrlID());
        CacheLib.addToMap(pghiMap, key, port);
        key = null;
        key = CacheLib.getPHGIPortID(port.getPortID());
        CacheLib.addToMap(pghiMap, key, port);
        key = CacheLib.getPHGIDomain(key, port.getHostgroupID());
        CacheLib.addToMap(pghiMap, key, port);
        key = CacheLib.getPHGIControlID(key, port.getCtrlID());
        CacheLib.addToMap(pghiMap, key, port);
        String portDomainControlIDKey = key;
        if (!port.mHostWWNs.isEmpty()) {
            key = null;
            key = CacheLib.getPHGIHost();
            CacheLib.addToMap(pghiMap, key, port);
        }
        key = null;
        for (String wwn : port.getHostWWNs()) {
            key = CacheLib.getPHGIHostWWN(wwn);
            CacheLib.addToMap(pghiMap, key, port);
            key = key + portDomainControlIDKey;
            CacheLib.addToMap(pghiMap, key, port);
            key = null;
        }
    }

    public static PortandHostGroupInfo[] addPGHIToCache(List<Short> addedPorts, String serialNum) throws WBEMException {
        ArrayList<PortandHostGroupInfo> ret = new ArrayList<PortandHostGroupInfo>(addedPorts.size());
        try {
            PortandHostGroupInfo phgi;
            CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
            PortandHostGroupInfo.getUnCachedPortandHostGroupInfo(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), callback, null, null, null, null, false, null, true);
            LinkedList<PortandHostGroupInfo> phgiList = callback.getReturnValue();
            callback = null;
            HashMap<String, List<PortandHostGroupInfo>> pathMap = new HashMap<String, List<PortandHostGroupInfo>>();
            Collections.sort(addedPorts);
            while ((phgi = (PortandHostGroupInfo)phgiList.poll()) != null) {
                if (Collections.binarySearch(addedPorts, phgi.getPortID()) < 0) continue;
                PortandHostGroupInfo.addPathToMap(pathMap, phgi);
                ret.add(phgi);
            }
            CacheLib.addDataToCache(pathMap, ret, clz, serialNum);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add PortandHostGroupInfo to " + serialNum, null, t);
        }
        return ret.toArray(new PortandHostGroupInfo[ret.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int addWWN(List<Object> pMethodList, RMIObjectCache rmiObjCache, short pPort, short pHostGroup, String[] pHostWWNs) throws WBEMException {
        int ret = 5;
        if (null == pMethodList) throw new WBEMException("addWWN invalid parameter: methodList: " + pMethodList + ", HostWWNs: " + Arrays.toString(pHostWWNs) + ", Ports: " + pPort + ", HostGroup: " + pHostGroup);
        if (null == pHostWWNs) throw new WBEMException("addWWN invalid parameter: methodList: " + pMethodList + ", HostWWNs: " + Arrays.toString(pHostWWNs) + ", Ports: " + pPort + ", HostGroup: " + pHostGroup);
        if (256 <= pPort) throw new WBEMException("addWWN invalid parameter: methodList: " + pMethodList + ", HostWWNs: " + Arrays.toString(pHostWWNs) + ", Ports: " + pPort + ", HostGroup: " + pHostGroup);
        if (255 <= pHostGroup) throw new WBEMException("addWWN invalid parameter: methodList: " + pMethodList + ", HostWWNs: " + Arrays.toString(pHostWWNs) + ", Ports: " + pPort + ", HostGroup: " + pHostGroup);
        Robj_interface_RJiWWN[] objWWNs = PortandHostGroupInfo.getObjWWN(rmiObjCache, pPort, pHostGroup, pHostWWNs);
        if (null == objWWNs) throw new WBEMException("getObjWWN returned null, port: " + pPort + ", HostGroup: " + pHostGroup + ", HostWWNs: " + Arrays.toString(pHostWWNs));
        try {
            Robj_interface_AddWWN addWWN = (Robj_interface_AddWWN)rmiObjCache.createObj(100728893);
            addWWN.setSPort(pPort);
            addWWN.setSHostgroupID(pHostGroup);
            addWWN.setObjWWN(objWWNs);
            pMethodList.add(addWWN);
            return 0;
        }
        catch (RemoteException re) {
            throw new WBEMException(1, re.getMessage(), null, (Throwable)re);
        }
        catch (SANRmiException sre) {
            throw new WBEMException(1, sre.getErrMsgEn(), null, (Throwable)sre);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        if (!cache.isCached(clz)) {
            Class<PortandHostGroupInfo> clazz = PortandHostGroupInfo.class;
            synchronized (PortandHostGroupInfo.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<PortandHostGroupInfo> callback = new ClosableAddableIteratorCB<PortandHostGroupInfo>();
                    PortandHostGroupInfo.getUnCachedPortandHostGroupInfo(rmiObj, callback, null, null, null, null, false, null, true);
                    CloseableAddableIterator<PortandHostGroupInfo> cbIter = callback.getWrappedCloseableAddableIter();
                    ArrayList<PortandHostGroupInfo> ports = new ArrayList<PortandHostGroupInfo>();
                    HashMap pghiMap = new HashMap();
                    while (cbIter.hasNext()) {
                        PortandHostGroupInfo port = (PortandHostGroupInfo)cbIter.next();
                        ports.add(port);
                        PortandHostGroupInfo.addPathToMap(pghiMap, port);
                    }
                    logger.log(Level.INFO, "Created {0} Port&HostGroups for {1}", new Object[]{ports.size(), mapping.getSerialNumber()});
                    CacheLib.addDataToCache(pghiMap, ports, clz, mapping.getSerialNumber());
                } else {
                    logger.log(Level.WARNING, "PortandHostGroupInfo was cached for {0}", mapping.getSerialNumber());
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else {
            logger.log(Level.WARNING, "PortandHostGroupInfo is already cached for {0}", mapping.getSerialNumber());
        }
    }

    public static int createNewHostGroup(List<Object> pMethodList, PortandHostGroupInfo[] returnPortInfo, RMIObjectMapping rmiMap, FCPort pFCPort, short hostGrp, int hostMode, String elementName, Logger pLogger) throws WBEMException {
        int ret = 5;
        short portNum = pFCPort.getPort();
        if (null != pMethodList && null != returnPortInfo && returnPortInfo.length > 0 && 256 > portNum) {
            try {
                RMIObjectCache rmiObjCache = rmiMap.getRMIObject();
                PortandHostGroupInfo.turnOnLunSecurity(pMethodList, pFCPort, rmiObjCache);
                Robj_interface_AddHostgroup addHostGroup = (Robj_interface_AddHostgroup)rmiObjCache.createObj(100728892);
                addHostGroup.setSPort(portNum);
                if (hostGrp == -1) {
                    hostGrp = PortandHostGroupInfo.getFreeHostGroup(rmiObjCache, portNum, pLogger);
                }
                if (hostGrp > -1) {
                    addHostGroup.setSHostgroupID(hostGrp);
                    if (null != elementName) {
                        addHostGroup.setStrHostgroupNickName(elementName);
                    } else {
                        addHostGroup.setStrHostgroupNickName(portNum + "." + hostGrp);
                    }
                    pMethodList.add(addHostGroup);
                    PortandHostGroupInfo.setHostMode(pMethodList, rmiObjCache, portNum, hostGrp, hostMode);
                    returnPortInfo[0] = new PortandHostGroupInfo(rmiMap.getSerialNumber(), portNum, addHostGroup.getSHostgroupID(), 0, rmiMap.getStorageSystemName(), null, null);
                    ret = 0;
                }
            }
            catch (Throwable e) {
                throw new WBEMException(1, e.toString(), null, e);
            }
        }
        return ret;
    }

    public static int deleteHostGroup(List<Object> pMethodList, RMIObjectMapping rmiobj, short pPort, short pHostGroup, Logger pLogger) throws WBEMException {
        int ret = 5;
        if (256 < pPort) {
            pLogger.warning("deleteHostGroup:The specified port, " + pPort + ", is greater then the maximum port number, " + 256);
        } else if (255 < pHostGroup) {
            pLogger.warning("deleteHostGroup:The specified hostgroup, " + pHostGroup + ", is greater then the maximum host number, " + 255);
        } else if (0 == pHostGroup) {
            pLogger.warning("deleteHostGroup:Cannot delete hostgroup number 0");
        } else if (null == pMethodList) {
            pLogger.warning("deleteHostGroup:methodlist is null");
        } else {
            try {
                RMIObjectCache rmiObjCache = rmiobj.getRMIObject();
                Robj_interface_DelHostgroup delHostGroup = (Robj_interface_DelHostgroup)rmiObjCache.createObj(100728896);
                delHostGroup.setSPort(pPort);
                delHostGroup.setSHostgroupID(pHostGroup);
                pMethodList.add(delHostGroup);
            }
            catch (RemoteException re) {
                throw new WBEMException(1, re.toString(), null, (Throwable)re);
            }
            catch (SANRmiException sre) {
                throw new WBEMException(1, sre.toString(), null, (Throwable)sre);
            }
            ret = 0;
        }
        return ret;
    }

    public static int deleteLUPath(List<Object> pMethodList, RMIObjectCache rmiObjCache, short pPort, short pHostGroup, short pLun) throws Exception {
        int ret = 5;
        if (null != pMethodList && pPort < 256 && pHostGroup < 255 && pLun < 2048) {
            Robj_interface_DelLUPath delLUPath = (Robj_interface_DelLUPath)rmiObjCache.createObj(100728881);
            delLUPath.setSPort(pPort);
            delLUPath.setSHostGroup(pHostGroup);
            delLUPath.setSLUN(pLun);
            pMethodList.add(delLUPath);
            ret = 0;
        }
        return ret;
    }

    public static int deleteWWN(List<Object> pMethodList, RMIObjectCache rmiObjCache, short pPort, short pHostGroup, String[] pHostWWNs) throws Exception {
        Robj_interface_RJiWWN[] objWWNs;
        int ret = 5;
        if (null != pMethodList && null != pHostWWNs && 256 > pPort && 255 > pHostGroup && null != (objWWNs = PortandHostGroupInfo.getObjWWN(rmiObjCache, pPort, pHostGroup, pHostWWNs))) {
            Robj_interface_DelWWN DelWWN = (Robj_interface_DelWWN)rmiObjCache.createObj(100728897);
            DelWWN.setSPort(pPort);
            DelWWN.setSHostgroupID(pHostGroup);
            DelWWN.setObjWWN(objWWNs);
            pMethodList.add(DelWWN);
            ret = 0;
        }
        return ret;
    }

    public static PortandHostGroupInfo find(String serialNumber, String systemName, String ctrlID, String portID, String domainID, String hostWWN, boolean hostWWNReq, String clientType) throws WBEMException {
        PortandHostGroupInfo ret = null;
        if (null == serialNumber || domainID == null && hostWWN == null || portID == null) {
            throw new WBEMException("Must pass device serial #, portID along with either a domainID or a hostWWN to find function.");
        }
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNumber).getRMIObject();
            FindMethodCallbackHandler<PortandHostGroupInfo> callback = new FindMethodCallbackHandler<PortandHostGroupInfo>();
            PortandHostGroupInfo.getPortandHostGroupInfo(rmiObj, callback, systemName, ctrlID, portID, domainID, hostWWN, hostWWNReq, clientType, false);
            ret = callback.getReturnValue();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    public static short getCtrIDUsingPortID(short portID, String serialNum) throws WBEMException {
        return FCPort.getCtrlID(portID, serialNum);
    }

    public static short getFreeHostGroup(RMIObjectCache rmiObj, short pPort, Logger pLogger) throws Exception {
        PortandHostGroupInfo phgi;
        short ret = -1;
        HashSet<Short> set = new HashSet<Short>();
        int numHostGroups = 0;
        CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
        PortandHostGroupInfo.getPortandHostGroupInfo(rmiObj, callback, rmiObj.getSMISMappingContainer().getStorageSystemName(), null, Short.toString(pPort), null, null, false, null, false);
        LinkedList<PortandHostGroupInfo> phgis = callback.getReturnValue();
        callback = null;
        Set<Short> usedHostGrp = usedHostGrpOnPort.get(pPort);
        if (null == usedHostGrp) {
            usedHostGrp = Collections.synchronizedSet(new HashSet());
            usedHostGrpOnPort.put(pPort, usedHostGrp);
        }
        while ((phgi = phgis.poll()) != null) {
            short hostGrp = phgi.getHostgroupID();
            if (usedHostGrp.contains(hostGrp)) {
                usedHostGrp.remove(hostGrp);
            }
            set.add(hostGrp);
            ++numHostGroups;
        }
        if (255 > (numHostGroups += usedHostGrp.size())) {
            for (short i = 1; i < 255 && -1 == ret; i = (short)(i + 1)) {
                if (set.contains(i) || usedHostGrp.contains(i)) continue;
                ret = i;
                usedHostGrp.add(i);
            }
        } else {
            pLogger.info("CreateNewHostGroup:There are already " + numHostGroups + " hostgroups on port " + pPort + " but the maximum allowed hostgroups per port is " + 255);
        }
        return ret;
    }

    private static byte[] getHostWWNsBytes(String hostWWN) throws Exception {
        byte[] ret = new byte[8];
        if (null == hostWWN || hostWWN.length() != 16) {
            throw new IllegalArgumentException("hostWWN is invalid: " + hostWWN);
        }
        for (int i = 0; i < 8; ++i) {
            String hexVal = hostWWN.substring(i * 2, i * 2 + 2);
            ret[i] = new Integer(Integer.parseInt(hexVal, 16)).byteValue();
        }
        return ret;
    }

    private static Robj_interface_RJiWWN[] getObjWWN(RMIObjectCache rmiObjCache, short pPort, short pHostGroup, String[] pHostWWNs) throws WBEMException {
        Robj_interface_RJiWWN[] ret = null;
        if (null != pHostWWNs && pHostWWNs.length > 0) {
            try {
                ret = new Robj_interface_RJiWWN[pHostWWNs.length];
                for (int i = 0; i < pHostWWNs.length; ++i) {
                    Robj_interface_RJiWWN objWWN = (Robj_interface_RJiWWN)rmiObjCache.createObj(100728856);
                    objWWN.setByWWN(PortandHostGroupInfo.getHostWWNsBytes(pHostWWNs[i]));
                    objWWN.setStrWWNNickName(pHostWWNs[i]);
                    ret[i] = objWWN;
                }
            }
            catch (RemoteException re) {
                throw new WBEMException(1, re.getMessage(), null, (Throwable)re);
            }
            catch (SANRmiException sre) {
                throw new WBEMException(1, sre.getErrMsgEn(), null, (Throwable)sre);
            }
            catch (Throwable t) {
                throw new WBEMException(1, t.toString(), null, t);
            }
        }
        return ret;
    }

    private static void getPortandHostGroupInfo(IteratorCallback<PortandHostGroupInfo> callback, String systemName, String ctrID, String portID, String domainID, String hostWWN, boolean hostWWNReq, String clientType, boolean continueOnError) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                PortandHostGroupInfo.getPortandHostGroupInfo(mapObj.getRMIObject(), callback, systemName, ctrID, portID, domainID, hostWWN, hostWWNReq, clientType, continueOnError);
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static void getPortandHostGroupInfo(RMIObjectCache rmiObj, IteratorCallback<PortandHostGroupInfo> callback, String systemName, boolean hostWWNReq, boolean continueOnError) {
        PortandHostGroupInfo.getPortandHostGroupInfo(rmiObj, callback, systemName, null, null, null, null, hostWWNReq, null, continueOnError);
    }

    public static void getPortandHostGroupInfo(RMIObjectCache rmiObj, IteratorCallback<PortandHostGroupInfo> callback, String systemName, String ctrID, String portID, String domainID, String hostWWN, boolean hostWWNReq, String clientType, boolean continueOnError) {
        try {
            if (null == rmiObj) {
                PortandHostGroupInfo.getPortandHostGroupInfo(callback, systemName, ctrID, portID, domainID, hostWWN, hostWWNReq, clientType, continueOnError);
                return;
            }
            RMIObjectMapping rmiMap = rmiObj.getSMISMappingContainer();
            if (systemName == null || systemName.startsWith(rmiMap.getStorageSystemName())) {
                HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
                if (cache.isCached(clz)) {
                    AbstractBaseCommonObject[] ports = null;
                    String key = null;
                    if (clientType != null) {
                        key = CacheLib.getPHGIClientType(clientType);
                    } else if (portID != null && domainID != null && ctrID != null) {
                        key = CacheLib.getPHGIPortID(Short.parseShort(portID));
                        key = CacheLib.getPHGIDomain(key, Short.parseShort(domainID));
                        key = CacheLib.getPHGIControlID(key, Short.parseShort(ctrID));
                        if (hostWWN != null) {
                            key = CacheLib.getPHGIHostWWN(hostWWN) + key;
                        }
                    } else if (portID != null && domainID != null) {
                        key = CacheLib.getPHGIPortID(Short.parseShort(portID));
                        key = CacheLib.getPHGIDomain(key, Short.parseShort(domainID));
                    } else if (portID != null) {
                        key = CacheLib.getPHGIPortID(Short.parseShort(portID));
                    } else if (portID == null && domainID == null && ctrID != null && hostWWN == null) {
                        key = CacheLib.getPHGIControlID(Short.parseShort(ctrID));
                    } else if (portID == null && domainID == null && ctrID == null && hostWWN == null && hostWWNReq) {
                        key = CacheLib.getPHGIHost();
                    } else if (portID == null && domainID == null && ctrID == null && hostWWN != null) {
                        key = CacheLib.getPHGIHostWWN(hostWWN);
                    } else if (portID == null && domainID == null && ctrID == null && hostWWN == null) {
                        ports = (PortandHostGroupInfo[])cache.getCachedObject(clz);
                        key = null;
                    } else {
                        throw new WBEMException(1, "Unexpected key combination for PortandHostGroupInfo(" + systemName + ", " + ctrID + ", " + portID + ", " + domainID + ", " + hostWWN + ", " + hostWWNReq + ", " + clientType + ") on " + rmiMap.getSerialNumber());
                    }
                    if (key != null) {
                        ports = (PortandHostGroupInfo[])cache.getCachedObject(key, clz);
                    }
                    if (ports != null) {
                        if (hostWWNReq) {
                            for (AbstractBaseCommonObject port : ports) {
                                if (((PortandHostGroupInfo)port).mHostWWNs.isEmpty() || hostWWN != null && !((PortandHostGroupInfo)port).mHostWWNs.contains(hostWWN)) continue;
                                callback.returnItem((PortandHostGroupInfo)port);
                            }
                            callback.done();
                        } else {
                            callback.returnItems(ports);
                        }
                    } else {
                        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                        logger.log(Level.INFO, "No PortandHostGroupInfo for {0} for key {1}", new Object[]{rmiMap.getSerialNumber(), key});
                        callback.done();
                    }
                } else {
                    LogRecord record = new LogRecord(Level.WARNING, "Object not cached on {0}, performance issue");
                    record.setParameters(new Object[]{rmiMap.getSerialNumber()});
                    record.setThrown(new Exception(record.getMessage()));
                    cacheLogger.log(record);
                    PortandHostGroupInfo.getUnCachedPortandHostGroupInfo(rmiObj, callback, ctrID, portID, domainID, hostWWN, hostWWNReq, clientType, continueOnError);
                }
            } else {
                callback.done();
            }
        }
        catch (WBEMException we) {
            callback.exceptionOccurred(we);
            callback.done();
        }
        catch (Throwable e) {
            WBEMException we = new WBEMException(1, "Error while processing PGHI", null, e);
            callback.exceptionOccurred(we);
            callback.done();
        }
    }

    public static void getUnCachedPortandHostGroupInfo(RMIObjectCache rmiobj, IteratorCallback<PortandHostGroupInfo> callback, String ctrID, String portID, String domainID, String hostWWN, boolean hostWWNReq, String clientType, boolean continueOnError) {
        block5: {
            try {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                Robj_interface_RJiPortIndex[] portIndexes = rmiobj.getPortIndex();
                Robj_interface_RJiHostGroupInfoDetail[] infoDetails = rmiobj.getHostGroupInfoDetail(portIndexes);
                String serial = rmiobj.getSMISMappingContainer().getSerialNumber();
                logger.log(Level.INFO, "Found {0} RJiHostGroupInfoDetail on {1}", new Object[]{infoDetails.length, serial});
                if (infoDetails.length > 0) {
                    TaskProcessor task = new TaskProcessor("PortHost - " + serial, infoDetails.length);
                    for (Robj_interface_RJiHostGroupInfoDetail infoDetail : infoDetails) {
                        if (task.shouldStop()) {
                            callback.done();
                            break block5;
                        }
                        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serial);
                        WorkerThread worker = new WorkerThread(serial, task, callback, infoDetail, mapping.getStorageSystemName(), ctrID, portID, domainID, hostWWN, hostWWNReq, clientType, continueOnError);
                        task.addTask(worker);
                    }
                    break block5;
                }
                callback.done();
            }
            catch (Throwable e) {
                WBEMException we = new WBEMException(1, e.toString(), null, e);
                callback.exceptionOccurred(we);
                callback.done();
            }
        }
    }

    public static void modifyCachedPHGI(List<Short> modifiedPorts, List<PortandHostGroupInfo> added, List<PortandHostGroupInfo> removed, List<PortandHostGroupInfo> modified, String serialNum) throws WBEMException {
        Logger.getLogger("com.hitachi.smis.logger.cache");
        ClosableAddableIteratorCB<PortandHostGroupInfo> callback = new ClosableAddableIteratorCB<PortandHostGroupInfo>();
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
        try {
            HashMap<String, List<PortandHostGroupInfo>> addedMap = new HashMap<String, List<PortandHostGroupInfo>>();
            HashMap<String, List<PortandHostGroupInfo>> removedMap = new HashMap<String, List<PortandHostGroupInfo>>();
            PortandHostGroupInfo.getUnCachedPortandHostGroupInfo(mapping.getRMIObject(), callback, null, null, null, null, false, null, true);
            CommonClassAsList<PortandHostGroupInfo> cachedCallback = new CommonClassAsList<PortandHostGroupInfo>();
            PortandHostGroupInfo.getPortandHostGroupInfo(mapping.getRMIObject(), cachedCallback, null, false, false);
            LinkedList<PortandHostGroupInfo> cachedElements = cachedCallback.getReturnValue();
            Collections.sort(cachedElements);
            CloseableAddableIterator<PortandHostGroupInfo> backEndIter = callback.getWrappedCloseableAddableIter();
            while (backEndIter.hasNext()) {
                PortandHostGroupInfo backendElement = (PortandHostGroupInfo)backEndIter.next();
                int x = Collections.binarySearch(cachedElements, backendElement);
                if (x >= 0) {
                    PortandHostGroupInfo cachedElement = cachedElements.remove(x);
                    if (!modifiedPorts.contains(cachedElement.getPortID()) || cachedElement.equals(backendElement)) continue;
                    PortandHostGroupInfo copyOfCached = new PortandHostGroupInfo(cachedElement);
                    modified.add(copyOfCached);
                    if (cachedElement.mHostWWNs.size() != backendElement.mHostWWNs.size() || !cachedElement.mHostWWNs.containsAll(cachedElement.mHostWWNs)) {
                        HashMap pghiMap = new HashMap();
                        ArrayList<PortandHostGroupInfo> theList = new ArrayList<PortandHostGroupInfo>();
                        theList.add(cachedElement);
                        PortandHostGroupInfo.removeItemsFromMapInCache(pghiMap, theList, serialNum);
                        pghiMap.clear();
                        PortandHostGroupInfo.addPathToMap(pghiMap, backendElement);
                        theList.clear();
                        theList.add(backendElement);
                        CacheLib.addDataToCache(pghiMap, theList, clz, serialNum);
                        continue;
                    }
                    cachedElement.copy(backendElement);
                    continue;
                }
                PortandHostGroupInfo.addPathToMap(addedMap, backendElement);
                added.add(backendElement);
            }
            if (!addedMap.isEmpty()) {
                CacheLib.addDataToCache(addedMap, added, clz, serialNum);
            }
            if (!cachedElements.isEmpty()) {
                removed.addAll(cachedElements);
                PortandHostGroupInfo.removeItemsFromMapInCache(removedMap, removed, serialNum);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred getting PGHI's from " + serialNum, null, t);
        }
    }

    public static void modifyCachedPHGI(List<Short> modifiedPorts, List<PortandHostGroupInfo> added, List<PortandHostGroupInfo> removed, String serialNum) throws WBEMException {
        AbstractMap<Short, List<PortandHostGroupInfo>> sortedPGHI;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
        try {
            PortandHostGroupInfo.getUnCachedPortandHostGroupInfo(mapping.getRMIObject(), callback, null, null, null, null, false, null, true);
            LinkedList<PortandHostGroupInfo> actualPGHI = callback.getReturnValue();
            sortedPGHI = PortandHostGroupInfo.sortRelaPHGIByPortID(actualPGHI);
            if (!actualPGHI.isEmpty()) {
                logger.log(Level.SEVERE, "While modifying cached PHGI on {0} we failed to sort out all uncached information: {1}", new Object[]{serialNum, Arrays.toString(actualPGHI.toArray())});
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred getting PGHI's from " + serialNum, null, t);
        }
        callback = null;
        logger.log(Level.INFO, "Processing {0} modified PortandHostGroupInfos for {1}", new Object[]{modifiedPorts.size(), serialNum});
        for (Short modifiedPort : modifiedPorts) {
            callback = new CommonClassAsList();
            try {
                PortandHostGroupInfo.getPortandHostGroupInfo(mapping.getRMIObject(), callback, null, null, modifiedPort.toString(), null, null, false, null, false);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception occurred getting PGHI(" + modifiedPort + ") from cache " + t, t);
                continue;
            }
            LinkedList<PortandHostGroupInfo> cachedPHGI = callback.getReturnValue();
            callback = null;
            List<PortandHostGroupInfo> actualPGHI = sortedPGHI.get(modifiedPort);
            if (cachedPHGI != null && actualPGHI != null) {
                added.addAll(actualPGHI);
                added.removeAll(cachedPHGI);
                cachedPHGI.removeAll(actualPGHI);
                removed.addAll(cachedPHGI);
                continue;
            }
            if (cachedPHGI == null && actualPGHI != null) {
                added.addAll(actualPGHI);
                continue;
            }
            if (!(cachedPHGI != null & actualPGHI == null)) continue;
            removed.addAll(cachedPHGI);
        }
        HashMap<String, List<PortandHostGroupInfo>> pathMap = new HashMap<String, List<PortandHostGroupInfo>>();
        for (PortandHostGroupInfo path : added) {
            PortandHostGroupInfo.addPathToMap(pathMap, path);
        }
        CacheLib.addDataToCache(pathMap, added, clz, serialNum);
        pathMap.clear();
        PortandHostGroupInfo.removeItemsFromMapInCache(pathMap, removed, serialNum);
    }

    public static String[] parseInstanceID(String instID) {
        String[] ret = new String[5];
        int currentSepIdx = 0;
        for (int counter = 0; counter < ret.length; ++counter) {
            int idx;
            if (counter < 4) {
                idx = instID.indexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR, currentSepIdx);
                if (0 == currentSepIdx) {
                    idx = instID.indexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR, idx + 1);
                }
            } else {
                idx = instID.length();
            }
            ret[counter] = instID.substring(currentSepIdx, idx);
            currentSepIdx = ++idx;
        }
        return ret;
    }

    private static boolean processInfoDetail(String serialNumber, IteratorCallback<PortandHostGroupInfo> callback, Robj_interface_RJiHostGroupInfoDetail infoDetail, String systemName, String ctrID, String portID, String domainID, String hostWWN, boolean hostWWNReq, String clientType, boolean continueOnError) {
        boolean ret;
        block7: {
            ret = true;
            try {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                short sPort = infoDetail.getSPort();
                if ((null == ctrID || ctrID.equals(String.valueOf(PortandHostGroupInfo.getCtrIDUsingPortID(sPort, serialNumber)))) && (null == portID || portID.equals(String.valueOf(sPort)))) {
                    Robj_interface_RJiHostGroup[] hostGroups = infoDetail.getObjHostGroup();
                    logger.log(Level.INFO, "Found {0} RJiHostGroup for port {1} on {2}", new Object[]{hostGroups.length, sPort, serialNumber});
                    for (int idx = 0; idx < hostGroups.length && ret; ++idx) {
                        Robj_interface_RJiHostGroup hostGroup = hostGroups[idx];
                        short groupID = hostGroup.getSHostgroupID();
                        if (null != domainID && !domainID.equals(String.valueOf(groupID))) continue;
                        Robj_interface_RJiWWN[] hostWWNs = hostGroup.getObjWWN();
                        if (hostWWNReq && (null == hostWWNs || hostWWNs.length == 0)) continue;
                        byte hostMode = hostGroup.getByHostMode();
                        PortandHostGroupInfo phgi = new PortandHostGroupInfo(serialNumber, sPort, groupID, hostMode, systemName, hostGroup.getBtOption(), hostGroup.getStrHostgroupNickName());
                        if (ResourceRestriction.isPHGIUsable(phgi)) {
                            if (clientType != null && clientType.compareTo(phgi.getClientType()) != 0) {
                                logger.log(Level.FINEST, "clietType, {0}, not matched on port {1} for {2}", new Object[]{clientType, phgi.toString(), serialNumber});
                                continue;
                            }
                            if (hostWWN != null) {
                                boolean matchedHostWWN = PortandHostGroupInfo.addHostWWNs(hostGroup, phgi, hostWWNs, hostWWN);
                                if (!matchedHostWWN) continue;
                                logger.info("found match for host WWN: " + hostWWN + ", port: " + phgi.toString());
                                callback.returnItem(phgi);
                                ret = false;
                                continue;
                            }
                            PortandHostGroupInfo.addHostWWNs(hostGroup, phgi, hostWWNs, null);
                            ret = callback.returnItem(phgi);
                            continue;
                        }
                        cacheLogger.log(Level.FINE, "Skipping PHGI {0}", phgi);
                    }
                }
            }
            catch (Throwable e) {
                WBEMException we = e instanceof WBEMException ? (WBEMException)e : new WBEMException(1, e.toString(), null, e);
                if (continueOnError) break block7;
                callback.exceptionOccurred(we);
                ret = false;
            }
        }
        return ret;
    }

    private static void removeItemsFromMapInCache(HashMap<String, List<PortandHostGroupInfo>> pghiMap, List<PortandHostGroupInfo> theList, String serialNum) throws WBEMException {
        for (PortandHostGroupInfo path : theList) {
            PortandHostGroupInfo.addPathToMap(pghiMap, path);
        }
        CacheLib.removeDataFromCache(pghiMap, (Serializable[])theList.toArray(new PortandHostGroupInfo[theList.size()]), clz, (String)serialNum);
    }

    public static PortandHostGroupInfo[] removePGHIFromCache(List<Short> removedPorts, String serialNum) throws WBEMException {
        ArrayList<PortandHostGroupInfo> pghis = new ArrayList<PortandHostGroupInfo>(removedPorts.size());
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            for (Short portID : removedPorts) {
                CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
                PortandHostGroupInfo.getPortandHostGroupInfo(rmiObj, callback, null, null, portID.toString(), null, null, false, null, false);
                LinkedList<PortandHostGroupInfo> temp = callback.getReturnValue();
                pghis.addAll(temp);
            }
            if (!pghis.isEmpty()) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                logger.log(Level.INFO, "Processing {0} PortandHostGroupInfo being removed from {1}", new Object[]{pghis.size(), serialNum});
                HashMap<String, List<PortandHostGroupInfo>> pghiMap = new HashMap<String, List<PortandHostGroupInfo>>();
                PortandHostGroupInfo.removeItemsFromMapInCache(pghiMap, pghis, serialNum);
                logger.info("Done processing PortandHostGroupinfo");
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to remove LUPath from cache" + t, null, t);
        }
        return pghis.toArray(new PortandHostGroupInfo[pghis.size()]);
    }

    public static String setClientType(byte hostMode) {
        String ret = null;
        switch (hostMode) {
            case 0: {
                ret = "2";
                break;
            }
            case 1: {
                ret = "32772";
                break;
            }
            case 5: {
                ret = "5";
                break;
            }
            case 7: {
                ret = "6";
                break;
            }
            case 9: {
                ret = "3";
                break;
            }
            case 10: {
                ret = "7";
                break;
            }
            case 12: {
                ret = "15";
                break;
            }
            case 15: {
                ret = "9";
                break;
            }
            case 33: {
                ret = "32773";
                break;
            }
            case 44: {
                ret = "32815";
                break;
            }
            case 76: {
                ret = "32771";
            }
        }
        return ret;
    }

    private static void setHostMode(List<Object> pMethodList, RMIObjectCache rmiObjCache, short portNum, short hostGroup, int hostMode) throws Exception {
        Robj_interface_SetHostMode setHostmode = (Robj_interface_SetHostMode)rmiObjCache.createObj(100728889);
        setHostmode.setSPort(portNum);
        setHostmode.setSHostgroupID(hostGroup);
        if (-1 != hostMode) {
            setHostmode.setByHostMode((byte)hostMode);
        } else {
            setHostmode.setByHostMode((byte)0);
        }
        BitSet bt = new BitSet(256);
        bt.clear();
        setHostmode.setBtOption(bt);
        pMethodList.add(setHostmode);
    }

    private static AbstractMap<Short, List<PortandHostGroupInfo>> sortRelaPHGIByPortID(Queue<PortandHostGroupInfo> unsorted) {
        PortandHostGroupInfo phgi;
        HashMap<Short, List<PortandHostGroupInfo>> ret = new HashMap<Short, List<PortandHostGroupInfo>>();
        while ((phgi = unsorted.poll()) != null) {
            List<PortandHostGroupInfo> qByPort = ret.get(phgi.getPortID());
            if (qByPort == null) {
                qByPort = new ArrayList<PortandHostGroupInfo>();
                ret.put(phgi.getPortID(), qByPort);
            }
            qByPort.add(phgi);
        }
        return ret;
    }

    private static void turnOnLunSecurity(List<Object> pMethodList, FCPort pFCPort, RMIObjectCache rmiObjCache) throws Exception {
        if (null != pMethodList && null != rmiObjCache && null != pFCPort) {
            Robj_interface_SetSecuritySwitchInfo setSecuritySwitchInfo = (Robj_interface_SetSecuritySwitchInfo)rmiObjCache.createObj(100728899);
            setSecuritySwitchInfo.setBySwitchOnOff(SECURITY_SWITCH_ON);
            setSecuritySwitchInfo.setSPort(pFCPort.getPort());
            pMethodList.add(setSecuritySwitchInfo);
        }
    }

    public PortandHostGroupInfo(PortandHostGroupInfo other) throws WBEMException {
        this(other.getSerialNumber(), other.getPortID(), other.getHostgroupID(), other.getHostMode().byteValue(), other.getSystemName(), other.getBTOption(), other.getHostGroupNickName());
        this.mHostWWNs.addAll(other.mHostWWNs);
        this.mWWNNickName.putAll(other.mWWNNickName);
    }

    public PortandHostGroupInfo(String serialNumber, short portID, short hostGroupID, byte hostMode, String storageSystemName, BitSet btOption, String strHostgroupNickName) throws WBEMException {
        super(serialNumber);
        try {
            this.mPortID = portID;
            this.mCtrlID = PortandHostGroupInfo.getCtrIDUsingPortID(portID, serialNumber);
            this.systemName = storageSystemName;
            this.mHostMode = new UnsignedInteger16((int)hostMode);
            this.clientType = PortandHostGroupInfo.setClientType(hostMode);
            this.mHostGroupID = hostGroupID;
            this.mHostWWNs = new ArrayList();
            this.mBTOption = btOption;
            this.mHostGroupNickName = strHostgroupNickName;
            this.mWWNNickName = new Hashtable();
        }
        catch (Throwable th) {
            if (WBEMException.class.isInstance(th)) {
                throw (WBEMException)th;
            }
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public int compareTo(PortandHostGroupInfo other) {
        int ret = this.getPortID() == other.getPortID() ? (this.getCtrlID() == other.getCtrlID() ? (this.getHostgroupID() == other.getHostgroupID() ? 0 : (this.getHostgroupID() < other.getHostgroupID() ? -1 : 1)) : (this.getCtrlID() < other.getCtrlID() ? -1 : 1)) : (this.getPortID() < other.getPortID() ? -1 : 1);
        return ret;
    }

    private void copy(PortandHostGroupInfo other) {
        this.clientType = other.getClientType();
        this.mBTOption = other.getBTOption();
        this.mCtrlID = other.getCtrlID();
        this.mHostGroupID = other.getHostgroupID();
        this.mHostGroupNickName = other.getHostGroupNickName();
        this.mHostMode = other.getHostMode();
        this.mHostWWNs.clear();
        this.mHostWWNs.addAll(other.mHostWWNs);
        this.mPortID = other.getPortID();
        this.mWWNNickName.clear();
        this.mWWNNickName.putAll(other.mWWNNickName);
        this.systemName = other.systemName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortandHostGroupInfo other = (PortandHostGroupInfo)obj;
        if (this.clientType == null ? other.clientType != null : !this.clientType.equals(other.clientType)) {
            return false;
        }
        if (this.mBTOption == null ? other.mBTOption != null : !this.mBTOption.equals(other.mBTOption)) {
            return false;
        }
        if (this.mCtrlID != other.mCtrlID) {
            return false;
        }
        if (this.mHostGroupID != other.mHostGroupID) {
            return false;
        }
        if (this.mHostGroupNickName == null ? other.mHostGroupNickName != null : !this.mHostGroupNickName.equals(other.mHostGroupNickName)) {
            return false;
        }
        if (this.mHostMode == null ? other.mHostMode != null : !this.mHostMode.equals((Object)other.mHostMode)) {
            return false;
        }
        if (this.mHostWWNs == null ? other.mHostWWNs != null : !this.mHostWWNs.equals(other.mHostWWNs)) {
            return false;
        }
        if (this.mPortID != other.mPortID) {
            return false;
        }
        if (this.mWWNNickName == null ? other.mWWNNickName != null : !this.mWWNNickName.equals(other.mWWNNickName)) {
            return false;
        }
        return !(this.systemName == null ? other.systemName != null : !this.systemName.equals(other.systemName));
    }

    public BitSet getBTOption() {
        return this.mBTOption;
    }

    public String getClientType() {
        return this.clientType;
    }

    public short getCtrlID() {
        return this.mCtrlID;
    }

    public short getHostgroupID() {
        return this.mHostGroupID;
    }

    public String getHostGroupNickName() {
        return this.mHostGroupNickName;
    }

    public UnsignedInteger16 getHostMode() {
        return this.mHostMode;
    }

    public UnsignedInteger16[] getHostModeOption() {
        ArrayList<UnsignedInteger16> bitSetArray = new ArrayList<UnsignedInteger16>();
        BitSet bs = this.getBTOption();
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            bitSetArray.add(new UnsignedInteger16(i));
            i = bs.nextSetBit(i + 1);
        }
        return bitSetArray.toArray(new UnsignedInteger16[bitSetArray.size()]);
    }

    public String[] getHostWWNs() {
        return this.mHostWWNs.toArray(new String[this.mHostWWNs.size()]);
    }

    public short getPortID() {
        return this.mPortID;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getWWNNickName(String wwn) {
        return this.mWWNNickName.get(wwn);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.clientType == null ? 0 : this.clientType.hashCode());
        result = 31 * result + (this.mBTOption == null ? 0 : this.mBTOption.hashCode());
        result = 31 * result + this.mCtrlID;
        result = 31 * result + this.mHostGroupID;
        result = 31 * result + (this.mHostGroupNickName == null ? 0 : this.mHostGroupNickName.hashCode());
        result = 31 * result + (this.mHostMode == null ? 0 : this.mHostMode.hashCode());
        result = 31 * result + (this.mHostWWNs == null ? 0 : this.mHostWWNs.hashCode());
        result = 31 * result + this.mPortID;
        result = 31 * result + (this.mWWNNickName == null ? 0 : this.mWWNNickName.hashCode());
        result = 31 * result + (this.systemName == null ? 0 : this.systemName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PortandHostGroupInfo [serialNumber=");
        builder.append(this.getSerialNumber());
        builder.append(", mPortID=");
        builder.append(this.mPortID);
        builder.append(", mCtrlID=");
        builder.append(this.mCtrlID);
        builder.append(", systemName=");
        builder.append(this.systemName);
        builder.append(", mHostWWNs=");
        builder.append(this.mHostWWNs);
        builder.append(", mHostGroupID=");
        builder.append(this.mHostGroupID);
        builder.append(", clientType=");
        builder.append(this.clientType);
        builder.append(", mHostMode=");
        builder.append(this.mHostMode);
        builder.append(", mBTOption=");
        builder.append(this.mBTOption);
        builder.append(", mHostGroupNickName=");
        builder.append(this.mHostGroupNickName);
        builder.append(", mWWNNickName=");
        builder.append(this.mWWNNickName);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final Robj_interface_RJiHostGroupInfoDetail mInfoDetail;
        private final String mClientType;
        private final String mSystemName;
        private final String mCtrID;
        private final String mPortID;
        private final String mDomainID;
        private final String mHostWWN;
        private final boolean mHostWWNReq;
        private final TaskProcessor mTheTask;
        private final IteratorCallback<PortandHostGroupInfo> mCallback;
        private final boolean mContinueOnError;
        private final String mSerialNumber;

        private WorkerThread(String serialNum, TaskProcessor theTask, IteratorCallback<PortandHostGroupInfo> callback, Robj_interface_RJiHostGroupInfoDetail infoDetail, String systemName, String ctrID, String portID, String domainID, String hostWWN, boolean hostWWNReq, String clientType, boolean continueOnError) {
            this.mSerialNumber = serialNum;
            this.mInfoDetail = infoDetail;
            this.mTheTask = theTask;
            this.mCallback = callback;
            this.mSystemName = systemName;
            this.mCtrID = ctrID;
            this.mPortID = portID;
            this.mDomainID = domainID;
            this.mHostWWNReq = hostWWNReq;
            this.mContinueOnError = continueOnError;
            this.mHostWWN = hostWWN;
            this.mClientType = clientType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = PortandHostGroupInfo.processInfoDetail(this.mSerialNumber, this.mCallback, this.mInfoDetail, this.mSystemName, this.mCtrID, this.mPortID, this.mDomainID, this.mHostWWN, this.mHostWWNReq, this.mClientType, this.mContinueOnError))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Exception e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)((Object)e) : new WBEMException(1, "Exception while processing items", null, (Throwable)e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }
    }
}

