/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common.keyvalueapis;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.keyvalueapis.KeyValueAPIBaseObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiLDEVIndex;

public class MRCFreadTiPairOfSecondaryVolumes
extends KeyValueAPIBaseObject {
    public static final String SECONDARY_VOLUMES = "SecondaryVolumes";
    public static final String LDEV = "Ldev";
    private static String KeyValueFuncName = "MRCFreadTiPairOfSecondaryVolumes";
    private final Set<String> dns = new TreeSet<String>();

    public MRCFreadTiPairOfSecondaryVolumes(RMIObjectCache rmi, String clientIP) throws WBEMException {
        super(rmi, clientIP, KeyValueFuncName, true);
    }

    public void addDN(BaseDeviceNumber dn) throws WBEMException {
        this.addToRequest(dn.getLdkc(), dn.getCu(), dn.getLdev());
    }

    public void addDNs(List<? extends BaseDeviceNumber> dnList) throws WBEMException {
        for (BaseDeviceNumber baseDeviceNumber : dnList) {
            this.addDN(baseDeviceNumber);
        }
    }

    public void addLDEV(Robj_interface_RJiLDEVIndex ldevIndex) throws WBEMException {
        this.addToRequest(ldevIndex.getSLDKC(), ldevIndex.getSCU(), ldevIndex.getSLDEV());
    }

    public void addLDEVs(Robj_interface_RJiLDEVIndex[] ldevIndexArray) throws WBEMException {
        for (Robj_interface_RJiLDEVIndex ldevIdx : ldevIndexArray) {
            this.addLDEV(ldevIdx);
        }
    }

    private void addToRequest(short sldkc, short scu, short sldev) throws WBEMException {
        String dnNum = Long.toString(BaseDeviceNumber.makeUniqueDN(sldkc, scu, sldev));
        if (this.dns.contains(dnNum)) {
            logger.log(Level.SEVERE, "DN {0} is already part of the request, skipping", dnNum);
            return;
        }
        this.dns.add(dnNum);
        try {
            SanRequest request = this.getRequest();
            SanList secondaryVols = request.getList(SECONDARY_VOLUMES);
            if (null == secondaryVols) {
                logger.finer("Creating 'SecondaryVolumes' list");
                secondaryVols = request.newList(SECONDARY_VOLUMES);
            } else {
                logger.finer("Got 'SecondaryVolumes' list");
            }
            SanObject ldev = secondaryVols.addObj().newObj(LDEV);
            int[] ldevInf = new int[]{sldkc, scu, sldev};
            logger.log(Level.FINER, "Adding Volume {0}:{1}:{2} to request", (Object)ldevInf);
            ldev.putIntArray("Id", ldevInf);
        }
        catch (SanDataException e) {
            throw new WBEMException(1, "An error occured adding key value data", null, (Throwable)e);
        }
    }

    public List<TiPairData> getData() {
        ArrayList<TiPairData> ret = new ArrayList<TiPairData>();
        SanList secondaryVolumesList = this.invokeKVReadTiPairOfSecondaryVolumes();
        if (null != secondaryVolumesList && !secondaryVolumesList.isEmpty()) {
            for (SanObject secondaryVolumesObj : secondaryVolumesList) {
                try {
                    ret.add(new TiPairData(secondaryVolumesObj));
                }
                catch (WBEMException e) {
                    logger.log(Level.SEVERE, "Error getting DKC:CU:LDEV, skipping to next one", e);
                }
            }
        }
        return ret;
    }

    public List<String> getDns() {
        return new ArrayList<String>(this.dns);
    }

    public List<DeviceNumber> getUnpairedDNs() throws WBEMException {
        ArrayList<DeviceNumber> ret = new ArrayList<DeviceNumber>();
        List<TiPairData> results = this.getData();
        for (TiPairData ldevInfo : results) {
            if (0 != ldevInfo.getStatus()) {
                logger.log(Level.FINE, "Volume {0} is paired, skipping", ldevInfo.getPrimaryVolume());
                continue;
            }
            DeviceNumber dn = DeviceNumber.find(Long.toString(ldevInfo.getSecondaryVolume()), this.getRmiObject());
            if (null != dn) {
                ret.add(dn);
                continue;
            }
            logger.log(Level.SEVERE, "Unable to find volume {0} in the cache", ldevInfo.getSecondaryVolume());
        }
        return ret;
    }

    public SanList invokeKVReadTiPairOfSecondaryVolumes() {
        SanList ret = null;
        if (null == this.dns || this.dns.isEmpty()) {
            logger.log(Level.INFO, "No DNs for call");
            return ret;
        }
        try {
            this.getRmiObject().addAccountInfo(this.getGeneralParameter());
            SanResponse resp = this.getRmiObject().keyValueAPI_Invoke(KeyValueFuncName, this.getSanRemote(), this.getGeneralParameter(), this.getRequest(), true);
            ret = resp.getList(SECONDARY_VOLUMES);
        }
        catch (SanDataException | SanRmiException | RemoteException | WBEMException e) {
            logger.log(Level.SEVERE, "Error invoking " + KeyValueFuncName, e);
        }
        return ret;
    }

    public boolean isAllDNsHaveStatus(int status2Check) throws WBEMException {
        boolean ret = true;
        List<TiPairData> results = this.getData();
        for (TiPairData tiData : results) {
            if (status2Check == tiData.getStatus()) continue;
            logger.log(Level.FINE, "Volume {0} is not PSUS, stopping", tiData.getPrimaryVolume());
            ret = false;
            break;
        }
        return ret;
    }

    public boolean isAllDNsPaired() throws WBEMException {
        return this.isAllDNsHaveStatus(544);
    }

    public boolean isAllDNsPSUS() throws WBEMException {
        return this.isAllDNsHaveStatus(560);
    }

    public static class TiPairData {
        private long primaryVolume;
        private long secondaryVolume;
        private boolean isWritten;
        private long rootLDEV;
        private int mirrorUnit;
        private int[] snapshotDate;
        private int status;
        private int synchronousRate;
        private int ctg;
        private int snapshotGroup;
        private boolean cascade;
        private boolean clone;
        private int copyPace;

        public TiPairData(SanObject secondaryVolumesObj) throws WBEMException {
            try {
                SanObject tiPair;
                SanObject errorInf = secondaryVolumesObj.getObj("ErrorInfo");
                int errorVal = errorInf.getInt("ErrorCode");
                if (0 == errorVal) {
                    tiPair = secondaryVolumesObj.getObj("TiPair");
                    if (null == tiPair) {
                        int[] dkcCUldev = secondaryVolumesObj.getObj(MRCFreadTiPairOfSecondaryVolumes.LDEV).getIntArray("Id");
                        this.secondaryVolume = BaseDeviceNumber.makeUniqueDN((short)dkcCUldev[0], (short)dkcCUldev[1], (short)dkcCUldev[2]);
                        this.status = 0;
                        this.isWritten = false;
                        this.snapshotDate = null;
                        this.mirrorUnit = -1;
                        this.snapshotGroup = -1;
                        this.ctg = -1;
                        this.primaryVolume = -1;
                        this.copyPace = 0;
                        this.rootLDEV = -1L;
                        this.clone = false;
                        this.cascade = false;
                        return;
                    }
                    SanObject pvObject = tiPair.getObj("PrimaryVolume").getObj(MRCFreadTiPairOfSecondaryVolumes.LDEV);
                    int[] dkcfb4 = pvObject.getIntArray("Id");
                    this.primaryVolume = BaseDeviceNumber.makeUniqueDN((short)dkcfb4[0], (short)dkcfb4[1], (short)dkcfb4[2]);
                    SanObject secondaryVolumeObj = tiPair.getObj("SecondaryVolume");
                    int[] secondaryDkcCuFb = secondaryVolumeObj.getObj(MRCFreadTiPairOfSecondaryVolumes.LDEV).getIntArray("Id");
                    this.secondaryVolume = BaseDeviceNumber.makeUniqueDN((short)secondaryDkcCuFb[0], (short)secondaryDkcCuFb[1], (short)secondaryDkcCuFb[2]);
                    int writeHistory = secondaryVolumeObj.getInt("WriteHistory");
                    if (0 == writeHistory) {
                        this.isWritten = false;
                    } else if (1 == writeHistory) {
                        this.isWritten = true;
                    } else {
                        this.isWritten = false;
                        KeyValueAPIBaseObject.logger.log(Level.SEVERE, "Unknown 'WriteHistory' value: {0}. Default to false", writeHistory);
                    }
                } else {
                    throw new WBEMException(String.format("DN %d has error code %d, message ID %s", this.primaryVolume, errorVal, Arrays.toString(errorInf.getIntArray("MessageId"))));
                }
                int[] rootLDEVInts = tiPair.getObj("RootLdev").getIntArray("Id");
                this.rootLDEV = BaseDeviceNumber.makeUniqueDN((short)rootLDEVInts[0], (short)rootLDEVInts[1], (short)rootLDEVInts[2]);
                this.mirrorUnit = tiPair.getInt("MirrorUnit");
                this.snapshotDate = tiPair.getIntArray("SnapshotDate");
                this.status = tiPair.getInt("Status");
                this.synchronousRate = tiPair.getInt("SynchronousRate");
                SanObject ctgObj = tiPair.getObj("Ctg");
                this.ctg = null != ctgObj ? ctgObj.getInt("Id") : -1;
                SanObject snapshotGroupObj = tiPair.getObj("SnapshotGroup");
                this.snapshotGroup = null != snapshotGroupObj ? snapshotGroupObj.getInt("Id") : -1;
                this.cascade = tiPair.getBoolean("Cascade");
                this.clone = tiPair.getBoolean("Clone");
                this.copyPace = tiPair.getInt("CopyPace");
            }
            catch (SanDataException sde) {
                throw new WBEMException(1, "Exception getting TiPair data for volume " + this.primaryVolume, null, (Throwable)sde);
            }
        }

        public int getCopyPace() {
            return this.copyPace;
        }

        public int getCtg() {
            return this.ctg;
        }

        public int getMirrorUnit() {
            return this.mirrorUnit;
        }

        public long getPrimaryVolume() {
            return this.primaryVolume;
        }

        public long getRootLDEV() {
            return this.rootLDEV;
        }

        public long getSecondaryVolume() {
            return this.secondaryVolume;
        }

        public int[] getSnapshotDate() {
            return this.snapshotDate;
        }

        public int getSnapshotGroup() {
            return this.snapshotGroup;
        }

        public int getStatus() {
            return this.status;
        }

        public int getSynchronousRate() {
            return this.synchronousRate;
        }

        public boolean isCascade() {
            return this.cascade;
        }

        public boolean isClone() {
            return this.clone;
        }

        public boolean isWritten() {
            return this.isWritten;
        }
    }
}

