/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PGInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class AllocatedFromStoragePoolPrimordialInstrumentation
extends BaseAssocInstrumentation {
    protected AllocatedFromStoragePoolPrimordialInstrumentation() {
        super("HITACHI_AllocatedFromStoragePoolPrimordial", "HITACHI_StoragePoolPrimordial", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolPrimordialInstrumentation"), "HITACHI_StoragePool", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_AllocatedFromStoragePoolPrimordial".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instStoragePoolPrimordial = null;
                    try {
                        instStoragePoolPrimordial = this.getReference1Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instStoragePoolPrimordial) {
                        CIMObjectPath opStoragePool = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), new CIMProperty[]{objectName.getKey("InstanceID")});
                        CustomCloseableIterator iterStoragePool = new CustomCloseableIterator();
                        this.getReference2Instrumentation().enumerate(iterStoragePool, opStoragePool, null, null, null, false, false, null, null);
                        while (iterStoragePool.hasNext()) {
                            CIMInstance instStoragePool = (CIMInstance)iterStoragePool.next();
                            if (!ProviderConstants.UINT16_ONE.equals(instStoragePool.getPropertyValue("ConsistsOf"))) continue;
                            if (isObjectPath) {
                                iter.add(instStoragePool.getObjectPath());
                                continue;
                            }
                            iter.add(instStoragePool.filterProperties(propertyList));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instStoragePool = null;
                    try {
                        instStoragePool = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instStoragePool && ProviderConstants.UINT16_ONE.equals(instStoragePool.getPropertyValue("ConsistsOf"))) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(instStoragePool.getObjectPath(), "InstanceID");
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStoragePoolPrimordial = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                CustomCloseableIterator iterStoragePool = new CustomCloseableIterator();
                CIMObjectPath opStoragePool = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), new CIMProperty[]{opStoragePoolPrimordial.getKey("InstanceID")});
                this.getReference2Instrumentation().enumerate(iterStoragePool, opStoragePool, null, filterQueryLanguage, filterQuery, continueOnError, false, null, null);
                while (iterStoragePool.hasNext()) {
                    CIMInstance instStoragePool = (CIMInstance)iterStoragePool.next();
                    CIMProperty cpConsistsOf = instStoragePool.getProperty("ConsistsOf");
                    boolean isExternal = null != cpConsistsOf ? ProviderConstants.UINT16_TWO.equals(cpConsistsOf.getValue()) : false;
                    if (isExternal) continue;
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opStoragePoolPrimordial, instStoragePool.getObjectPath()));
                        continue;
                    }
                    iter.add(this.generateInstance(objectName, propertyList, opStoragePoolPrimordial, instStoragePool.getObjectPath()));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath opObjectName, String[] propList, Object ... o) throws Exception {
        CIMObjectPath opAssoc = this.generateObjectPath(opObjectName, o);
        CIMObjectPath opStoragePool = (CIMObjectPath)o[1];
        try {
            long pgSize;
            CIMProperty key1 = opAssoc.getKey(this.getReference1PropertyName());
            CIMProperty key2 = opAssoc.getKey(this.getReference2PropertyName());
            CIMProperty[] props = new CIMProperty[3];
            props[0] = key1;
            props[1] = key2;
            CIMProperty instID = opStoragePool.getKey("InstanceID");
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStoragePool, "InstanceID");
            ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), false, (String)instID.getValue());
            if (cag != null) {
                long result = 0L;
                PGInfo pg = PGInfo.find(device.getRMIObject(), cag.getFb4(), cag.getPg());
                if (pg == null) {
                    throw new WBEMException("Unable to match ChassisArrayGroup, " + cag.getFb4() + "." + cag.getPg() + ", to PGInfo");
                }
                pgSize = pg.getLpDevSizeDependOnCE() * 512L * (long)pg.getSPDEVCount();
            } else {
                throw new WBEMException("Unable to find a matching CAG for pool: " + opStoragePool);
            }
            UnsignedInteger64 value = new UnsignedInteger64(BigInteger.valueOf(result += pgSize));
            props[2] = new CIMProperty("SpaceConsumed", CIMDataType.UINT64_T, (Object)value, false);
            return new CIMInstance(opAssoc, props).filterProperties(propList);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block8: {
            try {
                CIMInstance instReference2;
                String pnReference1 = this.getReference1PropertyName();
                CIMObjectPath opReference1 = opObjectName.getKey(pnReference1) != null ? (CIMObjectPath)opObjectName.getKey(pnReference1).getValue() : null;
                CIMInstance instReference1 = null;
                try {
                    instReference1 = this.getReference1Instrumentation().getInstance(opReference1, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null == instReference1) break block8;
                String pnReference2 = this.getReference2PropertyName();
                CIMObjectPath opReference2 = opObjectName.getKey(pnReference2) != null ? (CIMObjectPath)opObjectName.getKey(pnReference2).getValue() : null;
                try {
                    instReference2 = this.getReference2Instrumentation().getInstance(opReference2, null);
                }
                catch (WBEMException we) {
                    instReference2 = null;
                }
                if (null != instReference2) {
                    CIMInstance instReturn = this.generateInstance(opObjectName, propertyList, instReference1.getObjectPath(), instReference2.getObjectPath());
                    return instReturn.filterProperties(propertyList);
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_AllocatedFromStoragePoolPrimordial".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instStoragePoolPrimordial = null;
                    try {
                        instStoragePoolPrimordial = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instStoragePoolPrimordial) {
                        CIMObjectPath opStoragePool = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), new CIMProperty[]{objectName.getKey("InstanceID")});
                        CustomCloseableIterator iterStoragePool = new CustomCloseableIterator();
                        this.getReference2Instrumentation().enumerate(iterStoragePool, opStoragePool, null, null, null, false, false, null, null);
                        while (iterStoragePool.hasNext()) {
                            CIMInstance instStoragePool = (CIMInstance)iterStoragePool.next();
                            if (!ProviderConstants.UINT16_ONE.equals(instStoragePool.getPropertyValue("ConsistsOf"))) continue;
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, instStoragePoolPrimordial.getObjectPath(), instStoragePool.getObjectPath()));
                                continue;
                            }
                            iter.add(this.generateInstance(objectName, propertyList, instStoragePoolPrimordial.getObjectPath(), instStoragePool.getObjectPath()));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instStoragePool = null;
                    try {
                        instStoragePool = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instStoragePool && new UnsignedInteger16(1).equals(instStoragePool.getPropertyValue("ConsistsOf"))) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()), instStoragePool.getObjectPath()));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()), instStoragePool.getObjectPath()));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

