/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class AllocatedFromStoragePoolViewInstrumentation
extends BaseAssocInstrumentation {
    protected AllocatedFromStoragePoolViewInstrumentation() {
        super("HITACHI_AllocatedFromStoragePoolView", "HITACHI_StoragePool", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolInstrumentation"), "HITACHI_VolumeView", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.VolumeViewInstrumentation"));
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath objectName, String[] propertyList, Object ... o) throws Exception {
        if (null == o || o.length < 2) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_INSTANCE_ILLEGAL_ARGUMENT + " " + "HITACHI_AllocatedFromStoragePoolView");
        }
        CIMObjectPath opAssoc = this.generateObjectPath(objectName, o[0], o[1]);
        CIMProperty key1 = opAssoc.getKey(this.getReference1PropertyName());
        CIMProperty key2 = opAssoc.getKey(this.getReference2PropertyName());
        CIMProperty<UnsignedInteger64> scProp = this.getSpaceConsumedProperty((CIMObjectPath)o[1]);
        CIMProperty[] props = new CIMProperty[]{key1, key2, scProp};
        return new CIMInstance(opAssoc, props).filterProperties(propertyList);
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        CIMProperty cpSearchKey = objectName.getKey("SPInstanceID");
        String instID = null != objectName && null != cpSearchKey ? (String)cpSearchKey.getValue() : null;
        hTable.put("InstanceID", instID);
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        CIMProperty cpSearchKey = objectName.getKey("InstanceID");
        String deviceID = null != objectName && null != cpSearchKey ? (String)cpSearchKey.getValue() : null;
        hTable.put("SPInstanceID", deviceID);
        return hTable;
    }

    private CIMProperty<UnsignedInteger64> getSpaceConsumedProperty(CIMObjectPath opVolView) throws WBEMException {
        UnsignedInteger64 scVal;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opVolView, "SPInstanceID");
        CIMProperty devID = opVolView.getKey("SVDeviceID");
        String devIDVal = (String)devID.getValue();
        DeviceNumber dn = DeviceNumber.find(devIDVal, true, device.getRMIObject());
        if (dn != null) {
            scVal = new UnsignedInteger64(BigInteger.valueOf(dn.getSpaceConsumed()));
        } else {
            String msg = "Unable to find DevNum: " + devIDVal;
            mLogger.log(Level.SEVERE, msg, new Exception(msg));
            scVal = ProviderConstants.UINT64_ZED;
        }
        return new CIMProperty("AFSPSpaceConsumed", CIMDataType.UINT64_T, (Object)scVal, false);
    }
}

