/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class AllocatedFromUnpairedSnapshotVolumePoolInstrumentation
extends BaseAssocInstrumentation {
    protected AllocatedFromUnpairedSnapshotVolumePoolInstrumentation() {
        super("HITACHI_AllocatedFromUnpairedSnapshotVolumePool", "HITACHI_UnpairedSnapshotVolumePool", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.UnpairedSnapshotVolumePoolInstrumentation"), "HITACHI_StorageVolume", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_AllocatedFromUnpairedSnapshotVolumePool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference2Instrumentation().instanceExists(objectName)) {
                        String deviceNum;
                        DeviceNumber dn;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                        if (null != cpDeviceID && null != (dn = DeviceNumber.find(deviceNum = (String)cpDeviceID.getValue(), device.getRMIObject())) && dn.isQSVvol() && !this.isInPair(dn)) {
                            if (isObjectPath) {
                                iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                            } else {
                                iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    DeviceNumber dn;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
                    DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1, true, VolumeTypeEnum.QSVVOL);
                    LinkedList<DeviceNumber> elements = callback.getReturnValue();
                    callback = null;
                    while (null != (dn = elements.poll())) {
                        if (this.isInPair(dn)) continue;
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, dn));
                            continue;
                        }
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, dn));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                DeviceNumber dn;
                CIMObjectPath opUnpairedSSCP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
                DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1, true, VolumeTypeEnum.QSVVOL);
                LinkedList<DeviceNumber> elements = callback.getReturnValue();
                callback = null;
                while (null != (dn = elements.poll())) {
                    if (this.isInPair(dn)) continue;
                    CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(op, dn);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opUnpairedSSCP, opStorageVolume));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opUnpairedSSCP, opStorageVolume));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        CIMProperty[] props = new CIMProperty[]{new CIMProperty("SpaceConsumed", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false)};
        return props;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block9: {
            try {
                String pnStorageVolume = this.getReference2PropertyName();
                CIMObjectPath opStorageVolume = opObjectName.getKey(pnStorageVolume) != null ? (CIMObjectPath)opObjectName.getKey(pnStorageVolume).getValue() : null;
                CIMInstance instStorageVolume = null;
                try {
                    instStorageVolume = this.getReference2Instrumentation().getInstance(opStorageVolume, null);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null == instStorageVolume) break block9;
                String pnUnpairedSSCP = this.getReference1PropertyName();
                CIMObjectPath opUnpairedSSCP = opObjectName.getKey(pnUnpairedSSCP) != null ? (CIMObjectPath)opObjectName.getKey(pnUnpairedSSCP).getValue() : null;
                CIMInstance instUnpairedSSCP = null;
                try {
                    instUnpairedSSCP = this.getReference1Instrumentation().getInstance(opUnpairedSSCP, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instUnpairedSSCP) {
                    opStorageVolume = instStorageVolume.getObjectPath();
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVolume, "SystemName");
                    String cpvDeviceID = (String)instStorageVolume.getPropertyValue("DeviceID");
                    DeviceNumber dn = DeviceNumber.find(cpvDeviceID, device.getRMIObject());
                    if (null != dn && dn.isQSVvol()) {
                        return this.generateInstance(opObjectName, propertyList, opUnpairedSSCP, opStorageVolume);
                    }
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    private boolean isInPair(DeviceNumber dn) throws WBEMException {
        boolean ret = false;
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, dn.getDNAsString(), Boolean.TRUE);
        LinkedList<SnapshotInfo2> retList = callback.getReturnValue();
        if (null != retList && retList.size() > 0) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_AllocatedFromUnpairedSnapshotVolumePool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    DeviceNumber dn;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath opUnpairedSSCP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
                    DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1, true, VolumeTypeEnum.QSVVOL);
                    LinkedList<DeviceNumber> elements = callback.getReturnValue();
                    callback = null;
                    while (null != (dn = elements.poll())) {
                        if (this.isInPair(dn)) continue;
                        CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(objectName, dn);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opUnpairedSSCP, opStorageVolume));
                            continue;
                        }
                        iter.add(this.generateInstance(objectName, propertyList, opUnpairedSSCP, opStorageVolume));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    String deviceNum;
                    DeviceNumber dn;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMObjectPath opUnpairedSSCP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID && null != (dn = DeviceNumber.find(deviceNum = (String)cpDeviceID.getValue(), device.getRMIObject())) && dn.isQSVvol() && !this.isInPair(dn)) {
                        CIMObjectPath opStorageVolume = this.getReference2Instrumentation().generateObjectPath(objectName, dn);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opUnpairedSSCP, opStorageVolume));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, opUnpairedSSCP, opStorageVolume));
                        }
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }
}

