/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DKStatusInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_DISKgetDKCStatusInfo;

public class BatteryInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevicesFromObjectPath(op, "SystemName");
        if (null != expectedValues) {
            String instID = (String)expectedValues.get("SystemName");
            if (null != instID) {
                String serial = ProviderLibs.getSerialFromString(instID);
                devices.clear();
                devices.add(RMIObjectMapping.getRMIObjectMapping(serial));
            }
            if (1 != devices.size()) {
                throw new WBEMException("HITACHI_SCSIProtocolController.enumerate called for association but found insf. managed devices. Found devices: " + devices.size() + ", expectedValues: " + expectedValues);
            }
        }
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath retOP;
                if (null != refInfo) {
                    retOP = this.generateObjectPath(op, device.getRMIObject());
                    refInfo.addReference(iter, retOP);
                    continue;
                }
                if (isObjectPath) {
                    retOP = this.generateObjectPath(op, device.getRMIObject());
                    iter.add(retOP);
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath opInstance = this.generateObjectPath(op, o);
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String cvBatteryName = "DKC Battery";
        UnsignedInteger16 cvStatus = null;
        String[] cvDescription = new String[1];
        DKStatusInfo dkStatusInfo = DKStatusInfo.getDKStatusInfo(rmiObj);
        Robj_interface_DISKgetDKCStatusInfo info = dkStatusInfo.getDKCStatusInfo();
        int status = info.getNDKCHWBattery();
        switch (status) {
            case 1: {
                cvStatus = ProviderConstants.UINT16_TWO;
                cvDescription[0] = ProviderConstants.getOpStatusDescription(2);
                break;
            }
            case 2: {
                cvStatus = new UnsignedInteger16(6);
                cvDescription[0] = ProviderConstants.getOpStatusDescription(6);
                break;
            }
            case 3: {
                cvStatus = new UnsignedInteger16(5);
                cvDescription[0] = ProviderConstants.getOpStatusDescription(5);
                break;
            }
            case 4: {
                cvStatus = new UnsignedInteger16(4);
                cvDescription[0] = ProviderConstants.getOpStatusDescription(4);
                break;
            }
            case 5: {
                cvStatus = new UnsignedInteger16(11);
                cvDescription[0] = ProviderConstants.getOpStatusDescription(11);
                break;
            }
            default: {
                mLogger.severe("Unexpected value battery status: " + status);
            }
        }
        CIMProperty[] props = new CIMProperty[]{opInstance.getKey("SystemName"), opInstance.getKey("SystemCreationClassName"), opInstance.getKey("CreationClassName"), opInstance.getKey("DeviceID"), new CIMProperty("Name", CIMDataType.STRING_T, (Object)"DKC Battery", false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{cvStatus}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)cvDescription, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"DKC Battery", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"DKC Battery", false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"DKC Battery", false)};
        return new CIMInstance(opInstance, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_Battery");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)"DKC Battery", true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_Battery", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)rmiObj.getSMISMappingContainer().getStorageSystemName(), true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_Battery", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName", ".", 1);
        if (null == device) {
            throw new WBEMException(6, "Could not find managed device information: " + op);
        }
        try {
            if (op.equalsModelPath(this.generateObjectPath(op, device.getRMIObject()))) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

