/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class ComposedSnapshotPoolInstrumentation
extends BaseAssocInstrumentation {
    protected ComposedSnapshotPoolInstrumentation() {
        super("HITACHI_ComposedSnapshotPool", "HITACHI_StorageVolume", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"), "HITACHI_SnapshotPool", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SnapshotPoolInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ComposedSnapshotPool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (!shouldTestInst || this.getReference2Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        CIMProperty cpPoolID = objectName.getKey("InstanceID");
                        String strPoolID = (String)cpPoolID.getValue();
                        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                        this.getStorageVolumesFromSnapshotPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, poolID, true);
                    }
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference1PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference2PropertyName()) || shouldTestInst && !this.getReference1Instrumentation().instanceExists(objectName))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String strDevID = (String)cpDevID.getValue();
                    ThinPool tp = ThinPool.find(device.getRMIObject(), Long.valueOf(strDevID), ThinPool.ThinPoolType.QS);
                    if (tp != null) {
                        if (isObjectPath) {
                            CIMObjectPath retOP = this.getReference2Instrumentation().generateObjectPath(objectName, tp);
                            if (retOP != null) {
                                iter.add(retOP);
                            }
                        } else {
                            CIMInstance ret = this.getReference2Instrumentation().generateInstance(objectName, propertyList, tp);
                            if (ret != null) {
                                iter.add(ret);
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        block6: {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            try {
                for (RMIObjectMapping device : devices) {
                    this.getStorageVolumesFromSnapshotPool(device.getRMIObject(), iter, op, propertyList, isObjectPath, (short)-1, false);
                }
            }
            catch (WBEMException we) {
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            catch (Throwable th) {
                if (null == iter) break block6;
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block8: {
            try {
                String pnReference2 = this.getReference2PropertyName();
                CIMObjectPath opReference2 = opObjectName.getKey(pnReference2) != null ? (CIMObjectPath)opObjectName.getKey(pnReference2).getValue() : null;
                CIMInstance instReference2 = null;
                try {
                    instReference2 = this.getReference2Instrumentation().getInstance(opReference2, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null == instReference2) break block8;
                String pnReference1 = this.getReference1PropertyName();
                CIMObjectPath opReference1 = opObjectName.getKey(pnReference1) != null ? (CIMObjectPath)opObjectName.getKey(pnReference1).getValue() : null;
                CIMInstance instReference1 = null;
                try {
                    instReference1 = this.getReference1Instrumentation().getInstance(opReference1, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instReference1) {
                    opReference2 = instReference2.getObjectPath();
                    CIMInstance instReturn = this.generateInstance(opObjectName, propertyList, instReference2.getObjectPath(), instReference1.getObjectPath());
                    return instReturn.filterProperties(propertyList);
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    private void getStorageVolumesFromSnapshotPool(RMIObjectCache objCache, CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, boolean isObjectPath, short tPoolID, boolean isAssocCall) throws Exception {
        CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
        ThinPool.getThinPools(objCache, callback, tPoolID, false);
        LinkedList<ThinPool> tPools = callback.getReturnValue();
        callback = null;
        ThinPool tp = tPools.poll();
        while (tp != null) {
            CIMObjectPath depObj = this.getReference2Instrumentation().generateObjectPath(op, tp);
            Set<String> containedDNs = tp.getContainingLDEVs();
            for (String DN : containedDNs) {
                DeviceNumber data = DeviceNumber.find(DN, true, objCache);
                CIMObjectPath antObj = this.getReference1Instrumentation().generateObjectPath(op, data);
                if (data == null) continue;
                if (isObjectPath) {
                    CIMObjectPath retOP = !isAssocCall ? this.generateObjectPath(op, antObj, depObj) : antObj;
                    if (retOP == null) continue;
                    iter.add(retOP);
                    continue;
                }
                CIMInstance ret = !isAssocCall ? this.generateInstance(op, propertyList, antObj, depObj) : this.getReference1Instrumentation().generateInstance(op, propertyList, data);
                if (ret == null) continue;
                iter.add(ret);
            }
            tp = tPools.poll();
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ComposedSnapshotPool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference2Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        CIMProperty cpPoolID = objectName.getKey("InstanceID");
                        String strPoolID = (String)cpPoolID.getValue();
                        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                        this.getStorageVolumesFromSnapshotPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, poolID, false);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String strDevID = (String)cpDevID.getValue();
                    ThinPool tp = ThinPool.find(device.getRMIObject(), Long.valueOf(strDevID), ThinPool.ThinPoolType.QS);
                    if (tp != null) {
                        CIMObjectPath depObj = this.getReference2Instrumentation().generateObjectPath(objectName, tp);
                        CIMObjectPath antOp = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                        if (isObjectPath) {
                            CIMObjectPath retOP = this.generateObjectPath(objectName, antOp, depObj);
                            if (retOP != null) {
                                iter.add(retOP);
                            }
                        } else {
                            CIMInstance ret = this.generateInstance(objectName, propertyList, antOp, depObj);
                            if (ret != null) {
                                iter.add(ret);
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }
}

