/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ChassisInfo;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class DKUChassisDiskDriveViewInstrumentation
extends BaseAssocInstrumentation {
    protected DKUChassisDiskDriveViewInstrumentation() {
        super("HITACHI_DKUChassisDiskDriveView", "HITACHI_DKUChassis", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DKUChassisInstrumentation"), "HITACHI_DiskDriveView", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveViewInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        block18: {
            try {
                int[] deviceIDValues;
                CIMProperty ddvID;
                boolean needToCloseIter = true;
                if (null == assocName || !"HITACHI_DKUChassisDiskDriveView".equalsIgnoreCase(assocName.getObjectName())) break block18;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMObjectPath opDKU;
                    CIMProperty tagProp;
                    CIMInstance dkuInst;
                    block19: {
                        dkuInst = null;
                        try {
                            dkuInst = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) break block19;
                            throw e;
                        }
                    }
                    if (null != dkuInst && null != (tagProp = (opDKU = dkuInst.getObjectPath()).getKey("Tag"))) {
                        String tag = (String)tagProp.getValue();
                        Hashtable<String, Object> depSearchProps = new Hashtable<String, Object>();
                        depSearchProps.put("DDSystemName", tag);
                        CIMObjectPath depOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                        needToCloseIter = false;
                        this.getReference2Instrumentation().enumerate(iter, depOP, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, depSearchProps, null);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && null != (ddvID = objectName.getKey("DDDeviceID")) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID((String)ddvID.getValue()))) {
                    String chassisLocation;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "DDSystemName");
                    try {
                        ChassisInfo info = ChassisInfo.getChassisInfo(device.getSerialNumber());
                        chassisLocation = info.getChassisLocation(deviceIDValues[0], deviceIDValues[1]);
                    }
                    catch (WBEMException we) {
                        mLogger.log(Level.SEVERE, "Error getting ChassisInfo", we);
                        chassisLocation = null;
                    }
                    if (null != chassisLocation) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject(), String.valueOf(chassisLocation)));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject(), String.valueOf(chassisLocation)));
                        }
                    }
                }
                if (null != iter && needToCloseIter) {
                    iter.done();
                }
            }
            catch (WBEMException we) {
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            catch (Throwable th) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                Callback<PDEVInfoEntry> callback = new Callback<PDEVInfoEntry>(deviceIter, isObjectPath, null, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1, null, -1, -1);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath ddvOP;
            String dkuPropName = this.getReference1PropertyName();
            CIMObjectPath dkuOP = op.getKey(dkuPropName) != null ? (CIMObjectPath)op.getKey(dkuPropName).getValue() : null;
            String ddvPropName = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = ddvOP = op.getKey(ddvPropName) != null ? (CIMObjectPath)op.getKey(ddvPropName).getValue() : null;
            if (null != ddvOP && null != dkuOP && this.getReference1Instrumentation().instanceExists(dkuOP) && this.getReference2Instrumentation().instanceExists(ddvOP)) {
                PDEVInfoEntry entry;
                int[] deviceIDValues;
                String dkuTag = (String)dkuOP.getKey("Tag").getValue();
                String deviceID = (String)ddvOP.getKey("DDDeviceID").getValue();
                String serial = ProviderLibs.getSerialFromString(dkuTag);
                String chassisID = ProviderLibs.getEndString(dkuTag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                if (null != serial && null != chassisID && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(deviceID)) && null != (entry = PDEVInfoEntry.find(RMIObjectMapping.getRMIObjectMapping(serial).getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && chassisID.equals(entry.getChassisLocation())) {
                    return this.generateInstance(op, propertyList, dkuOP, ddvOP);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        block23: {
            boolean needToCloseIter = true;
            try {
                if (null == assocName || !"HITACHI_DKUChassisDiskDriveView".equalsIgnoreCase(assocName.getObjectName())) {
                    return;
                }
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance dkuInst;
                    block22: {
                        dkuInst = null;
                        try {
                            dkuInst = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) break block22;
                            throw e;
                        }
                    }
                    if (null != dkuInst) {
                        CIMObjectPath opDKU = dkuInst.getObjectPath();
                        CIMProperty tagProp = opDKU.getKey("Tag");
                        String tag = (String)tagProp.getValue();
                        String serial = ProviderLibs.getSerialFromString(tag);
                        String chassisID = ProviderLibs.getEndString(tag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        if (null != serial && null != chassisID) {
                            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serial);
                            if (null != device) {
                                needToCloseIter = false;
                                Callback<PDEVInfoEntry> callback = new Callback<PDEVInfoEntry>(iter, isObjectPath, null, opDKU, propertyList);
                                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1, chassisID, -1, -1);
                            }
                        } else {
                            mLogger.log(Level.SEVERE, "Could not find device: {0}", tag);
                        }
                    }
                    break block23;
                }
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    PDEVInfoEntry entry;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "DDSystemName");
                    CIMProperty ddvIDProp = objectName.getKey("DDDeviceID");
                    int[] deviceIDValues = PDEVInfoEntry.parseDeviceID((String)ddvIDProp.getValue());
                    if (null != deviceIDValues && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && null != entry.getChassisLocation()) {
                        CIMObjectPath opDKU = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject(), entry.getChassisLocation());
                        CIMObjectPath opDDV = this.getReference2Instrumentation().generateObjectPath(objectName, entry);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opDKU, opDDV));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, opDKU, opDDV));
                        }
                    }
                }
            }
            catch (WBEMException we) {
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            catch (Throwable th) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            finally {
                if (null != iter && needToCloseIter) {
                    iter.done();
                }
            }
        }
    }

    private class Callback<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        protected Callback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) {
                ret = false;
            } else {
                try {
                    E entry = item;
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)entry).getSerialNumber());
                    CIMObjectPath opDKU = DKUChassisDiskDriveViewInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, device.getRMIObject(), String.valueOf(((PDEVInfoEntry)entry).getChassisLocation()));
                    CIMObjectPath opPD = DKUChassisDiskDriveViewInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, entry);
                    if (this.mIsObjectPath) {
                        this.mIter.add(DKUChassisDiskDriveViewInstrumentation.this.generateObjectPath(this.mOP, opDKU, opPD));
                    } else {
                        this.mIter.add(DKUChassisDiskDriveViewInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opDKU, opPD));
                    }
                }
                catch (Exception e) {
                    WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return ret;
        }
    }
}

