/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class ElementStorageClientSettingDataSCSIPCInstrumentation
extends BaseAssocInstrumentation {
    private static final String CPN_CLIENT_TYPES = "ClientTypes";

    protected ElementStorageClientSettingDataSCSIPCInstrumentation() {
        super("HITACHI_ElementStorageClientSettingDataSCSIPC", "HITACHI_SCSIProtocolController", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"), "HITACHI_StorageClientSettingData", "SettingData", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageClientSettingDataInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ElementStorageClientSettingDataSCSIPC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance settings;
                    try {
                        settings = this.getReference1Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        if (we.getID() != 6) {
                            throw we;
                        }
                        settings = null;
                    }
                    if (settings != null) {
                        Hashtable<String, Object> settingsExpectedData = this.getExpectedSettingsValue(settings);
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, settingsExpectedData, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    Hashtable<String, Object> expectValues = this.getExpectedProtocolValue(objectName);
                    this.getReference1Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectValues, null);
                    needToCloseIter = false;
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CustomCloseableIterator iterSCSIProtocolController = new CustomCloseableIterator();
                CIMObjectPath opSCSIProtocolController = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference1ClassName(), null);
                Hashtable<String, Object> hTable = new Hashtable<String, Object>();
                hTable.put("ElementName", device.getStorageSystemName());
                this.getReference1Instrumentation().enumerate(iterSCSIProtocolController, opSCSIProtocolController, null, filterQueryLanguage, filterQuery, continueOnError, false, hTable, null);
                CIMObjectPath opStorageClientSettingData = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), null);
                while (iterSCSIProtocolController.hasNext()) {
                    CIMInstance inst = (CIMInstance)iterSCSIProtocolController.next();
                    Hashtable<String, Object> settingsExpectedValues = this.getExpectedSettingsValue(inst);
                    CustomCloseableIterator iterStorageClientSettingData = new CustomCloseableIterator();
                    this.getReference2Instrumentation().enumerate(iterStorageClientSettingData, opStorageClientSettingData, null, filterQueryLanguage, filterQuery, continueOnError, false, settingsExpectedValues, null);
                    ArrayList<CIMInstance> listStorageClientSettingData = ProviderLibs.iteratorToArrayList(iterStorageClientSettingData);
                    opSCSIProtocolController = inst.getObjectPath();
                    for (CIMInstance instStorageClientSettingData : listStorageClientSettingData) {
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(op, opSCSIProtocolController, instStorageClientSettingData.getObjectPath()));
                            continue;
                        }
                        iter.add(this.generateInstance(op, propertyList, opSCSIProtocolController, instStorageClientSettingData));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{CIMObjectPath.class, CIMInstance.class}, o, "HITACHI_ElementStorageClientSettingDataSCSIPC");
        CIMObjectPath opSCSIProtocolControllerInstrumentation = (CIMObjectPath)o[0];
        CIMInstance instStorageClientSettingData = (CIMInstance)o[1];
        CIMObjectPath opAssoc = this.generateObjectPath(op, opSCSIProtocolControllerInstrumentation, instStorageClientSettingData.getObjectPath());
        CIMProperty key1 = opAssoc.getKey(this.getReference1PropertyName());
        CIMProperty key2 = opAssoc.getKey(this.getReference2PropertyName());
        UnsignedInteger16[] clientTypes = null != instStorageClientSettingData.getPropertyValue(CPN_CLIENT_TYPES) ? (UnsignedInteger16[])instStorageClientSettingData.getPropertyValue(CPN_CLIENT_TYPES) : null;
        int isDefault = ProviderLibs.valueExist(clientTypes, 2) ? 1 : 2;
        CIMProperty[] props = new CIMProperty[]{key1, key2, new CIMProperty("IsDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(isDefault), false), new CIMProperty("IsCurrent", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(1), false)};
        return new CIMInstance(opAssoc, props).filterProperties(propList);
    }

    private Hashtable<String, Object> getExpectedProtocolValue(CIMObjectPath op) {
        CIMProperty cpInstID;
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        if (null != op && null != (cpInstID = op.getKey("InstanceID"))) {
            String instID = (String)cpInstID.getValue();
            ret.put("ElementName", instID);
            String clientType = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            ret.put("InstanceID", clientType);
        }
        return ret;
    }

    private Hashtable<String, Object> getExpectedSettingsValue(CIMInstance inst) {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        if (null != inst) {
            String cvSysName = (String)inst.getPropertyValue("SystemName");
            ret.put("ElementName", cvSysName);
            CIMProperty cpHostMode = inst.getProperty("HostMode");
            if (null != cpHostMode) {
                UnsignedInteger16 hostMode = (UnsignedInteger16)cpHostMode.getValue();
                ret.put("HostMode", hostMode);
            }
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opStorageClientSettingData;
            String cpnSCSIProtocolController = this.getReference1PropertyName();
            CIMObjectPath opSCSIProtocolController = op.getKey(cpnSCSIProtocolController) != null ? (CIMObjectPath)op.getKey(cpnSCSIProtocolController).getValue() : null;
            String cpnStorageClientSettingData = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opStorageClientSettingData = op.getKey(cpnStorageClientSettingData) != null ? (CIMObjectPath)op.getKey(cpnStorageClientSettingData).getValue() : null;
            if (null != opSCSIProtocolController && null != opStorageClientSettingData) {
                try {
                    CIMInstance instSCSIProtocolController = this.getReference1Instrumentation().getInstance(opSCSIProtocolController, null);
                    CIMInstance instStorageClientSettingData = this.getReference2Instrumentation().getInstance(opStorageClientSettingData, null);
                    return this.generateInstance(op, propertyList, instSCSIProtocolController.getObjectPath(), instStorageClientSettingData);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ElementStorageClientSettingDataSCSIPC".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instSCSIProtocolController = null;
                    try {
                        instSCSIProtocolController = this.getReference1Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instSCSIProtocolController) {
                        CIMObjectPath opStorageClientSettingData = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                        Hashtable<String, Object> settingsExpectedData = this.getExpectedSettingsValue(instSCSIProtocolController);
                        CustomCloseableIterator iterStorageClientSettingData = new CustomCloseableIterator();
                        this.getReference2Instrumentation().enumerate(iterStorageClientSettingData, opStorageClientSettingData, null, null, null, continueOnError, false, settingsExpectedData, null);
                        while (iterStorageClientSettingData.hasNext()) {
                            CIMInstance instStorageClientSettingData = (CIMInstance)iterStorageClientSettingData.next();
                            if (null == instStorageClientSettingData) continue;
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, instSCSIProtocolController.getObjectPath(), instStorageClientSettingData.getObjectPath()));
                                continue;
                            }
                            iter.add(this.generateInstance(objectName, propertyList, instSCSIProtocolController.getObjectPath(), instStorageClientSettingData));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instStorageClientSettingData = null;
                    try {
                        instStorageClientSettingData = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instStorageClientSettingData) {
                        CIMObjectPath opSCSIProtocolController = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference1ClassName(), null);
                        Hashtable<String, Object> expectValues = this.getExpectedProtocolValue(objectName);
                        CustomCloseableIterator iterSCSIProtocolController = new CustomCloseableIterator();
                        this.getReference1Instrumentation().enumerate(iterSCSIProtocolController, opSCSIProtocolController, null, null, null, continueOnError, false, expectValues, null);
                        while (iterSCSIProtocolController.hasNext()) {
                            CIMInstance instSCSIProtocolController = (CIMInstance)iterSCSIProtocolController.next();
                            if (null == instSCSIProtocolController) continue;
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, instSCSIProtocolController.getObjectPath(), instStorageClientSettingData.getObjectPath()));
                                continue;
                            }
                            iter.add(this.generateInstance(objectName, propertyList, instSCSIProtocolController.getObjectPath(), instStorageClientSettingData));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

