/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.wbem.WBEMException;

public class LDEVExtentInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_LDEVExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_LDEVExtent added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_LDEVExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_LDEVExtent deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                DeviceNumber dn = (DeviceNumber)pObj;
                DeviceNumber newDN = DeviceNumber.find(dn.getDNAsString(), RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getRMIObject());
                if (newDN != null) {
                    CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_LDEVExtent", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                    CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                    CIMInstance sourceInstance = this.generateInstance(op, null, newDN);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a volume that with Device ID: " + dn.getDNAsString());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_LDEVExtent modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            ChassisArrayGroup cag = null;
            String deviceID = null;
            if (expectedValues != null && expectedValues.size() > 0) {
                if (1 != devices.size()) {
                    throw new WBEMException("expectedValues was not null but did not get 1 managed device. Number of devices: " + devices.size() + ", expectedValues: " + expectedValues);
                }
                deviceID = (String)expectedValues.get("DeviceID");
                if (deviceID == null) {
                    String expInstID;
                    String string = expInstID = null != expectedValues ? (String)expectedValues.get("InstanceID") : null;
                    if (expInstID != null) {
                        Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                        int fb4 = rets[0];
                        int ag = rets[1];
                        cag = ChassisArrayGroup.find(devices.get(0).getRMIObject(), null, fb4, ag, isObjectPath);
                        if (cag == null) {
                            iter.close();
                            return;
                        }
                    } else {
                        mLogger.warning("ExpectedValues contains unknown values: " + expectedValues.toString());
                    }
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                LDEVCallback<DeviceNumber> callback = new LDEVCallback<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList);
                DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, null == propertyList || propertyList.length > 0, deviceID, cag == null ? -1 : cag.getFb4(), cag == null ? -1 : cag.getPg(), cag == null ? -1 : cag.getVdev());
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(p, o);
        DeviceNumber dn = (DeviceNumber)o[0];
        try {
            ArrayList props = new ArrayList();
            if (null == propList || propList.length > 0) {
                CIMProperty[] keys = retOP.getKeys();
                ProviderLibs.addKeysToProperties(keys, props);
                props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false));
                UnsignedInteger16 value = dn.getConsistsOf(null);
                props.add(new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)value, false));
                UnsignedInteger16 cvSubstance = dn.isExternal() ? ProviderConstants.UINT16_ONE : ProviderConstants.UINT16_ZED;
                props.add(new CIMProperty("Substance", CIMDataType.UINT16_T, (Object)cvSubstance, false));
                UnsignedInteger16[] cvGuardMode = dn.getGuardMode();
                props.add(new CIMProperty("GuardMode", CIMDataType.UINT16_ARRAY_T, (Object)cvGuardMode, false));
                UnsignedInteger16 cvDataOrganization = dn.getDataOrganization();
                props.add(new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)cvDataOrganization, false));
                props.add(new CIMProperty("ErrorMethodology", CIMDataType.STRING_T, (Object)dn.getRaidLevel(), false));
                props.add(new CIMProperty("BlockSize", CIMDataType.UINT64_T, (Object)dn.getBlockSize(), false));
                UnsignedInteger64 cvNumBlocks = dn.getSLUSEElmCount() > 1 ? this.getHeadLUSENumBlocks(dn) : dn.getNumOfBlocks();
                props.add(new CIMProperty("NumberOfBlocks", CIMDataType.UINT64_T, (Object)cvNumBlocks, false));
                UnsignedInteger64 cvConsumableBlocks = cvNumBlocks;
                props.add(new CIMProperty("ConsumableBlocks", CIMDataType.UINT64_T, (Object)cvConsumableBlocks, false));
                ProviderConstants.RAID_Level rl = ProviderLibs.getRaidLevelFromString(dn.getRaidLevel());
                boolean bValue = true;
                if (rl == ProviderConstants.RAID_Level.RAID0 || rl == ProviderConstants.RAID_Level.UNKNOWN) {
                    bValue = false;
                }
                props.add(new CIMProperty("IsBasedOnUnderlyingRedundancy", CIMDataType.BOOLEAN_T, (Object)bValue, false));
                UnsignedInteger16[] cvExtentStatus = new UnsignedInteger16[]{ProviderConstants.UINT16_SIX};
                props.add(new CIMProperty("ExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)cvExtentStatus, false));
                boolean bValueFailure = true;
                if (rl == ProviderConstants.RAID_Level.RAID0 || rl == ProviderConstants.RAID_Level.UNKNOWN) {
                    bValueFailure = false;
                }
                props.add(new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)bValueFailure, false));
                props.add(new CIMProperty("SequentialAccess", CIMDataType.BOOLEAN_T, (Object)false, false));
                int dr = ProviderLibs.getDataRedudancy(dn.getRaidLevel());
                UnsignedInteger16 cvDataRed = new UnsignedInteger16(dr);
                props.add(new CIMProperty("DataRedundancy", CIMDataType.UINT16_T, (Object)cvDataRed, false));
                int pr = ProviderLibs.getPackageRedudancy(dn.getRaidLevel());
                UnsignedInteger16 cvPAckageRed = new UnsignedInteger16(pr);
                props.add(new CIMProperty("PackageRedundancy", CIMDataType.UINT16_T, (Object)cvPAckageRed, false));
                UnsignedInteger8 cvDeltaRes = ProviderConstants.UINT8_100;
                props.add(new CIMProperty("DeltaReservation", CIMDataType.UINT8_T, (Object)cvDeltaRes, false));
                props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false));
                props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false));
                props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
                props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)dn.getHealthState(), false));
                props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
                props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
                props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
                props.add(new CIMProperty("ExtentStripeLength", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ONE, false));
                props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false));
                props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false));
                String elName = "LDEVExtent:" + dn.getDNAsString();
                props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)elName, false));
                props.add(new CIMProperty("IsConcatenated", CIMDataType.BOOLEAN_T, (Object)false, false));
                props.add(new CIMProperty("ExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"SNIA:Intermediate", "SNIA:Composite"}, false));
            }
            return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_LDEVExtent");
        DeviceNumber dn = (DeviceNumber)o[0];
        String deviceID = dn.getDNAsString();
        try {
            String systemName = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getStorageSystemName();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_LDEVExtent", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_LDEVExtent", keys, op.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private UnsignedInteger64 getHeadLUSENumBlocks(DeviceNumber dn) {
        Long[] components;
        UnsignedInteger64 ret = null;
        long totalBlocks = dn.getNumOfBlocksAsLong();
        Long[] arr$ = components = dn.getCompositeComponents();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long component = arr$[i$];
            if (component == dn.getDn()) continue;
            try {
                DeviceNumber compDN = DeviceNumber.find(String.valueOf(component), false, RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getRMIObject());
                if (compDN != null) {
                    totalBlocks -= compDN.getNumOfBlocksAsLong();
                    continue;
                }
                mLogger.severe("Could not find component DevNum: " + component);
                continue;
            }
            catch (Throwable e) {
                mLogger.log(Level.SEVERE, "A serious error occurred locating the component: " + component, e);
            }
        }
        ret = new UnsignedInteger64(BigInteger.valueOf(totalBlocks));
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == deviceIDKeyVal || null == sysNameKeyVal || null == ccName || !ccName.equals("HITACHI_LDEVExtent") || null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            DeviceNumber dn = DeviceNumber.find(deviceIDKeyVal, device.getRMIObject());
            if (dn != null) {
                CIMInstance ci = this.generateInstance(op, propertyList, dn);
                return ci.filterProperties(propertyList);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_LDEVExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_LDEVExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_LDEVExtent".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LDEV, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.LDEV, this, null);
        }
    }

    private class LDEVCallback<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected LDEVCallback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) {
                ret = false;
            } else {
                try {
                    E dn = item;
                    if (null != this.mRefInfo) {
                        this.mRefInfo.addReference(this.mIter, LDEVExtentInstrumentation.this.generateObjectPath(this.mOP, dn));
                    } else if (this.mIsObjectPath) {
                        this.mIter.add(LDEVExtentInstrumentation.this.generateObjectPath(this.mOP, dn));
                    } else {
                        this.mIter.add(LDEVExtentInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, dn));
                    }
                }
                catch (Exception e) {
                    WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return ret;
        }
    }
}

