/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class PackagedPhysicalDiskMediaInstrumentation
extends BaseAssocInstrumentation {
    protected PackagedPhysicalDiskMediaInstrumentation() {
        super("HITACHI_PackagedPhysicalDiskMedia", "HITACHI_PhysicalDisk", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.PhysicalDiskInstrumentation"), "HITACHI_PhysicalDiskMedia", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.PhysicalDiskMediaInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_PackagedPhysicalDiskMedia".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                String cvTag;
                CIMProperty cpTag;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                int[] deviceIDVals = null;
                String sysName = null;
                boolean returnPhysicalDisk = false;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        cpTag = objectName.getKey("Tag");
                        String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                        if (null != cvTag) {
                            String[] retSysName = new String[1];
                            deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                            sysName = retSysName[0];
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    cpTag = objectName.getKey("Tag");
                    String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                    if (null != cvTag) {
                        String[] retSysName = new String[1];
                        deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                        sysName = retSysName[0];
                    }
                    returnPhysicalDisk = true;
                }
                if (null != deviceIDVals && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], (int)deviceIDVals[1])) != null) {
                    if (returnPhysicalDisk) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry));
                        } else {
                            CIMInstance instPhysicalDisk = this.getReference1Instrumentation().generateInstance(objectName, propertyList, infoEntry);
                            iter.add(instPhysicalDisk.filterProperties(propertyList));
                        }
                    } else if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry));
                    } else {
                        CIMInstance instPhysicalDiskMedia = this.getReference2Instrumentation().generateInstance(objectName, propertyList, infoEntry);
                        iter.add(instPhysicalDiskMedia.filterProperties(propertyList));
                    }
                }
            }
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackIMPL<PDEVInfoEntry> callback = new CallbackIMPL<PDEVInfoEntry>(deviceIter, isObjectPath, refInfo, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opPhysicalDiskMedia;
            String pnPhysicalDisk = this.getReference1PropertyName();
            CIMObjectPath opPhysicalDisk = op.getKey(pnPhysicalDisk) != null ? (CIMObjectPath)op.getKey(pnPhysicalDisk).getValue() : null;
            String pnPhysicalDiskMedia = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opPhysicalDiskMedia = op.getKey(pnPhysicalDiskMedia) != null ? (CIMObjectPath)op.getKey(pnPhysicalDiskMedia).getValue() : null;
            if (null != opPhysicalDisk && null != opPhysicalDiskMedia && this.getReference1Instrumentation().instanceExists(opPhysicalDisk) && this.getReference2Instrumentation().instanceExists(opPhysicalDiskMedia)) {
                String cvPhysicalDiskTag;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opPhysicalDisk, "Tag");
                CIMProperty cpPhysicalDiskMediaTag = opPhysicalDiskMedia.getKey("Tag");
                String cvPhysicalDiskMediaTag = null != cpPhysicalDiskMediaTag ? (String)cpPhysicalDiskMediaTag.getValue() : null;
                CIMProperty cpPhysicalDiskTag = opPhysicalDisk.getKey("Tag");
                String string = cvPhysicalDiskTag = null != cpPhysicalDiskTag ? (String)cpPhysicalDiskTag.getValue() : null;
                if (null != cvPhysicalDiskTag && null != cvPhysicalDiskMediaTag && cvPhysicalDiskMediaTag.equals(cvPhysicalDiskTag)) {
                    PDEVInfoEntry infoEntry;
                    String[] sysName = new String[1];
                    int[] deviceIDVals = PDEVInfoEntry.parseTag(cvPhysicalDiskTag, sysName);
                    if (null != sysName[0] && sysName[0].equals(device.getStorageSystemName()) && null != deviceIDVals && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDVals[0], deviceIDVals[1])) != null) {
                        opPhysicalDisk = this.getReference1Instrumentation().generateObjectPath(op, infoEntry);
                        opPhysicalDiskMedia = this.getReference2Instrumentation().generateObjectPath(op, infoEntry);
                        return this.generateInstance(op, propertyList, opPhysicalDisk, opPhysicalDiskMedia);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_PackagedPhysicalDiskMedia".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                String[] retSysName;
                String cvTag;
                CIMProperty cpTag;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                int[] deviceIDVals = null;
                String sysName = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        cpTag = objectName.getKey("Tag");
                        String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                        if (null != cvTag) {
                            retSysName = new String[1];
                            deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                            sysName = retSysName[0];
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    cpTag = objectName.getKey("Tag");
                    String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                    if (null != cvTag) {
                        retSysName = new String[1];
                        deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                        sysName = retSysName[0];
                    }
                }
                if (null != deviceIDVals && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], (int)deviceIDVals[1])) != null) {
                    CIMObjectPath opPhysicalDisk = this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMObjectPath opPhysicalDiskMedia = this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMInstance instAssoc = this.generateInstance(objectName, propertyList, opPhysicalDisk, opPhysicalDiskMedia);
                    if (isObjectPath) {
                        iter.add(instAssoc.getObjectPath());
                    } else {
                        iter.add(instAssoc.filterProperties(propertyList));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    public class CallbackIMPL<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        public CallbackIMPL(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block5: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E entry = item;
                        CIMObjectPath opPhysicalDisk = PackagedPhysicalDiskMediaInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMObjectPath opPhysicalDiskMedia = PackagedPhysicalDiskMediaInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMInstance instAssoc = PackagedPhysicalDiskMediaInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opPhysicalDisk, opPhysicalDiskMedia);
                        if (this.mIsObjectPath) {
                            this.mIter.add(instAssoc.getObjectPath());
                            break block5;
                        }
                        this.mIter.add(instAssoc.filterProperties(this.mPropertyList));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                        ret = false;
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

