/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ProductPhysicalComponentDiskInstrumentation
extends BaseAssocInstrumentation {
    protected ProductPhysicalComponentDiskInstrumentation() {
        super("HITACHI_ProductPhysicalComponentDisk", "HITACHI_DiskProduct", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskProductInstrumentation"), "HITACHI_PhysicalDisk", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.PhysicalDiskInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ProductPhysicalComponentDisk".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                int[] deviceIDVals = null;
                String sysName = null;
                boolean returnDiskProduct = false;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvIDNum;
                        device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        CIMProperty cpIDNum = objectName.getKey("IdentifyingNumber");
                        String string = cvIDNum = cpIDNum != null ? (String)cpIDNum.getValue() : null;
                        if (null != cvIDNum) {
                            deviceIDVals = PDEVInfoEntry.parseDeviceID(cvIDNum);
                        }
                        sysName = objectName.getKey("Name") != null ? (String)objectName.getKey("Name").getValue() : null;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    String cvTag;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    CIMProperty cpTag = objectName.getKey("Tag");
                    String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                    if (null != cvTag) {
                        String[] retSysName = new String[1];
                        deviceIDVals = PDEVInfoEntry.parseTag(cvTag, retSysName);
                        sysName = retSysName[0];
                    }
                    returnDiskProduct = true;
                }
                if (null != deviceIDVals && null != device && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], (int)deviceIDVals[1])) != null) {
                    if (returnDiskProduct) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, infoEntry));
                        }
                    } else if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, infoEntry));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devs = RMIObjectMapping.getAllRMIObjectMappings();
        ArrayList<RMIObjectMapping> devices = new ArrayList<RMIObjectMapping>(devs);
        ArrayList iterList = new ArrayList(devices.size());
        try {
            for (RMIObjectMapping rMIObjectMapping : devices) {
                CustomCloseableIterator threadIter = isObjectPath ? new CustomCloseableIterator() : new CustomCloseableIterator();
                iterList.add(threadIter);
                CallbackIMPL<PDEVInfoEntry> callback = new CallbackIMPL<PDEVInfoEntry>(threadIter, isObjectPath, refInfo, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(rMIObjectMapping.getRMIObject(), callback);
            }
            for (CustomCloseableIterator customCloseableIterator : iterList) {
                while (customCloseableIterator.hasNext()) {
                    if (isObjectPath) {
                        iter.add((CIMObjectPath)customCloseableIterator.next());
                        continue;
                    }
                    iter.add((CIMInstance)customCloseableIterator.next());
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException wBEMException = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(wBEMException);
                iter.close();
            }
            throw wBEMException;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opPhysicalDisk;
            String pnDiskProduct = this.getReference1PropertyName();
            CIMObjectPath opDiskProduct = op.getKey(pnDiskProduct) != null ? (CIMObjectPath)op.getKey(pnDiskProduct).getValue() : null;
            String pnPhysicalDisk = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opPhysicalDisk = op.getKey(pnPhysicalDisk) != null ? (CIMObjectPath)op.getKey(pnPhysicalDisk).getValue() : null;
            if (null != opDiskProduct && null != opPhysicalDisk) {
                String tag;
                CIMProperty cpDiskProductVersion;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opDiskProduct, "Name");
                CIMProperty cpDiskProductIDNum = opDiskProduct.getKey("IdentifyingNumber");
                int[] diskProductDeviceIDVals = null;
                if (null != cpDiskProductIDNum) {
                    diskProductDeviceIDVals = PDEVInfoEntry.parseDeviceID((String)cpDiskProductIDNum.getValue());
                }
                String cvDiskProductVersion = (cpDiskProductVersion = opDiskProduct.getKey("Version")) != null ? (String)cpDiskProductVersion.getValue() : null;
                CIMProperty cpDiskProductVendor = opDiskProduct.getKey("Vendor");
                String cvDiskProductVendor = cpDiskProductVendor != null ? (String)cpDiskProductVendor.getValue() : null;
                CIMProperty cpDiskProductName = opDiskProduct.getKey("Name");
                String cvDiskProductName = null != cpDiskProductName ? (String)cpDiskProductName.getValue() : null;
                int[] physicalDiskDeviceVals = null;
                String cvPhysicalDiskSystemName = null;
                CIMProperty cpPhysicalDiskTag = opPhysicalDisk.getKey("Tag");
                String string = tag = null != cpPhysicalDiskTag ? (String)cpPhysicalDiskTag.getValue() : null;
                if (null != tag) {
                    String[] systemName = new String[1];
                    physicalDiskDeviceVals = PDEVInfoEntry.parseTag(tag, systemName);
                    cvPhysicalDiskSystemName = systemName[0];
                }
                if (null != cvDiskProductName && null != cvPhysicalDiskSystemName && null != diskProductDeviceIDVals && null != physicalDiskDeviceVals && cvDiskProductName.equals(cvPhysicalDiskSystemName) && diskProductDeviceIDVals[0] == physicalDiskDeviceVals[0] && diskProductDeviceIDVals[1] == physicalDiskDeviceVals[1] && cvDiskProductName.equals(device.getStorageSystemName())) {
                    PDEVInfoEntry infoEntry;
                    String expectedProductVersion = "0";
                    String expectedVendor = device.getVendor();
                    if (null != expectedVendor && expectedVendor.equals(cvDiskProductVendor) && "0".equals(cvDiskProductVersion) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), diskProductDeviceIDVals[0], diskProductDeviceIDVals[1])) != null) {
                        opDiskProduct = this.getReference1Instrumentation().generateObjectPath(op, infoEntry);
                        opPhysicalDisk = this.getReference2Instrumentation().generateObjectPath(op, infoEntry);
                        CIMInstance instAssoc = this.generateInstance(op, propertyList, opDiskProduct, opPhysicalDisk);
                        return instAssoc.filterProperties(propertyList);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ProductPhysicalComponentDisk".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                int[] deviceIDVals = null;
                String sysName = null;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvIDNum;
                        device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        CIMProperty cpIDNum = objectName.getKey("IdentifyingNumber");
                        String string = cvIDNum = cpIDNum != null ? (String)cpIDNum.getValue() : null;
                        if (null != cvIDNum) {
                            deviceIDVals = PDEVInfoEntry.parseDeviceID(cvIDNum);
                        }
                        sysName = objectName.getKey("Name") != null ? (String)objectName.getKey("Name").getValue() : null;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    String cvTag;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Tag");
                    CIMProperty cpTag = objectName.getKey("Tag");
                    String string = cvTag = cpTag != null ? (String)cpTag.getValue() : null;
                    if (null != cvTag) {
                        String[] temp = new String[1];
                        deviceIDVals = PDEVInfoEntry.parseTag(cvTag, temp);
                        sysName = temp[0];
                    }
                }
                if (null != deviceIDVals && null != device && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], deviceIDVals[1])) != null) {
                    CIMObjectPath opDiskProduct = this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMObjectPath opPhysicalDisk = this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMInstance instAssoc = this.generateInstance(objectName, propertyList, opDiskProduct, opPhysicalDisk);
                    if (isObjectPath) {
                        iter.add(instAssoc.getObjectPath());
                    } else {
                        iter.add(instAssoc.filterProperties(propertyList));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    public class CallbackIMPL<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        public CallbackIMPL(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block5: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E disk = item;
                        CIMObjectPath opDiskProduct = ProductPhysicalComponentDiskInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, disk);
                        CIMObjectPath opPhysicalDisk = ProductPhysicalComponentDiskInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, disk);
                        CIMInstance instAssoc = ProductPhysicalComponentDiskInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opDiskProduct, opPhysicalDisk);
                        if (this.mIsObjectPath) {
                            this.mIter.add(instAssoc.getObjectPath());
                            break block5;
                        }
                        this.mIter.add(instAssoc.filterProperties(this.mPropertyList));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                        ret = false;
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

