/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class RedundancySetInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"InstanceID", "SystemName"});
            String expID = null;
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices, expected 1: " + op);
                }
                expID = (String)expectedValues.get("InstanceID");
            }
            for (RMIObjectMapping device : devices) {
                String instID = device.getStorageSystemName();
                if (null != expID && !expID.equals(instID)) continue;
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        try {
            CIMObjectPath retOP = this.generateObjectPath(p, o);
            String instID = (String)retOP.getKey("InstanceID").getValue();
            ArrayList props = new ArrayList(8);
            ProviderLibs.addKeysToProperties(retOP.getKeys(), props);
            props.add(new CIMProperty("RedundancyStatus", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
            props.add(new CIMProperty("TypeOfSet", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_ONE}, false));
            props.add(new CIMProperty("OtherTypeOfSet", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"Multiple Storage Processor System"}, false));
            props.add(new CIMProperty("LoadBalanceAlgorithm", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)instID, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)instID, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)instID, false));
            CIMInstance ci = new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
            return ci.filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath p, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_RedundancySet");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        try {
            String instID = rmiObj.getSMISMappingContainer().getStorageSystemName();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
            return new CIMObjectPath(p.getScheme(), p.getHost(), p.getPort(), p.getNamespace(), "HITACHI_RedundancySet", keys, p.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instIDKeyValue;
            String string = instIDKeyValue = null != op.getKey("InstanceID") && null != op.getKey("InstanceID").getValue() ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != instIDKeyValue && instIDKeyValue.equals(device.getStorageSystemName())) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

