/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ReplicationSettingDataInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues);
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        String repSrvcName = "HITACHI_ReplicationSettingData".substring("HITACHI_".length());
        CIMProperty[] retProps = new CIMProperty[]{keys[0], new CIMProperty("StorageCompressionPolicy", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_SEVEN, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)repSrvcName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)repSrvcName, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)repSrvcName, false)};
        return new CIMInstance(retOP, retProps).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectMapping.class}, o, "HITACHI_ReplicationSettingData");
        RMIObjectMapping device = (RMIObjectMapping)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)(device.getStorageSystemName() + ProviderConstants.ID_SEPERATOR_AS_CHAR + "Snapshot"), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ReplicationSettingData", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instID = ProviderLibs.getAllButEndString((String)op.getKeyValue("InstanceID"), ProviderConstants.ID_SEPERATOR_AS_CHAR);
            if (null == instID || !instID.equalsIgnoreCase(device.getStorageSystemName())) {
                throw new WBEMException(6, op.toString());
            }
            return this.generateInstance(op, propertyList, device);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

