/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FCPortCallbackHandler;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageHardwareIDs;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class SCSIProtocolEndpointInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    public static final UnsignedInteger16 CPV_CONNECTIONTYPE = ProviderConstants.UINT16_TWO;
    public static final String CPV_OTHERTYPEDESCRIPTION = "SCSI";
    public static final UnsignedInteger16 CPV_PROTOCOLIFTYPE = ProviderConstants.UINT16_ONE;

    protected static String createSystemName(FCPort port) throws Exception {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
        String ret = device.getStorageSystemName() + "." + port.getControlID();
        return ret;
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolEndpoint added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance sourceInstance = this.generateInstance(op, null, pObj);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolEndpoint deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolEndpoint", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                FCPort port = (FCPort)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
                FCPort newInst = FCPort.find(port.getPortWWN(), FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                if (newInst != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a fort that with WWN of: " + port.getPortWWN());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolEndpoint modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"ElementName", "SystemName"});
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            String expSysName = null;
            String expName = null;
            Short portID = null;
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, no device infoavailable. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_SCSIProtocolEndpoint", expectedValues, devices.size()});
                    return;
                }
                expSysName = (String)expectedValues.get("SystemName");
                expName = (String)expectedValues.get("Name");
                if (null != expName && !StorageHardwareIDs.isIDHostWWN(expName)) {
                    int idx = expName.indexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    if (idx < 0) {
                        mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, but 'name' information is in an unexpected format: {1}", new Object[]{"HITACHI_SCSIProtocolEndpoint", expName});
                        return;
                    }
                    String portStr = expName.substring(0, idx);
                    portID = new Short(portStr);
                    expName = null;
                }
            }
            for (RMIObjectMapping device : devices) {
                FCPortCallbackHandler<FCPort> callback = new FCPortCallbackHandler<FCPort>(deviceIter, isObjectPath, refInfo, op, propertyList, FCPort.PortTypeRequested.OPEN, this);
                FCPort.getFCPorts(device.getRMIObject(), callback, isObjectPath, true, expName, expSysName, portID);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath pOP, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(pOP, o);
        FCPort port = (FCPort)o[0];
        CIMInstance ret = null;
        try {
            if (null != pOP) {
                String portWWNStr = new String(port.getPortWWN());
                ArrayList props = new ArrayList();
                CIMProperty[] keys = retOP.getKeys();
                ProviderLibs.addKeysToProperties(keys, props);
                props.add(new CIMProperty("ConnectionType", CIMDataType.UINT16_T, (Object)CPV_CONNECTIONTYPE, false));
                UnsignedInteger16 role = port.getPortRole();
                props.add(new CIMProperty("Role", CIMDataType.UINT16_T, (Object)role, false));
                props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)portWWNStr, false));
                props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false));
                props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
                props.add(new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)"WWN", false));
                props.add(new CIMProperty("ProtocolType", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(18), false));
                props.add(new CIMProperty("ProtocolIFType", CIMDataType.UINT16_T, (Object)CPV_PROTOCOLIFTYPE, false));
                props.add(new CIMProperty("OtherTypeDescription", CIMDataType.STRING_T, (Object)CPV_OTHERTYPEDESCRIPTION, false));
                props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
                props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
                props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
                props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
                props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)portWWNStr, false));
                props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)portWWNStr, false));
                ret = new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath pOP, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{FCPort.class}, o, "HITACHI_SCSIProtocolEndpoint");
        FCPort port = (FCPort)o[0];
        CIMObjectPath ret = null;
        try {
            String portWWN = port.getPortWWN();
            String systemName = SCSIProtocolEndpointInstrumentation.createSystemName(port);
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_SCSIProtocolEndpoint", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)portWWN, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
            ret = new CIMObjectPath(pOP.getScheme(), pOP.getHost(), pOP.getPort(), pOP.getNamespace(), "HITACHI_SCSIProtocolEndpoint", keys, pOP.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String nameKeyVal = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == nameKeyVal || null == sysNameKeyVal || null == ccName || !ccName.equals("HITACHI_SCSIProtocolEndpoint") || null == sccName || !sccName.equals("HITACHI_StorageProcessorSystem")) {
                throw new WBEMException(6, op.toString());
            }
            String partialSysName = device.getStorageSystemName() + ".";
            FindMethodCallbackHandler<FCPort> callback = new FindMethodCallbackHandler<FCPort>();
            FCPort.getFCPorts(device.getRMIObject(), callback, false, true, nameKeyVal, sysNameKeyVal);
            FCPort port = callback.getReturnValue();
            if (null != port) {
                String systemName = partialSysName + port.getControlID();
                if (nameKeyVal.equals(port.getPortWWN()) && sysNameKeyVal.equals(systemName)) {
                    return this.generateInstance(op, propertyList, port);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_SCSIProtocolEndpoint".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_SCSIProtocolEndpoint".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_SCSIProtocolEndpoint AND SourceInstance.OperationalStatus <> PreviousInstance.OperationalStatus".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_SCSIProtocolEndpoint AND SourceInstance.CIM_SCSIProtocolEndpoint::OperationalStatus <> PreviousInstance.CIM_SCSIProtocolEndpoint::OperationalStatus".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
        }
    }
}

