/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageVolumeCallbackHandler;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class SnapshotVolumeCompositeExtentInstrumentation
extends BaseInstrumentation {
    private static final String CPN_POOLID = "PoolID";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices;
            String expInstID = null;
            String expDevID = null;
            String expPoolID = null;
            ChassisArrayGroup cag = null;
            if (expectedValues != null) {
                devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
                if (1 != devices.size()) {
                    throw new WBEMException("Association call but wrong number of managed devices: " + devices.size());
                }
                expDevID = (String)expectedValues.get("DeviceID");
                expPoolID = (String)expectedValues.get(CPN_POOLID);
                expInstID = (String)expectedValues.get("InstanceID");
                if (expInstID != null && expDevID == null && expPoolID == null) {
                    Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(expInstID);
                    int fb4 = rets[0];
                    int ag = rets[1];
                    cag = ChassisArrayGroup.find(devices.get(0).getRMIObject(), null, fb4, ag, isObjectPath);
                    if (cag == null) {
                        iter.close();
                        return;
                    }
                }
            } else {
                devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues);
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                StorageVolumeCallbackHandler<DeviceNumber> callback = new StorageVolumeCallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList, null, null, null, null, VolumeTypeEnum.QSVVOL, this);
                short id = expPoolID == null ? (short)-1 : (short)Short.parseShort(expPoolID);
                DeviceNumber.getDNs(device.getRMIObject(), callback, id, true, VolumeTypeEnum.QSVVOL);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        DeviceNumber dn = (DeviceNumber)o[0];
        CIMInstance ret = null;
        try {
            if (null != op && null != dn) {
                CIMProperty[] keys = retOP.getKeys();
                UnsignedInteger64 blocks = dn.getNumOfBlocks();
                String elName = "CompositeLDEVExtent:" + dn.getDNAsString();
                UnsignedInteger16[] extentStatusvalue = new UnsignedInteger16[]{ProviderConstants.UINT16_SIX};
                CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("NumberOfBlocks", CIMDataType.UINT64_T, (Object)blocks, false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ONE, false), new CIMProperty("IsConcatenated", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("BlockSize", CIMDataType.UINT64_T, (Object)dn.getBlockSize(), false), new CIMProperty("ConsumableBlocks", CIMDataType.UINT64_T, (Object)blocks, false), new CIMProperty("IsBasedOnUnderlyingRedundancy", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("ExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)extentStatusvalue, false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false), new CIMProperty("DataRedundancy", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("PackageRedundancy", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)elName, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"OK"}, false), new CIMProperty("ExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"SNIA:Intermediate", "SNIA:Composite"}, false)};
                ret = new CIMInstance(retOP, retProps);
                ret = ret.filterProperties(propertyList);
            }
            return ret;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_SnapshotVolumeCompositeExtent");
        DeviceNumber dn = (DeviceNumber)o[0];
        String deviceID = dn.getDNAsString();
        CIMObjectPath ret = null;
        if (null != op && null != deviceID) {
            String systemName;
            try {
                systemName = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getStorageSystemName();
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_SnapshotVolumeCompositeExtent", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true)};
            ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_SnapshotVolumeCompositeExtent", keys, op.getXmlSchemaName());
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null == deviceIDKeyVal || null == sysNameKeyVal || null == ccName || !ccName.equals("HITACHI_SnapshotVolumeCompositeExtent") || null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            DeviceNumber data = DeviceNumber.find(deviceIDKeyVal, true, device.getRMIObject());
            if (data != null) {
                return this.generateInstance(op, propertyList, data);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

