/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageHardwareIDs;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.ElementStorageClientSettingDataStorageHardwareIDInstrumentation;
import com.hitachi.smi.instrumentation.StorageHardwareIDInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class StorageHardwareIDManagementServiceInstrumentation
extends BaseInstrumentation {
    private static final int MRV_ID_ALREADY_CREATED = 4096;
    private static final int MRV_INVALID_IDTYPE = 4097;
    private static final int MRV_INVALID_PARAMETER = 5;
    private static final int MRV_FAILED = 4;
    private static final int MRV_SUCCESS = 0;
    private static final String SERVICE_NAME = "HITACHI_StorageHardwareIDManagementService".substring("HITACHI_".length());
    private final StorageHardwareIDInstrumentation mStorageHardwareIDInstrumentation = (StorageHardwareIDInstrumentation)StorageHardwareIDManagementServiceInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageHardwareIDInstrumentation");

    protected StorageHardwareIDManagementServiceInstrumentation() {
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private UnsignedInteger32 extrinsic_CreateStorageHardwareID(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        try {
            String storageID = null;
            CIMObjectPath opSetting = null;
            boolean isScsi = false;
            for (CIMArgument<?> arg : pInArgs) {
                String argName;
                if (null == arg || "ElementName".equalsIgnoreCase(argName = arg.getName())) continue;
                if ("StorageID".equalsIgnoreCase(argName)) {
                    storageID = (String)arg.getValue();
                    continue;
                }
                if ("IDType".equalsIgnoreCase(argName)) {
                    UnsignedInteger16 iDType = (UnsignedInteger16)arg.getValue();
                    if (StorageHardwareIDs.CPV_IDTYPE.equals((Object)iDType)) {
                        isScsi = false;
                        continue;
                    }
                    if (StorageHardwareIDs.CPV_iSCSIIDTYPE.equals((Object)iDType)) {
                        isScsi = true;
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "{0} value of {1} is not supported. Only supported values are {2} & {3}. Returning {5} (invalid ID Type) ", new Object[]{"IDType", iDType, StorageHardwareIDs.CPV_IDTYPE, StorageHardwareIDs.CPV_iSCSIIDTYPE, 4097});
                    return new UnsignedInteger32(4097L);
                }
                if ("OtherIDType".equalsIgnoreCase(argName)) {
                    if (arg.getValue() == null) continue;
                    mLogger.info("Non-null \"OtherIDType\" Parameter not supported.\nReturning value of 4097 (invalid ID Type) ");
                    return new UnsignedInteger32(4097L);
                }
                if ("Setting".equalsIgnoreCase(argName)) {
                    opSetting = (CIMObjectPath)arg.getValue();
                    continue;
                }
                mLogger.info("Parameter " + argName + " is npt a valid " + "Parameter for method " + "createStorageHardwareID" + "\nReturning value of " + 5 + " (invalid parameter) ");
                return new UnsignedInteger32(5L);
            }
            if (null == storageID) {
                mLogger.info("Parameter StorageID is required for method createStorageHardwareID\nReturning value of 5 (invalid parameter) ");
                return new UnsignedInteger32(5L);
            }
            if (!isScsi) {
                if (!StorageHardwareIDs.isIDHostWWN(storageID = storageID.toUpperCase())) {
                    mLogger.log(Level.SEVERE, "{0} is not a valid Host WWN. Returning value of {1} (invalid parameter)", new Object[]{storageID, 5});
                    return new UnsignedInteger32(5L);
                }
            } else if (!StorageHardwareIDs.isIDiSCSIName(storageID)) {
                mLogger.log(Level.SEVERE, "{0} is not a valid iSCSI Name. Returning value of {1} (invalid parameter)", new Object[]{storageID, 5});
                return new UnsignedInteger32(5L);
            }
            if (StorageHardwareIDs.getStorageHardwareIDs().isIDCreated(device, storageID)) {
                mLogger.info("Cannot create a StorageHardwareID with StorageID value of " + storageID + "because one already exists" + "\nReturning value of " + 4096 + " (ID already created) ");
                return new UnsignedInteger32(4096L);
            }
            CIMObjectPath opStorageHardwareID = this.mStorageHardwareIDInstrumentation.generateObjectPath(pOp, device.getRMIObject(), storageID);
            if (null != opSetting) {
                ElementStorageClientSettingDataStorageHardwareIDInstrumentation assocInst = (ElementStorageClientSettingDataStorageHardwareIDInstrumentation)BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ElementStorageClientSettingDataStorageHardwareIDInstrumentation");
                CIMProperty cvValue = opSetting.getKey("InstanceID");
                if (cvValue != null) {
                    String clientSettingID = (String)cvValue.getValue();
                    assocInst.addAssociatedHardwareID(device.getRMIObject(), storageID, clientSettingID);
                } else {
                    throw new WBEMException("Unable to get ElementStorageClientSettingDataStorageHardwareID instrumentation.");
                }
            }
            pOutArgs[0] = new CIMArgument("HardwareID", new CIMDataType("HITACHI_StorageHardwareID"), (Object)opStorageHardwareID);
            StorageHardwareIDs.getStorageHardwareIDs().addUnassignedStorageHardwareID(device.getSerialNumber(), storageID);
            if (this.mStorageHardwareIDInstrumentation.isListen4InstAdd()) {
                CIMInstance sourceInstance = this.mStorageHardwareIDInstrumentation.generateInstance(opStorageHardwareID, null, device.getRMIObject(), storageID);
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
                mHandle.deliverEvent(indication, null);
            }
            return new UnsignedInteger32(0L);
        }
        catch (Throwable th) {
            mLogger.log(Level.SEVERE, "Caught exception trying to invoke method createStorageHardwareID", th);
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private UnsignedInteger32 extrinsic_DeleteStorageHardwareID(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        try {
            CIMObjectPath opHardwareID = null;
            for (CIMArgument<?> arg : pInArgs) {
                if (null == arg) continue;
                if ("HardwareID".equalsIgnoreCase(arg.getName())) {
                    opHardwareID = (CIMObjectPath)arg.getValue();
                    continue;
                }
                mLogger.log(Level.SEVERE, "Invalid argument, {0}, passed to function", arg);
                return ProviderConstants.UINT32_FIVE;
            }
            if (null != opHardwareID) {
                String cvInstanceID = (String)opHardwareID.getKeyValue("InstanceID");
                String sysName = device.getStorageSystemName();
                if (null == cvInstanceID || !cvInstanceID.startsWith(sysName)) {
                    mLogger.log(Level.SEVERE, "StorageHardwareID with instanceID of \"{0}\" cannot be deleted because the StorageSystem name of the instanceID does not match the actual name \"{1}\". Returning value of {2} (instance not found)", new Object[]{cvInstanceID, sysName, ProviderConstants.UINT32_4096});
                    return ProviderConstants.UINT32_4096;
                }
                String id = cvInstanceID.substring(sysName.length() + 1);
                if (StorageHardwareIDs.getStorageHardwareIDs().isIDAssigned(device, id)) {
                    mLogger.severe("StorageHardwareID with instanceID of \"" + cvInstanceID + "\" cannot be deleted because it is mapped." + "\nReturning value " + 4 + " (Failed)");
                    return new UnsignedInteger32(4L);
                }
                if (!StorageHardwareIDs.getStorageHardwareIDs().removeUnassignedStorageHardwareID(device.getSerialNumber(), id)) {
                    mLogger.info("StorageHardwareID with instanceID of \"" + cvInstanceID + "\" cannot be deleted because it " + "does not exists." + "\nReturning value of " + ProviderConstants.UINT32_4096 + " (instance not found) ");
                    return ProviderConstants.UINT32_4096;
                }
                ElementStorageClientSettingDataStorageHardwareIDInstrumentation assocInst = (ElementStorageClientSettingDataStorageHardwareIDInstrumentation)BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ElementStorageClientSettingDataStorageHardwareIDInstrumentation");
                assocInst.removeAssociatedHardwareID(id);
                if (this.mStorageHardwareIDInstrumentation.isListen4InstAdd()) {
                    CIMInstance sourceInstance = this.mStorageHardwareIDInstrumentation.generateInstance(pOp, null, device.getRMIObject(), id);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
                    mHandle.deliverEvent(indication, null);
                }
                ret = ProviderConstants.UINT32_ZED;
            } else {
                mLogger.log(Level.SEVERE, "{0} parameter missing", "HardwareID");
                ret = ProviderConstants.UINT32_FIVE;
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        try {
            CIMObjectPath retOP = this.generateObjectPath(op, o);
            ArrayList props = new ArrayList();
            ProviderLibs.addKeysToProperties(retOP.getKeys(), props);
            props.add(new CIMProperty("StartMode", CIMDataType.STRING_T, (Object)"Automatic", false));
            props.add(new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)new Boolean(true), false));
            props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
            props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
            props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
            props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false));
            props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
            props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)SERVICE_NAME, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)SERVICE_NAME, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)SERVICE_NAME, false));
            CIMInstance ci = new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()]));
            return ci.filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageHardwareIDManagementService");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String name = null;
        try {
            name = rmiObj.getSMISMappingContainer().getStorageSystemName();
        }
        catch (Exception e) {
            throw new WBEMException(1, "Unable to get storage system name!", null, (Throwable)e);
        }
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageHardwareIDManagementService", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)SERVICE_NAME, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)name, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageHardwareIDManagementService", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameVal;
            String name;
            String sccName;
            String ccName;
            String string = ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            if (null == ccName || !ccName.equals("HITACHI_StorageHardwareIDManagementService")) {
                throw new WBEMException(6, op.toString());
            }
            String string2 = sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            if (null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            String string3 = name = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            if (null == name || !name.equals(SERVICE_NAME)) {
                throw new WBEMException(6, op.toString());
            }
            String ssName = device.getStorageSystemName();
            String string4 = sysNameVal = null != op.getKey("SystemName") && null != op.getKey("SystemName").getValue() ? (String)op.getKey("SystemName").getValue() : null;
            if (null == sysNameVal || !sysNameVal.equals(ssName)) {
                throw new WBEMException(6, op.toString());
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 oRet = null;
        if ("createStorageHardwareID".equalsIgnoreCase(pMethodName)) {
            oRet = this.extrinsic_CreateStorageHardwareID(pOp, pInArgs, pOutArgs);
        } else if ("deleteStorageHardwareID".equalsIgnoreCase(pMethodName)) {
            oRet = this.extrinsic_DeleteStorageHardwareID(pOp, pInArgs, pOutArgs);
        } else {
            throw new WBEMException(17, pOp.getObjectName() + " does not support the method: " + pMethodName);
        }
        return oRet;
    }
}

