/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class StorageProcessorSystemDeviceSCSIPCInstrumentation
extends BaseAssocInstrumentation {
    protected StorageProcessorSystemDeviceSCSIPCInstrumentation() {
        super("HITACHI_StorageProcessorSystemDeviceSCSIPC", "HITACHI_StorageProcessorSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"), "HITACHI_SCSIProtocolController", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                CallbackHandler<PortandHostGroupInfo> callback = new CallbackHandler<PortandHostGroupInfo>(deviceIter, isObjectPath, refInfo, op, propertyList, null, null);
                PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, device.getStorageSystemName(), false, continueOnError);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opSCSIPC) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != opSCSIPC && null != opSCSIPC.getKey("SystemName") ? (String)opSCSIPC.getKey("SystemName").getValue() : null;
        hTable.put("Name", name);
        hTable.put("ElementName", name);
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opStorageProcessorSystem) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String sysName = null != opStorageProcessorSystem && null != opStorageProcessorSystem.getKey("Name") ? (String)opStorageProcessorSystem.getKey("Name").getValue() : null;
        hTable.put("ElementName", sysName);
        hTable.put("SystemName", sysName);
        return hTable;
    }

    private class CallbackHandler<E extends PortandHostGroupInfo>
    extends IteratorCallbackIMPL<E> {
        String expDeviceID;
        private String expSysName;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String expSysName, String expDeviceID) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.expDeviceID = null;
            this.expSysName = null;
            this.expSysName = expSysName;
            this.expDeviceID = expDeviceID;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E phgi = item;
                        String spcDeviceID = ((PortandHostGroupInfo)phgi).getPortID() + "." + ((PortandHostGroupInfo)phgi).getHostgroupID();
                        String spcSysName = ((PortandHostGroupInfo)phgi).getSystemName() + "." + ((PortandHostGroupInfo)phgi).getCtrlID();
                        if (this.expDeviceID != null && !this.expDeviceID.equalsIgnoreCase(spcDeviceID)) {
                            return ret;
                        }
                        if (this.expSysName != null && !this.expSysName.equalsIgnoreCase(spcSysName)) {
                            return ret;
                        }
                        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)phgi).getSerialNumber());
                        CHAInfo t = CHAInfo.find(((PortandHostGroupInfo)phgi).getCtrlID(), device.getRMIObject());
                        device = null;
                        CIMObjectPath opStorageProcessorSystem = StorageProcessorSystemDeviceSCSIPCInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, t);
                        t = null;
                        CIMObjectPath opSCSIProtocolController = StorageProcessorSystemDeviceSCSIPCInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, phgi);
                        if (this.mIsObjectPath) {
                            this.mIter.add(StorageProcessorSystemDeviceSCSIPCInstrumentation.this.generateObjectPath(this.mOP, opStorageProcessorSystem, opSCSIProtocolController));
                            break block7;
                        }
                        this.mIter.add(StorageProcessorSystemDeviceSCSIPCInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opStorageProcessorSystem, opSCSIProtocolController));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

