/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.Protect;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class StorageProtectionServiceInstrumentation
extends BaseInstrumentation {
    private static final int ACCESS_WRITEONCE = 3;
    private static final int ACCESS_READWRITE_DISABLED = 4;
    private static final int GUARD_PROTECT_BIT = 1;
    private static final int GUARD_ACCESS_MASK_READONLY = 2;
    private static final int GUARD_DENYASCOPYTARGET_MASK_TRUE = 64;
    private static final int PROTECTION_TYPE_LIMITED = 2;
    private static final int PROTECTION_TYPE_PERMANENT = 3;
    private static final int VALID_INQUIRY_PROTECTION = 1;
    private static final int RETENTION_TIME_NONE = 0;
    private static final int RETENTION_TIME_UNLIMITED = -1;
    private static final int RETENTION_TIME_MAX = 21900;
    private static final String mClassName = "HITACHI_StorageProtectionService".substring("HITACHI_".length());

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private UnsignedInteger32 extrinsic_Protect(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        int retVal = 0;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        try {
            CIMObjectPath opLDevExtent = null;
            UnsignedInteger16 elementType = null;
            UnsignedInteger16 access = null;
            UnsignedInteger16 protectExpirationType = null;
            Boolean denyAsCopyTarget = null;
            CIMDateTimeInterval timePeriod = null;
            Boolean lunMappingConfigure = null;
            UnsignedInteger16[] inquiryProtection = null;
            for (CIMArgument<?> arg : pInArgs) {
                if (null == arg) continue;
                String argName = arg.getName();
                if ("Element".equalsIgnoreCase(argName)) {
                    opLDevExtent = (CIMObjectPath)arg.getValue();
                    continue;
                }
                if ("ElementType".equalsIgnoreCase(argName)) {
                    elementType = (UnsignedInteger16)arg.getValue();
                    continue;
                }
                if ("Access".equalsIgnoreCase(argName)) {
                    access = (UnsignedInteger16)arg.getValue();
                    if (3 != access.intValue()) continue;
                    mLogger.severe("Protect: Access value of 3 (Write Once) is not supported");
                    retVal = 1;
                    break;
                }
                if ("ProtectExpirationType".equalsIgnoreCase(argName)) {
                    protectExpirationType = (UnsignedInteger16)arg.getValue();
                    continue;
                }
                if ("DenyAsCopyTarget".equalsIgnoreCase(argName)) {
                    denyAsCopyTarget = (Boolean)arg.getValue();
                    continue;
                }
                if ("LUNMappingConfigure".equalsIgnoreCase(argName)) {
                    lunMappingConfigure = (Boolean)arg.getValue();
                    continue;
                }
                if ("InquiryProtection".equalsIgnoreCase(argName)) {
                    inquiryProtection = (UnsignedInteger16[])arg.getValue();
                    continue;
                }
                if ("TimePeriod".equalsIgnoreCase(argName)) {
                    CIMDateTime tPeriod = (CIMDateTime)arg.getValue();
                    if (null != tPeriod && !(tPeriod instanceof CIMDateTimeInterval)) {
                        mLogger.severe("Protect: TimePeriod must be a CIMDateTimeinterval but it is " + (tPeriod == null ? "null" : tPeriod.getClass().getSimpleName()));
                        retVal = 5;
                        break;
                    }
                    timePeriod = (CIMDateTimeInterval)tPeriod;
                    continue;
                }
                mLogger.severe("Protect: Unknown parameter: " + argName);
                retVal = 5;
                break;
            }
            int retentionTime = 0;
            if (0 == retVal) {
                if (null == opLDevExtent || null == elementType || null == access) {
                    retVal = 5;
                    mLogger.severe("Protect: validate parameters not invalid lunMappingConfigure must be null and inquiryProtection must be null or equal to 1 and timePeriod must be null if protectExpirationType != 2");
                } else if (null != lunMappingConfigure || inquiryProtection != null && (inquiryProtection.length != 1 || inquiryProtection[0].intValue() != 1) || null != protectExpirationType && protectExpirationType.intValue() != 2 && timePeriod != null) {
                    mLogger.severe("Protect: inquiryProtection must be 1 and its value is " + Arrays.toString(inquiryProtection) + " protectionExpirationType must be " + 2 + " and its value is " + protectExpirationType + " timePeriod can not be null and it's value is" + timePeriod);
                    retVal = 1;
                } else if (access.intValue() == 4 && null != denyAsCopyTarget) {
                    mLogger.log(Level.SEVERE, "{0}: {1} must be null if {2} is {3}", new Object[]{"Protect", "DenyAsCopyTarget", "Access", 4});
                    retVal = 1;
                } else if (0 == retVal) {
                    if (null != timePeriod) {
                        retentionTime = timePeriod.getDays();
                        if (timePeriod.getHours() >= 12) {
                            ++retentionTime;
                        }
                        if (retentionTime > 21900) {
                            mLogger.severe("Protect: invalid retention time," + retentionTime + ", it must be less then " + 21900);
                            retVal = 5;
                        }
                    } else if (protectExpirationType != null && 3 == protectExpirationType.intValue()) {
                        retentionTime = -1;
                    }
                }
            }
            byte newGuardVal = 0;
            if (0 == retVal) {
                int iAccess = access.intValue();
                switch (iAccess) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        newGuardVal = (byte)(newGuardVal | 2);
                        break;
                    }
                    case 3: {
                        mLogger.severe("Protect: Guard Value '3' is not supported");
                        retVal = 1;
                        break;
                    }
                    case 4: {
                        newGuardVal = (byte)(newGuardVal | 1);
                        break;
                    }
                    default: {
                        mLogger.severe("Protect: Guard Value '" + iAccess + "' is unknown");
                        retVal = 5;
                    }
                }
                if (0 == retVal && null != denyAsCopyTarget && denyAsCopyTarget.booleanValue()) {
                    newGuardVal = (byte)(newGuardVal | 0x40);
                }
            }
            if (0 == retVal) {
                CIMProperty cpDeviceID = opLDevExtent.getKey("DeviceID");
                if (null != cpDeviceID && null != cpDeviceID.getValue()) {
                    String dnString = (String)cpDeviceID.getValue();
                    DeviceNumber deviceNumber = DeviceNumber.find(dnString, device.getRMIObject());
                    if (null != deviceNumber) {
                        if (!ResourceRestriction.isVolumeUsageUsable(deviceNumber)) {
                            mLogger.log(Level.SEVERE, "{0}:Volume {1} belongs to a restricted pool", new Object[]{"Protect", deviceNumber.getDn()});
                            retVal = 5;
                        } else if (!deviceNumber.isOpenVolume()) {
                            mLogger.severe("ProtectVolume is not OPEN: " + opLDevExtent);
                            retVal = 5;
                        } else {
                            Protect protectJob = new Protect(mHandle.getProperty("javax.wbem.provider.Principal"), pOp.getHost(), pOp, deviceNumber, newGuardVal, retentionTime, opLDevExtent);
                            CIM_ConcreteJob job = protectJob.submitJob();
                            if (job != null) {
                                mLogger.log(Level.INFO, "Job created: {0}, params: {1}", new Object[]{job.getInstanceID(), protectJob.toString()});
                                pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)job.getCIMObjectPath(pOp));
                                retVal = 4096;
                            } else {
                                retVal = 4;
                            }
                        }
                    } else {
                        retVal = 5;
                        mLogger.severe("LDEV(" + deviceNumber + ") does not exist");
                    }
                } else {
                    retVal = 5;
                    mLogger.severe("ObjectPath:" + opLDevExtent + ", does not contain a valid DeviceID");
                }
            }
        }
        catch (Throwable th) {
            mLogger.log(Level.SEVERE, "Protect" + th.toString(), th);
            retVal = 4;
        }
        return new UnsignedInteger32((long)retVal);
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        CIMObjectPath opRet = this.generateObjectPath(op, o);
        try {
            CIMProperty[] keys = opRet.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("StartMode", CIMDataType.STRING_T, (Object)"Automatic", false), new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)mClassName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)mClassName, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)mClassName, false)};
            return new CIMInstance(opRet, props).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageProtectionService");
        try {
            RMIObjectCache rmiObj = (RMIObjectCache)o[0];
            String systemName = rmiObj.getSMISMappingContainer().getStorageSystemName();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProtectionService", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)mClassName, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageProtectionService", keys, op.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameVal;
            String name;
            String sccName;
            String ccName;
            String string = ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            if (null == ccName || !ccName.equals("HITACHI_StorageProtectionService")) {
                throw new WBEMException(6, op.toString());
            }
            String string2 = sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            if (null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            String string3 = name = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            if (null == name || !name.equals(mClassName)) {
                throw new WBEMException(6, op.toString());
            }
            String ssName = device.getStorageSystemName();
            String string4 = sysNameVal = null != op.getKey("SystemName") && null != op.getKey("SystemName").getValue() ? (String)op.getKey("SystemName").getValue() : null;
            if (null == sysNameVal || !sysNameVal.equals(ssName)) {
                throw new WBEMException(6, op != null ? op.toString() : null);
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 oRet = null;
        if (!"Protect".equalsIgnoreCase(pMethodName)) {
            throw new WBEMException(17, pOp.getObjectName() + " does not support the method: " + pMethodName);
        }
        oRet = this.extrinsic_Protect(pOp, pInArgs, pOutArgs);
        return oRet;
    }
}

