/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_ODGDgetGuardRetention;

public class StorageProtectionSettingInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"InstanceID", "SystemName"});
            String deviceNumber = null;
            if (expectedValues != null) {
                if (1 == devices.size()) {
                    String instID = (String)expectedValues.get("InstanceID");
                    deviceNumber = instID != null ? ProviderLibs.getEndString(instID) : (String)expectedValues.get("DeviceID");
                } else {
                    throw new WBEMException("Could not determine managed device for assoc call: " + expectedValues);
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<DeviceNumber> callback = new CallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList, device.getStorageSystemName());
                DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, null == propertyList || propertyList.length > 0, deviceNumber);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        DeviceNumber devNum = (DeviceNumber)o[0];
        try {
            CIMProperty[] keys = retOP.getKeys();
            String instanceID = (String)keys[0].getValue();
            short ldev = devNum.getLdev();
            Robj_interface_ODGDgetGuardRetention guardRetention = ProviderLibs.getGuardRetention(RMIObjectMapping.getRMIObjectMapping(devNum.getSerialNumber()).getRMIObject(), devNum);
            int retentionTerm = guardRetention.getIRetentionTerm((int)ldev);
            CIMDateTimeInterval remainingProtectionTime = new CIMDateTimeInterval(-1 == retentionTerm ? 99999999 : retentionTerm, 0, 0, 0, 0);
            int protectionExpirationSpecified = 2;
            if (0 == retentionTerm) {
                protectionExpirationSpecified = 1;
            } else if (-1 == retentionTerm) {
                protectionExpirationSpecified = 3;
            }
            CIMProperty[] retProps = new CIMProperty[]{keys[0], new CIMProperty("ProtectionControlled", CIMDataType.BOOLEAN_T, (Object)devNum.isProtected(), false), new CIMProperty("Access", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(devNum.getVolAccess()), false), new CIMProperty("InquiryProtection", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(1)}, false), new CIMProperty("DenyAsCopyTarget", CIMDataType.BOOLEAN_T, (Object)devNum.denyAsCopyTarget(), false), new CIMProperty("LUNMappingConfigurable", CIMDataType.BOOLEAN_T, (Object)devNum.isLUNMaskingAllowed(), false), new CIMProperty("ProtectionExpirationSpecified", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(protectionExpirationSpecified), false), new CIMProperty("RemainingProtectionTime", CIMDataType.DATETIME_T, (Object)remainingProtectionTime, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)instanceID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)instanceID, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)instanceID, false)};
            CIMInstance ret = new CIMInstance(retOP, retProps);
            return ret.filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_StorageProtectionSetting");
        DeviceNumber dn = (DeviceNumber)o[0];
        CIMObjectPath ret = null;
        if (null != op && null != dn) {
            String systemName;
            try {
                systemName = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getStorageSystemName();
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
            String instanceID = systemName + "." + dn.getDNAsString();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instanceID, true)};
            ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageProtectionSetting", keys, op.getXmlSchemaName());
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            String deviceID;
            String deviceIDValue;
            DeviceNumber dn;
            String instanceIDKeyVal;
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
            String string = instanceIDKeyVal = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instanceIDKeyVal) {
                throw new WBEMException(6, op.toString());
            }
            RMIObjectCache rmiObj = device.getRMIObject();
            String systemName = device.getStorageSystemName();
            String sysNameValue = ProviderLibs.getAllButEndString(instanceIDKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            if (null != sysNameValue && sysNameValue.equals(systemName) && (dn = DeviceNumber.find(deviceIDValue = ProviderLibs.getEndString(instanceIDKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR), true, rmiObj)) != null && null != (deviceID = dn.getDNAsString()) && deviceID.equals(deviceIDValue)) {
                return this.generateInstance(op, propertyList, dn);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private class CallbackHandler<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String sysName) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E dn = item;
                    CIMObjectPath retOP = StorageProtectionSettingInstrumentation.this.generateObjectPath(this.mOP, dn);
                    if (null != this.mRefInfo) {
                        this.mRefInfo.addReference(this.mIter, retOP);
                    } else if (this.mIsObjectPath) {
                        this.mIter.add(retOP);
                    } else {
                        this.mIter.add(StorageProtectionSettingInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, dn));
                    }
                }
                catch (WBEMException we) {
                    this.mIter.setException(we);
                    this.mIter.close();
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return true;
        }
    }
}

