/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class ThinProvisioningVolumeCompositeExtentBasedOnCompositeLDEVExtentInstrumentation
extends BaseAssocInstrumentation {
    private static final String CCN_HITACHI_THINPROVISIONINGVOLUMECOMPOSITEEXTENTBASEDONCOMPOSITELDEVEXTENT = "HITACHI_ThinProvisioningVolumeCompositeExtentBasedOnCompositeLDEVExtent";
    private static final String CCN_ANTECEDENT = "HITACHI_CompositeLDEVExtent";
    private static final String CCN_DEPENDENT = "HITACHI_ThinProvisioningVolumeCompositeExtent";

    protected ThinProvisioningVolumeCompositeExtentBasedOnCompositeLDEVExtentInstrumentation() {
        super(CCN_HITACHI_THINPROVISIONINGVOLUMECOMPOSITEEXTENTBASEDONCOMPOSITELDEVEXTENT, CCN_ANTECEDENT, "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.CompositeLDEVExtentInstrumentation"), CCN_DEPENDENT, "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningVolumeCompositeExtentInstrumentation"));
    }

    private void addCompositeDN(CustomCloseableIterator<?> iter, CIMObjectPath op, DeviceNumber dn, boolean isObjectPath, String[] propertyList) throws Exception {
        if (null != op && null != dn) {
            CIMObjectPath opCompLDev = this.getReference2Instrumentation().generateObjectPath(op, dn);
            CIMObjectPath opLDev = this.getReference1Instrumentation().generateObjectPath(op, dn);
            if (isObjectPath) {
                iter.add(this.generateObjectPath(op, opLDev, opCompLDev));
            } else {
                iter.add(this.generateInstance(op, propertyList, opLDev, opCompLDev));
            }
        }
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && CCN_HITACHI_THINPROVISIONINGVOLUMECOMPOSITEEXTENTBASEDONCOMPOSITELDEVEXTENT.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    DeviceNumber dnLDEV;
                    String deviceID;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                    if (null != deviceIDProp && null != (deviceID = (String)deviceIDProp.getValue()) && null != (dnLDEV = DeviceNumber.findHeadLUSE(deviceID, device.getRMIObject())) && dnLDEV.isAOUVol()) {
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, dnLDEV));
                        } else {
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, dnLDEV));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    DeviceNumber dn;
                    String deviceID;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                    if (null != deviceIDProp && null != (deviceID = (String)deviceIDProp.getValue()) && (dn = DeviceNumber.find(deviceID, true, device.getRMIObject())) != null) {
                        Long[] compDNs = dn.getCompositeComponents();
                        if (null != compDNs && compDNs.length > 0) {
                            for (Long compDN : compDNs) {
                                DeviceNumber dnLDEV = DeviceNumber.find(compDN.toString(), false, device.getRMIObject());
                                if (null == dnLDEV) continue;
                                if (isObjectPath) {
                                    iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, dnLDEV));
                                    continue;
                                }
                                iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, dnLDEV));
                            }
                        } else if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, dn));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, dn));
                        }
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                Callback<DeviceNumber> callback = new Callback<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList);
                DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1, true, VolumeTypeEnum.AOUVOL);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        return new CIMProperty[]{new CIMProperty("StartingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("EndingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("OrderIndex", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false)};
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opTPVolCompExt;
            CIMObjectPath lDevOP = op.getKey(this.getReference1PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference1PropertyName()).getValue() : null;
            CIMObjectPath cIMObjectPath = opTPVolCompExt = op.getKey(this.getReference2PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference2PropertyName()).getValue() : null;
            if (null != opTPVolCompExt && null != lDevOP) {
                DeviceNumber dn;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opTPVolCompExt, "SystemName");
                String tpVolCompExtDeviceID = (String)opTPVolCompExt.getKeyValue("DeviceID");
                String lDevDeviceID = (String)lDevOP.getKeyValue("DeviceID");
                String tpVolCompExtCCName = (String)opTPVolCompExt.getKeyValue("CreationClassName");
                String tpVolCompExtSCCName = (String)opTPVolCompExt.getKeyValue("SystemCreationClassName");
                String tpVolCompExtSysNameKeyVal = (String)opTPVolCompExt.getKeyValue("SystemName");
                String lDevCCName = (String)lDevOP.getKeyValue("CreationClassName");
                String lDevSCCName = (String)lDevOP.getKeyValue("SystemCreationClassName");
                String lDevSysNameKeyVal = (String)lDevOP.getKeyValue("SystemName");
                if (null != tpVolCompExtCCName && tpVolCompExtCCName.equals(this.getReference2ClassName()) && null != tpVolCompExtSCCName && tpVolCompExtSCCName.equals("HITACHI_StorageSystem") && null != tpVolCompExtSysNameKeyVal && tpVolCompExtSysNameKeyVal.equals(lDevSysNameKeyVal) && null != lDevCCName && lDevCCName.equals(this.getReference1ClassName()) && null != lDevSCCName && lDevSCCName.equals("HITACHI_StorageSystem") && null != (dn = DeviceNumber.find(tpVolCompExtDeviceID, true, device.getRMIObject()))) {
                    CIMObjectPath opLDev = this.getReference1Instrumentation().generateObjectPath(op, dn);
                    if (tpVolCompExtDeviceID.equals(lDevDeviceID)) {
                        CIMObjectPath opCompLDev = this.getReference2Instrumentation().generateObjectPath(op, dn);
                        return this.generateInstance(op, propertyList, opLDev, opCompLDev);
                    }
                    Long[] compDNs = dn.getCompositeComponents();
                    if (null != compDNs && compDNs.length > 0) {
                        for (Long compDN : compDNs) {
                            if (null == compDN || !compDN.toString().equals(lDevDeviceID)) continue;
                            CIMObjectPath opCompLDev = this.getReference2Instrumentation().generateObjectPath(op, dn);
                            return this.generateInstance(op, propertyList, opLDev, opCompLDev);
                        }
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != objectName && null != objectName.getKey("DeviceID") ? (String)objectName.getKey("DeviceID").getValue() : null;
        hTable.put("DeviceID", name);
        return hTable;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && CCN_HITACHI_THINPROVISIONINGVOLUMECOMPOSITEEXTENTBASEDONCOMPOSITELDEVEXTENT.equalsIgnoreCase(assocName.getObjectName())) {
                String deviceID = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                        if (null != deviceIDProp) {
                            deviceID = (String)deviceIDProp.getValue();
                            DeviceNumber data = DeviceNumber.find(deviceID, device.getRMIObject());
                            CIMObjectPath opLDev = this.getReference1Instrumentation().generateObjectPath(objectName, data);
                            DeviceNumber dnCompLDEV = DeviceNumber.findHeadLUSE(deviceID, device.getRMIObject());
                            if (null != dnCompLDEV && dnCompLDEV.isAOUVol()) {
                                CIMObjectPath opCompLDev = this.getReference2Instrumentation().generateObjectPath(objectName, dnCompLDEV);
                                if (isObjectPath) {
                                    iter.add(this.generateObjectPath(objectName, opLDev, opCompLDev));
                                } else {
                                    iter.add(this.generateInstance(objectName, propertyList, opLDev, opCompLDev));
                                }
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                    if (null != deviceIDProp && null != (deviceID = (String)deviceIDProp.getValue())) {
                        DeviceNumber dn = DeviceNumber.find(deviceID, true, device.getRMIObject());
                        this.addCompositeDN(iter, objectName, dn, isObjectPath, propertyList);
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private class Callback<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected Callback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) {
                ret = false;
            } else {
                try {
                    if (null != item) {
                        ThinProvisioningVolumeCompositeExtentBasedOnCompositeLDEVExtentInstrumentation.this.addCompositeDN(this.mIter, this.mOP, item, this.mIsObjectPath, this.mPropertyList);
                    }
                }
                catch (Exception e) {
                    WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
                catch (Throwable th) {
                    WBEMException we = new WBEMException(1, th.toString(), null, th);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return ret;
        }
    }
}

