/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VirtualLDEV;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import com.hitachi.smi.instrumentation.StorageVolumeInstrumentation;
import com.hitachi.smi.instrumentation.StorageVolumeSettingInstrumentation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class VolumeViewInstrumentation
extends BaseInstrumentation {
    private static final String VOLUME_VIEW = "VolumeView";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SVSystemName", expectedValues, new String[]{"SystemName", "SVDeviceID", "SPInstanceID"});
        try {
            int fb4 = -1;
            int pg = -1;
            int vdev = -1;
            int ag = -1;
            String expID = null;
            if (expectedValues != null) {
                if (devices.size() == 1) {
                    expID = (String)expectedValues.get("SVDeviceID");
                    String string = expID = expID != null ? expID : (String)expectedValues.get("DeviceID");
                    if (expID != null) {
                        RMIObjectCache rmiObj;
                        DeviceNumber dn;
                        if (expID.contains(".")) {
                            expID = ProviderLibs.getEndString(expID);
                        }
                        if ((dn = DeviceNumber.find(expID, true, rmiObj = devices.get(0).getRMIObject())) != null) {
                            fb4 = dn.getFb4();
                            pg = dn.getPg();
                            vdev = dn.getVdev();
                        } else {
                            mLogger.log(Level.SEVERE, "Could not find DeviceNumber: {0}", expID);
                            devices.clear();
                        }
                    } else {
                        String instID = (String)expectedValues.get("SPInstanceID");
                        if (instID != null) {
                            Integer[] ret = ProviderLibs.getInstanceIDInts(instID);
                            fb4 = ret[0];
                            ag = ret[1];
                        }
                    }
                } else {
                    mLogger.log(Level.SEVERE, "Association data passed but number of devices: {0}", devices.size());
                    devices.clear();
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                RMIObjectCache rmiObj = device.getRMIObject();
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(deviceIter, isObjectPath, refInfo, op, propertyList, ag, expID);
                ChassisArrayGroup.getChassisArrayGroup(rmiObj, callback, isObjectPath, fb4, pg, vdev, ag);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(p, o);
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        DeviceNumber dn = (DeviceNumber)o[1];
        try {
            VirtualLDEV vDN;
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
            ArrayList props = new ArrayList();
            UnsignedInteger16 usage = dn.getUsageValue();
            CIMProperty[] keys = retOP.getKeys();
            ProviderLibs.addKeysToProperties(keys, props);
            props.add(new CIMProperty("SPPoolID", CIMDataType.STRING_T, (Object)StoragePoolInstrumentation.getPoolID(cag), false));
            String[] extentDiscriminator = StorageVolumeInstrumentation.getExtentDiscriminator(usage);
            props.add(new CIMProperty("SVExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)extentDiscriminator, false));
            props.add(new CIMProperty("SVPrimordial", CIMDataType.BOOLEAN_T, (Object)false, false));
            props.add(new CIMProperty("SVNameNamespace", CIMDataType.UINT16_T, (Object)ProviderLibs.getNameNameSpace(device, dn.getVolumeFlag()), false));
            props.add(new CIMProperty("SVName", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false));
            props.add(new CIMProperty("SVNameFormat", CIMDataType.UINT16_T, (Object)ProviderLibs.getNameFormat(dn.getVolumeFlag()), false));
            props.add(new CIMProperty("SVExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)StorageVolumeInstrumentation.extentStatus, false));
            props.add(new CIMProperty("SVOperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)StorageVolumeInstrumentation.opStatus, false));
            props.add(new CIMProperty("SVBlockSize", CIMDataType.UINT64_T, (Object)cag.getBlockSize(), false));
            props.add(new CIMProperty("SVNumberOfBlocks", CIMDataType.UINT64_T, (Object)cag.getNumberOfBlocks(), false));
            props.add(new CIMProperty("SVConsumableBlocks", CIMDataType.UINT64_T, (Object)cag.getConsumableblocks(), false));
            String rlString = dn.getRaidLevel();
            ProviderConstants.RAID_Level raidLevel = ProviderLibs.getRaidLevelFromString(rlString);
            props.add(new CIMProperty("SVIsBasedOnUnderlyingRedundancy", CIMDataType.BOOLEAN_T, (Object)(raidLevel != ProviderConstants.RAID_Level.RAID0 && raidLevel != ProviderConstants.RAID_Level.UNKNOWN ? 1 : 0), false));
            props.add(new CIMProperty("SVNoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)(raidLevel != ProviderConstants.RAID_Level.RAID0 && raidLevel != ProviderConstants.RAID_Level.UNKNOWN ? 1 : 0), false));
            UnsignedInteger16 valDataRedendancy = new UnsignedInteger16(ProviderLibs.getDataRedudancy(rlString));
            props.add(new CIMProperty("SVDataRedundancy", CIMDataType.UINT16_T, (Object)valDataRedendancy, false));
            UnsignedInteger16 valPackageRedundancy = new UnsignedInteger16(ProviderLibs.getPackageRedudancy(rlString));
            props.add(new CIMProperty("SVPackageRedundancy", CIMDataType.UINT16_T, (Object)valPackageRedundancy, false));
            props.add(new CIMProperty("SVDeltaReservation", CIMDataType.UINT8_T, (Object)StorageVolumeInstrumentation.deltaReservation, false));
            props.add(new CIMProperty("SVUsage", CIMDataType.UINT16_T, (Object)usage, false));
            props.add(new CIMProperty("SSElementName", CIMDataType.STRING_T, (Object)dn.getDNAsString(), false));
            try {
                vDN = VirtualLDEV.find(device.getRMIObject(), dn.getDNAsString());
            }
            catch (Throwable e) {
                vDN = null;
                mLogger.log(Level.SEVERE, "Error trying to find Virtual LDEV information for " + dn.getDNAsString(), e);
            }
            props.add(new CIMProperty("SVOtherIdentifyingInfo", CIMDataType.STRING_ARRAY_T, (Object)ProviderLibs.getOtherIdentifyingInfo(dn, vDN, StorageVolumeInstrumentation.getStorageVolumeName(dn, vDN)), false));
            props.add(new CIMProperty("SVIdentifyingDescriptions", CIMDataType.STRING_ARRAY_T, null, false));
            props.add(new CIMProperty("AFSPSpaceConsumed", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(dn.getSpaceConsumed())), false));
            String svsInstID = ProviderLibs.createInstanceID(null, device.getStorageSystemName(), null, BigInteger.valueOf(dn.getDn()), null);
            props.add(new CIMProperty("SSInstanceID", CIMDataType.STRING_T, (Object)svsInstID, true));
            props.add(new CIMProperty("SVElementName", CIMDataType.STRING_T, (Object)rlString, false));
            boolean raid1Plus = true;
            if (rlString.compareTo("UNKNOWN") == 0 || rlString.equalsIgnoreCase("RAID0")) {
                raid1Plus = false;
            }
            props.add(new CIMProperty("SSNoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)raid1Plus, false));
            props.add(new CIMProperty("SSDataRedundancyMax", CIMDataType.UINT16_T, (Object)valDataRedendancy, false));
            props.add(new CIMProperty("SSDataRedundancyMin", CIMDataType.UINT16_T, (Object)valDataRedendancy, false));
            props.add(new CIMProperty("SSDataRedundancyGoal", CIMDataType.UINT16_T, (Object)valDataRedendancy, false));
            props.add(new CIMProperty("SSPackageRedundancyMax", CIMDataType.UINT16_T, (Object)valPackageRedundancy, false));
            props.add(new CIMProperty("SSPackageRedundancyMin", CIMDataType.UINT16_T, (Object)valPackageRedundancy, false));
            props.add(new CIMProperty("SSPackageRedundancyGoal", CIMDataType.UINT16_T, (Object)valPackageRedundancy, false));
            props.add(new CIMProperty("SSChangeableType", CIMDataType.UINT16_T, (Object)StorageVolumeSettingInstrumentation.CHANGEABLE_TYPE_VALUE, false));
            int valExtentStripeLn = ProviderLibs.getExtentStripeLen(rlString);
            UnsignedInteger16 cvExtentStripeLn = new UnsignedInteger16(valExtentStripeLn);
            props.add(new CIMProperty("SSExtentStripeLength", CIMDataType.UINT16_T, (Object)cvExtentStripeLn, false));
            props.add(new CIMProperty("SSExtentStripeLengthMax", CIMDataType.UINT16_T, (Object)cvExtentStripeLn, false));
            props.add(new CIMProperty("SSExtentStripeLengthMin", CIMDataType.UINT16_T, (Object)cvExtentStripeLn, false));
            props.add(new CIMProperty("SSParityLayout", CIMDataType.UINT16_T, (Object)ProviderLibs.getParityLayout(rlString), false));
            props.add(new CIMProperty("SSUserDataStripeDepth", CIMDataType.UINT64_T, null, false));
            props.add(new CIMProperty("SSUserDataStripeDepthMin", CIMDataType.UINT64_T, null, false));
            props.add(new CIMProperty("SSUserDataStripeDepthMax", CIMDataType.UINT64_T, null, false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)VOLUME_VIEW, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)VOLUME_VIEW, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)VOLUME_VIEW, false));
            return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath p, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ChassisArrayGroup.class, BaseDeviceNumber.class}, o, "SNIA_VolumeView");
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        BaseDeviceNumber dn = (BaseDeviceNumber)o[1];
        try {
            String systemName = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber()).getStorageSystemName();
            String keyValue = ProviderLibs.createInstanceID(null, systemName, (Integer)cag.getFb4(), cag.getArrayGroup(), null);
            Long devNum = BaseDeviceNumber.makeUniqueDN(dn.getLdkc(), dn.getCu(), dn.getLdev());
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("SPInstanceID", CIMDataType.STRING_T, (Object)keyValue, true), new CIMProperty("SVSystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SVDeviceID", CIMDataType.STRING_T, (Object)devNum.toString(), true), new CIMProperty("SVCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageVolume", true), new CIMProperty("SVSystemName", CIMDataType.STRING_T, (Object)systemName, true)};
            return new CIMObjectPath(p.getScheme(), p.getHost(), p.getPort(), p.getNamespace(), "HITACHI_VolumeView", keys, p.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SPInstanceID");
        try {
            CIMProperty cpSVCreationClassName = op.getKey("SVCreationClassName");
            if (null == cpSVCreationClassName || !"HITACHI_StorageVolume".equals(cpSVCreationClassName.getValue())) {
                throw new WBEMException(6, op.toString());
            }
            CIMProperty cpSVSystemCreationClassName = op.getKey("SVSystemCreationClassName");
            if (null == cpSVSystemCreationClassName || !"HITACHI_StorageSystem".equals(cpSVSystemCreationClassName.getValue())) {
                throw new WBEMException(6, op.toString());
            }
            CIMProperty cpSVSystemName = op.getKey("SVSystemName");
            String sysName = device.getStorageSystemName();
            if (null == cpSVSystemName || null == cpSVSystemName.getValue() || !cpSVSystemName.getValue().equals(sysName)) {
                throw new WBEMException(6, op.toString());
            }
            CIMProperty cpSPInstanceID = op.getKey("SPInstanceID");
            if (null == cpSPInstanceID || null == cpSPInstanceID.getValue()) {
                throw new WBEMException(6, op.toString());
            }
            CIMProperty cpSVDeviceID = op.getKey("SVDeviceID");
            if (null == cpSVDeviceID || null == cpSVDeviceID.getValue()) {
                throw new WBEMException(6, op.toString());
            }
            String cvDeviceID = (String)cpSVDeviceID.getValue();
            String cvInstanceID = (String)cpSPInstanceID.getValue();
            if (null != cvDeviceID && null != cvInstanceID) {
                DeviceNumber dn;
                Integer[] rets = ProviderLibs.getStoragePoolChassisAndArrayGroup(cvInstanceID);
                int chassis = rets[0];
                int arrayGroup = rets[1];
                ChassisArrayGroup data = ChassisArrayGroup.find(device.getRMIObject(), null, chassis, arrayGroup, false);
                if (data != null && null != (dn = DeviceNumber.find(cvDeviceID, device.getRMIObject()))) {
                    return this.generateInstance(op, propertyList, data, dn);
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            if (6 == we.getID() || 1 == we.getID()) {
                throw we;
            }
            throw new WBEMException(1, we.toString(), null, (Throwable)we);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        private final int arrayGroup;
        private final String devNum2Match;

        private CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, int ag, String dn2Look4) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.arrayGroup = ag;
            this.devNum2Match = dn2Look4;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E cag = item;
                    if (-1 != this.arrayGroup && ((ChassisArrayGroup)cag).getArrayGroup() != this.arrayGroup) {
                        ret = true;
                    }
                    for (BaseDeviceNumber bdn : ((ChassisArrayGroup)cag).getContainedDNs()) {
                        if (this.devNum2Match != null && this.devNum2Match.compareTo(bdn.getDNAsString()) != 0) continue;
                        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)cag).getSerialNumber());
                        DeviceNumber dn = DeviceNumber.find(bdn.getDNAsString(), true, device.getRMIObject());
                        if (null == dn) continue;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, VolumeViewInstrumentation.this.generateObjectPath(this.mOP, cag, dn));
                            continue;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(VolumeViewInstrumentation.this.generateObjectPath(this.mOP, cag, dn));
                            continue;
                        }
                        this.mIter.add(VolumeViewInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, cag, dn));
                    }
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }
}

