/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.providers.constants.hitachi.HITACHI_WBEMServerSystemConstants;
import com.ws.wbem.jserver.JServerProperties;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class WBEMServerSystemInstrumentation
extends BaseInstrumentation {
    private String createNameValue(CIMObjectPath op, RMIObjectCache rmiObj) throws WBEMException {
        StringBuilder name = new StringBuilder(rmiObj.getSMISMappingContainer().getStorageSystemName());
        name = name.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        name.append(JServerProperties.getServerHost());
        return name.toString();
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Name", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                if (null != refInfo) {
                    refInfo.addReference(iter, ci.getObjectPath());
                    continue;
                }
                if (isObjectPath) {
                    iter.add(ci.getObjectPath());
                    continue;
                }
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        try {
            String name = "HITACHI SMI-S Provider";
            String installdate = JServerProperties.getInstallDate();
            CIMDateTimeAbsolute dtInstallDate = null;
            if (null != installdate) {
                dtInstallDate = new CIMDateTimeAbsolute(installdate);
            }
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], new CIMProperty("NameFormat", CIMDataType.STRING_T, (Object)"Other", false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(2)}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"HITACHI SMI-S Provider", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"HITACHI SMI-S Provider", false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI SMI-S Provider", false), new CIMProperty("InstallDate", CIMDataType.DATETIME_T, (Object)dtInstallDate, false), new CIMProperty("Dedicated", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(28)}, false)};
            return new CIMInstance(retOP, props).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "CIM_ComputerSystem");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)HITACHI_WBEMServerSystemConstants.CCN_HITACHI_COMPUTERSYSTEM, true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)this.createNameValue(op, rmiObj), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), HITACHI_WBEMServerSystemConstants.CCN_HITACHI_COMPUTERSYSTEM, keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            String nameVal;
            String ccName;
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Name");
            CIMProperty cpCCN = op.getKey("CreationClassName");
            String string = ccName = null != cpCCN ? (String)cpCCN.getValue() : null;
            if (null == ccName || !ccName.equals(HITACHI_WBEMServerSystemConstants.CCN_HITACHI_COMPUTERSYSTEM)) {
                throw new WBEMException(6, op.toString());
            }
            String name = this.createNameValue(op, device.getRMIObject());
            CIMProperty cpName = op.getKey("Name");
            String string2 = nameVal = null != cpName ? (String)cpName.getValue() : null;
            if (null == nameVal || !nameVal.equals(name)) {
                throw new WBEMException(6, op.toString());
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

