/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.PortStats;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ElementStatisticalDataEthernetPortInstrumentation
extends BaseAssocInstrumentation {
    public ElementStatisticalDataEthernetPortInstrumentation() {
        super("HITACHI_ElementStatisticalDataEthernetPort", "HITACHI_EthernetPort", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.iSCSI.EthernetPortInstrumentation"), "HITACHI_BlockStatisticalDataEthernetPort", "Stats", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.iSCSI.BlockStatisticalDataEthernetPortInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ElementStatisticalDataEthernetPort".equalsIgnoreCase(assocName.getObjectName())) {
                FCPort fcPort;
                String macAddress = null;
                String sysName = null;
                boolean returnFCPort = false;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("ManagedElement")) && (null == resultRole || resultRole.equalsIgnoreCase("Stats"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvSysName;
                        device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        String devID = (String)objectName.getKeyValue("DeviceID");
                        macAddress = ProviderLibs.getEndString(devID);
                        CIMProperty cpSysName = objectName.getKey("SystemName");
                        String string = cvSysName = cpSysName != null ? (String)cpSysName.getValue() : null;
                        if (null != cvSysName) {
                            sysName = ProviderLibs.getAllButEndString(cvSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    String cvInstID;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMProperty cpInstID = objectName.getKey("InstanceID");
                    String string = cvInstID = cpInstID != null ? (String)cpInstID.getValue() : null;
                    if (null != cvInstID) {
                        macAddress = ProviderLibs.getEndString(cvInstID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        sysName = ProviderLibs.getAllButEndString(cvInstID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    }
                    returnFCPort = true;
                }
                if (null != device && null != macAddress && null != sysName && sysName.equals(device.getStorageSystemName()) && (fcPort = FCPort.find(macAddress, FCPort.PortTypeRequested.iSCSI, device.getRMIObject())) != null) {
                    if (returnFCPort) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, fcPort));
                        } else {
                            CIMInstance fcport = this.getReference1Instrumentation().generateInstance(objectName, propertyList, fcPort);
                            iter.add(fcport.filterProperties(propertyList));
                        }
                    } else {
                        PortStats stats = PortStats.findPortStats(device, fcPort);
                        if (null != stats) {
                            if (isObjectPath) {
                                iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, fcPort, stats));
                            } else {
                                CIMInstance statsInst = this.getReference2Instrumentation().generateInstance(objectName, propertyList, fcPort, stats);
                                iter.add(statsInst.filterProperties(propertyList));
                            }
                        } else {
                            mLogger.log(Level.WARNING, "Unable to find stats for {0}", fcPort);
                        }
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter) {
                iter.done();
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                CloseableAddableIterator psIter = new CloseableAddableIterator();
                PortStats.getIndividualPortStats(device, (CloseableAddableIterator<PortStats>)psIter);
                while (psIter.hasNext()) {
                    PortStats portStats = (PortStats)psIter.next();
                    FCPort fcPort = FCPort.find(portStats.getPortID(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                    if (null != fcPort) {
                        CIMObjectPath opFCPort = this.getReference1Instrumentation().generateObjectPath(op, fcPort);
                        CIMObjectPath opBSDFP = this.getReference2Instrumentation().generateObjectPath(op, fcPort, portStats);
                        CIMInstance instAssoc = this.generateInstance(op, propertyList, opFCPort, opBSDFP);
                        iter.add(instAssoc);
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "No iSCSI FCPort associated to {0}", portStats);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opBSDFP;
            String pnFCPort = this.getReference1PropertyName();
            CIMObjectPath opFCPort = op.getKey(pnFCPort) != null ? (CIMObjectPath)op.getKey(pnFCPort).getValue() : null;
            String pnBSDFP = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opBSDFP = op.getKey(pnBSDFP) != null ? (CIMObjectPath)op.getKey(pnBSDFP).getValue() : null;
            if (null != opFCPort && null != opBSDFP) {
                String cvInstID;
                String cvSysName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opFCPort, "SystemName");
                String cvFCPortWWN = null;
                String cvFCPortSystemName = null;
                CIMProperty cpDevID = opFCPort.getKey("DeviceID");
                cvFCPortWWN = null != cpDevID ? (String)cpDevID.getValue() : null;
                CIMProperty cpSysName = opFCPort.getKey("SystemName");
                String string = cvSysName = null != cpSysName ? (String)cpSysName.getValue() : null;
                if (null != cvSysName) {
                    cvFCPortSystemName = ProviderLibs.getAllButEndString(cvSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                }
                String cvBSDFPortWWN = null;
                String cvBSDFPSystemName = null;
                CIMProperty cpInstID = opBSDFP.getKey("InstanceID");
                String string2 = cvInstID = null != cpInstID ? (String)cpInstID.getValue() : null;
                if (null != cvInstID) {
                    cvBSDFPortWWN = ProviderLibs.getEndString(cvInstID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    cvBSDFPSystemName = ProviderLibs.getAllButEndString(cvInstID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                }
                if (null != cvBSDFPSystemName && null != cvFCPortSystemName && null != cvBSDFPortWWN && null != cvFCPortWWN) {
                    FCPort fcPort;
                    cvFCPortWWN = ProviderLibs.getEndString(cvFCPortWWN);
                    if (cvBSDFPSystemName.equals(cvFCPortSystemName) && cvBSDFPortWWN.equals(cvFCPortWWN) && cvBSDFPSystemName.equals(device.getStorageSystemName()) && (fcPort = FCPort.find(cvBSDFPortWWN, FCPort.PortTypeRequested.iSCSI, device.getRMIObject())) != null) {
                        PortStats stats = PortStats.findPortStats(device, fcPort);
                        if (null != stats) {
                            opFCPort = this.getReference1Instrumentation().generateObjectPath(op, fcPort);
                            opBSDFP = this.getReference2Instrumentation().generateObjectPath(op, fcPort, stats);
                            CIMInstance instAssoc = this.generateInstance(op, propertyList, opFCPort, opBSDFP);
                            return instAssoc.filterProperties(propertyList);
                        }
                        throw new WBEMException("Unable to find stats matching EthernetPort " + fcPort.getPort());
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ElementStatisticalDataEthernetPort".equalsIgnoreCase(assocName.getObjectName())) {
                FCPort fcPort;
                String macAddress = null;
                String sysName = null;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvSysName;
                        device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        String devID = (String)objectName.getKeyValue("DeviceID");
                        macAddress = ProviderLibs.getEndString(devID);
                        CIMProperty cpSysName = objectName.getKey("SystemName");
                        String string = cvSysName = cpSysName != null ? (String)cpSysName.getValue() : null;
                        if (null != cvSysName) {
                            sysName = ProviderLibs.getAllButEndString(cvSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    String cvInstID;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMProperty cpInstID = objectName.getKey("InstanceID");
                    String string = cvInstID = cpInstID != null ? (String)cpInstID.getValue() : null;
                    if (null != cvInstID) {
                        macAddress = ProviderLibs.getEndString(cvInstID);
                        sysName = ProviderLibs.getAllButEndString(cvInstID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    }
                }
                if (null != device && null != macAddress && null != sysName && sysName.equals(device.getStorageSystemName()) && (fcPort = FCPort.find(macAddress, FCPort.PortTypeRequested.iSCSI, device.getRMIObject())) != null) {
                    PortStats stats = PortStats.findPortStats(device, fcPort);
                    if (null != stats) {
                        CIMObjectPath opFCPort = this.getReference1Instrumentation().generateObjectPath(objectName, fcPort);
                        CIMObjectPath opBSDFCP = this.getReference2Instrumentation().generateObjectPath(objectName, fcPort, stats);
                        CIMInstance instAssoc = this.generateInstance(objectName, propertyList, opFCPort, opBSDFCP);
                        if (isObjectPath) {
                            iter.add(instAssoc.getObjectPath());
                        } else {
                            iter.add(instAssoc.filterProperties(propertyList));
                        }
                    } else {
                        mLogger.log(Level.WARNING, "Unable to find stats for {0}", fcPort);
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }
}

