/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.ISCSIreadAlliScsiInitiator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class HostedStorageProcessorSystemiSCSIProtocolEndpointInstrumentation
extends BaseAssocInstrumentation {
    public HostedStorageProcessorSystemiSCSIProtocolEndpointInstrumentation() {
        super("HITACHI_HostedStorageProcessorSystemiSCSIProtocolEndpoint", "HITACHI_StorageProcessorSystem", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"), "HITACHI_iSCSIProtocolEndpoint", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.iSCSI.iSCSIProtocolEndpointInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedStorageProcessorSystemiSCSIProtocolEndpoint".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        this.getDependentObjects(objectName, isObjectPath, propertyList, iter, this.getReference2Instrumentation());
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && (null == resultRole || resultRole.equalsIgnoreCase("Antecedent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    this.getAntecedentObjects(objectName, isObjectPath, propertyList, iter, this.getReference1Instrumentation());
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                ClosableAddableIteratorCB<ISCSITargetPort> callback = new ClosableAddableIteratorCB<ISCSITargetPort>();
                ISCSITargetPort.getISCSIPorts(device.getRMIObject(), callback, -1);
                CloseableAddableIterator<ISCSITargetPort> portIter = callback.getWrappedCloseableAddableIter();
                while (portIter.hasNext()) {
                    ISCSITargetPort iSCSI = (ISCSITargetPort)portIter.next();
                    FCPort fcPort = FCPort.find((short)iSCSI.getPortId(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                    if (null != fcPort) {
                        for (ISCSITargetPort.ISCSITarget target : iSCSI.getTargets()) {
                            CIMObjectPath storProcOP = this.getReference1Instrumentation().generateObjectPath(op, fcPort);
                            CIMObjectPath ipOP = this.getReference2Instrumentation().generateObjectPath(op, target, fcPort);
                            iter.add(this.generateInstance(op, propertyList, storProcOP, ipOP));
                        }
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "iSCSI port {0} has no assocaited FCPort", iSCSI);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    private void getAntecedentObjects(CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, CustomCloseableIterator<?> iter, BaseInstrumentation bi) throws Exception {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
        CIMProperty cpSysName = objectName.getKey("SystemName");
        if (null != cpSysName && null != cpSysName.getValue()) {
            String ctrID = ProviderLibs.getEndString((String)cpSysName.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
            CHAInfo chaInfo = CHAInfo.find(Integer.parseInt(ctrID), device.getRMIObject());
            if (isObjectPath) {
                iter.add(bi.generateObjectPath(objectName, chaInfo));
            } else {
                try {
                    iter.add(bi.generateInstance(objectName, propertyList, chaInfo));
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
        }
    }

    private void getDependentObjects(CIMObjectPath objectName, boolean isObjectPath, String[] propertyList, CustomCloseableIterator<?> iter, BaseInstrumentation bi) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
        String name = (String)objectName.getKeyValue("Name");
        if (null != name) {
            try {
                ClosableAddableIteratorCB<FCPort> callback = new ClosableAddableIteratorCB<FCPort>();
                FCPort.getFCPorts(device.getRMIObject(), callback, false, true, null, name);
                CloseableAddableIterator<FCPort> portIter = callback.getWrappedCloseableAddableIter();
                while (portIter.hasNext()) {
                    FCPort port = (FCPort)portIter.next();
                    this.processInitiators(objectName, iter, isObjectPath, device, port, propertyList, bi);
                    this.processTargets(objectName, iter, isObjectPath, device, port, propertyList, bi);
                }
            }
            catch (Throwable th) {
                mLogger.log(Level.FINE, th.toString(), th);
            }
        } else {
            mLogger.log(Level.WARNING, "{0} property not foudn in {1}", new Object[]{"Name", objectName});
        }
    }

    private void processInitiators(CIMObjectPath objectName, CustomCloseableIterator<?> iter, boolean isObjectPath, RMIObjectMapping device, FCPort port, String[] propertyList, BaseInstrumentation bi) throws Exception {
        ClosableAddableIteratorCB<ISCSIreadAlliScsiInitiator> cb2 = new ClosableAddableIteratorCB<ISCSIreadAlliScsiInitiator>();
        ISCSIreadAlliScsiInitiator.getAll(device.getRMIObject(), cb2, port.getPort());
        CloseableAddableIterator<ISCSIreadAlliScsiInitiator> initiatorIter = cb2.getWrappedCloseableAddableIter();
        while (initiatorIter.hasNext()) {
            ISCSIreadAlliScsiInitiator initiator = (ISCSIreadAlliScsiInitiator)initiatorIter.next();
            if (isObjectPath) {
                iter.add(bi.generateObjectPath(objectName, initiator, port));
                continue;
            }
            iter.add(bi.generateInstance(objectName, propertyList, initiator, port));
        }
    }

    private void processTargets(CIMObjectPath objectName, CustomCloseableIterator<?> iter, boolean isObjectPath, RMIObjectMapping device, FCPort port, String[] propertyList, BaseInstrumentation bi) throws Exception {
        ISCSITargetPort iSCSI = ISCSITargetPort.find(device.getRMIObject(), port.getPort());
        if (null == iSCSI) {
            mLogger.log(Level.INFO, "No iSCSI Targets for port {0}", port.getPort());
            return;
        }
        for (ISCSITargetPort.ISCSITarget target : iSCSI.getTargets()) {
            if (isObjectPath) {
                iter.add(bi.generateObjectPath(objectName, target, port));
                continue;
            }
            iter.add(bi.generateInstance(objectName, propertyList, target, port));
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedStorageProcessorSystemiSCSIProtocolEndpoint".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        this.getDependentObjects(objectName, isObjectPath, propertyList, iter, this);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    this.getAntecedentObjects(objectName, isObjectPath, propertyList, iter, this);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter) {
                iter.done();
            }
        }
    }
}

