/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.LDevNickname;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.VirtualLDEV;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.ElementNameData;
import com.hitachi.smi.jobs.SetResourceNameHelper;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_CVSgetLDEVIDInfo;
import sanproject.common.Robj_interface_RJiLDEVIDInfo;
import sanproject.common.Robj_interface_RJiResourceName;
import sanproject.serverux.data.SANRmiException;

public abstract class CoalescedCreateModifyVolumeBase
extends Coalescable {
    private final List<Short> usedLDEVs = new ArrayList<Short>();
    protected final List<Robj_interface_RJiResourceName> elementNames = new ArrayList<Robj_interface_RJiResourceName>();
    private volatile SetResourceNameHelper resourceNameHelper = null;

    protected CoalescedCreateModifyVolumeBase() {
    }

    protected short[] getCULdev(RMIObjectCache rmiobj, int emulationType) throws WBEMException {
        Robj_interface_CVSgetLDEVIDInfo[] ldevIDs;
        short cu = -1;
        short ldev = -1;
        try {
            ldevIDs = rmiobj.getLDEVIDInfo();
        }
        catch (RemoteException re) {
            throw new WBEMException(1, "Unable to get available LDEVs " + re, null, (Throwable)re);
        }
        catch (SANRmiException se) {
            mLogger.log(Level.SEVERE, "RMI excpetion getting available LDEVs " + (Object)((Object)se), se);
            throw new WBEMException(1, "RMI excpetion getting available LDEVs " + se.toString(), null, (Throwable)se);
        }
        for (int index = 0; index < ldevIDs.length && -1 == ldev; ++index) {
            Robj_interface_CVSgetLDEVIDInfo id = ldevIDs[index];
            cu = id.getSCU();
            Robj_interface_RJiLDEVIDInfo[] objs = id.getObjLDEVID();
            for (short jj = 0; jj < objs.length && ldev == -1; jj = (short)((short)(jj + 1))) {
                VirtualLDEV v;
                switch (objs[jj].getLDEVID()) {
                    case -1: {
                        mLogger.log(Level.FINEST, "Cannot assign {0}:{1}:{2}", new Object[]{id.getSLDKC(), cu, jj});
                        break;
                    }
                    case 0: {
                        mLogger.log(Level.FINEST, "Already assigned {0}:{1}:{2}", new Object[]{id.getSLDKC(), cu, jj});
                        break;
                    }
                    case 1: {
                        mLogger.log(Level.FINEST, "Unassigned {0}:{1}:{3}, no emulation restriction", new Object[]{id.getSLDKC(), cu, jj});
                        ldev = jj;
                        break;
                    }
                    case 2: {
                        byte emulationByteVal = objs[jj].getEmulationTypeGroup();
                        mLogger.log(Level.FINEST, "Unassigned {0}:{1}:{2}, restricted to emulation {3}", new Object[]{id.getSLDKC(), cu, jj, emulationByteVal});
                        if (!ProviderLibs.isEmulationTypeGroup(rmiobj, emulationByteVal, emulationType)) break;
                        mLogger.log(Level.FINEST, "{0}:{1}:{2}, emulation type is supported", new Object[]{id.getSLDKC(), cu, jj});
                        ldev = jj;
                        break;
                    }
                    default: {
                        mLogger.log(Level.WARNING, "Unknown dkc:cu:ldev {0}:{1}:{2} value: {3}", new Object[]{id.getSLDKC(), cu, jj, objs[jj].getLDEVID()});
                    }
                }
                if (ldev != -1 && this.usedLDEVs.contains(ldev)) {
                    ldev = -1;
                    mLogger.log(Level.FINEST, "LDEV({0}) has already been assigned", ldev);
                    continue;
                }
                if (ldev == -1 || null == (v = VirtualLDEV.find(rmiobj, id.getSLDKC(), cu, ldev, -1)) || v.getVirtLDEVInfo().getCu() <= 254) continue;
                ldev = -1;
                mLogger.log(Level.FINEST, "LDEV({0}) is not usable due to virtual data", ldev);
            }
        }
        if (-1 == cu || -1 == ldev) {
            mLogger.log(Level.WARNING, "Could not find available cu:ldev");
        } else {
            mLogger.log(Level.FINE, "Found available LDEV, using cu:ldev {0}:{1}", new Object[]{cu, ldev});
            this.usedLDEVs.add(ldev);
        }
        return new short[]{cu, ldev};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Robj_interface_RJiResourceName getResourceNameRMIObject(SetResourceNameHelper helper, short cu, short ldev, String newElementName) throws WBEMException {
        String emptyString = "";
        SetResourceNameHelper temp = this.resourceNameHelper;
        if (null == temp) {
            CoalescedCreateModifyVolumeBase coalescedCreateModifyVolumeBase = this;
            synchronized (coalescedCreateModifyVolumeBase) {
                temp = this.resourceNameHelper;
                if (null == temp) {
                    temp = this.resourceNameHelper = helper;
                }
            }
        }
        String elementName = newElementName;
        String dnNum = Long.toString(BaseDeviceNumber.makeUniqueDN((short)0, cu, ldev));
        if (null == elementName) {
            try {
                LDevNickname volLabel = LDevNickname.find(helper.getRMIObject(), dnNum);
                elementName = volLabel != null ? volLabel.getNickname() : "";
            }
            catch (WBEMException e) {
                elementName = "";
                mLogger.log(Level.SEVERE, "Error getting Label for volume " + dnNum + ", using default", e);
            }
        }
        ElementNameData ld = new ElementNameData(dnNum, this.getDeviceSerialNumber(), SetResourceNameHelper.ResourceType.LDEV, elementName);
        Robj_interface_RJiResourceName resourceName = helper.getResourceNameRMIobject(ld);
        return resourceName;
    }
}

