/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.ReplicationServiceInstrumentation;
import com.hitachi.smi.instrumentation.StorageVolumeInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedCreateElementReplica;
import com.hitachi.smi.jobs.ElementNameData;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import com.hitachi.smi.jobs.HitachiJobCallbackIF2;
import com.hitachi.smi.jobs.SetResourceNameHelper;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;
import sanproject.common.Robj_interface_MRCFsetQSPairDetail;
import sanproject.common.Robj_interface_MRCFsetQSPairInfo_OUT;
import sanproject.common.Robj_interface_MRCFsetQSPairMain;
import sanproject.common.Robj_interface_RJiLDEVIndex;

public class CreateElementReplica
extends AbstractJobImpl
implements HitachiJobCallbackIF2,
CacheUpdateNotifier {
    private static final String METHOD_NAME = "CreateElementReplica";
    private boolean jobDone;
    private boolean registeredCallback = false;
    private final ProviderHandle handle;
    private final TypeOfReplica typeOfReplica;
    private long sVolDN;
    private final ReplicationServiceInstrumentation.CreateElementReplicaParams params;

    public CreateElementReplica(String pUserName, String pIPAddress, CIMObjectPath owningService, ReplicationServiceInstrumentation.CreateElementReplicaParams pParams, ProviderHandle pHandle) throws WBEMException {
        super(pParams.getDnSourceElement().getSerialNumber(), METHOD_NAME, pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementStorageVolume", "HITACHI_ReplicationCSOwningJobElement", null);
        this.handle = pHandle;
        this.params = pParams;
        this.jobDone = false;
        CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.SNAPSHOT, this, null);
        this.registeredCallback = true;
        this.setCallback(this);
        this.setActionItem(pParams.getDnSourceElement());
        this.sVolDN = -1L;
        this.typeOfReplica = 8 == this.params.getSyncType() ? TypeOfReplica.FastClone : (null != this.params.getTargetPool() ? TypeOfReplica.Snap2Snap : TypeOfReplica.Snapshot);
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        block5: {
            SnapshotInfo2 updatedSI = (SnapshotInfo2)pObj;
            mLogger.log(Level.FINE, "Job {0}: CreateElementReplica cache addition: {1}", new Object[]{this.getJobID(), pObj});
            if (updatedSI.getPVol().equals(this.getActionItem())) {
                CIMObjectPath opSyncedElement = null;
                try {
                    mLogger.log(Level.FINE, "Job {0}: CreateElementReplica Correct pVol", this.getJobID());
                    StorageVolumeInstrumentation svi = (StorageVolumeInstrumentation)BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation");
                    opSyncedElement = svi.generateObjectPath(this.getOwningElement(), updatedSI.getSVol());
                    CIMObjectPath[] affectedElems = super.getAffectedElements();
                    CIMObjectPath affected = null == affectedElems ? null : affectedElems[0];
                    mLogger.log(Level.FINE, "Job {0}: Check if updated cache objectpath, {1}, equals the affected element we want, {2}", new Object[]{this.getJobID(), opSyncedElement, affected});
                    if (opSyncedElement.equals((Object)affected)) {
                        mLogger.fine("Job " + this.getJobID() + ": Matched, job can be marked complete");
                        this.jobDone = true;
                        break block5;
                    }
                    mLogger.fine("Job " + this.getJobID() + ": No match, job can not be marked complete");
                }
                catch (WBEMException e) {
                    LogRecord record = new LogRecord(Level.WARNING, "Job {0}: Failed to create objectpath for sVol {1}");
                    record.setParameters(new Object[]{this.getJobID(), updatedSI.getSVolDNString()});
                    record.setThrown(e);
                    mLogger.log(record);
                }
            } else {
                mLogger.log(Level.FINE, "Job {0}: CreateElementReplica does match {1}", new Object[]{this.getJobID(), this.getActionItem()});
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
    }

    @Override
    public CIMObjectPath[] getAffectedElements() {
        CIMObjectPath[] ret = null;
        if (this.jobDone) {
            ret = super.getAffectedElements();
        }
        return ret;
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedCreateElementReplica(this.getDeviceSerial());
    }

    protected String getElementName() {
        return this.params.getElementName();
    }

    public ProviderHandle getHandle() {
        return this.handle;
    }

    @Override
    public String getMethodName() {
        return super.getMethodName() + "(" + (Object)((Object)this.typeOfReplica) + ")";
    }

    public TypeOfReplica getReplicaType() {
        return this.typeOfReplica;
    }

    public CIMObjectPath getTargetGoal() {
        return this.params.getTargetSettingGoal();
    }

    public ThinPool getTargetPool() {
        return this.params.getTargetThinPool();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted(10);
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processJobComplete();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    @Override
    public boolean jobStepCompleted(HitachiJobCallbackIF2.StepCompleted step) {
        boolean ret = true;
        switch (step) {
            case AFTER_STEP_1: {
                ret = this.processStep1();
                break;
            }
            default: {
                mLogger.log(Level.WARNING, "Job {0}: Called step completed {1}, however; that step is not implemented", new Object[]{this.getJobID(), step});
            }
        }
        return ret;
    }

    private void processJobComplete() {
        WBEMException we = null;
        DeviceNumber dn = (DeviceNumber)this.getActionItem();
        try {
            if (-1L != this.sVolDN) {
                ElementNameData element = new ElementNameData(Long.toString(this.sVolDN), dn.getSerialNumber(), SetResourceNameHelper.ResourceType.LDEV, this.getElementName());
                element.processResult(this, this.getResultIndex());
            } else {
                we = new WBEMException(1, "Error checking element name, unable to determine sVol for pVol: " + this.getActionItem(), null, null);
            }
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            we = new WBEMException(1, "Error checking element name", null, t);
        }
        if (null != we) {
            t = we;
            while (null != t.getCause()) {
                t = t.getCause();
            }
            mLogger.log(Level.WARNING, "Job " + this.getJobID() + ": Unable to name LDEV: " + dn, t);
            we = null;
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processStep1() {
        boolean ret;
        WBEMException we;
        block18: {
            we = null;
            try {
                Object t = this.getRMIResult();
                Robj_interface_MRCFsetQSPairInfo_OUT jobRet = (Robj_interface_MRCFsetQSPairInfo_OUT)t;
                Robj_interface_MRCFsetQSPairMain data = jobRet.getQSPairMain();
                long result = data.getIResult();
                if (result != 0L) {
                    this.setAffectedElements(null);
                    String msg = "Job " + this.getJobID() + ": Error from job 7005 - " + result;
                    mLogger.log(Level.SEVERE, msg);
                    we = new WBEMException(msg);
                    break block18;
                }
                long current = System.currentTimeMillis();
                long end = current + 300000L;
                while (!this.jobDone && end > current) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        mLogger.log(Level.WARNING, "Job " + this.getJobID() + ": While waiting for cache " + "update an InterruptedException occurred " + "(non-fatal)", ie);
                    }
                    current = System.currentTimeMillis();
                }
                if (!this.jobDone) {
                    we = new WBEMException("Job " + this.getJobID() + ": completed successfully, however; we could " + "not detect any changes to the back end");
                } else {
                    Robj_interface_MRCFsetQSPairDetail[] details = data.getQSPairDetail();
                    Robj_interface_MRCFsetQSPairDetail detail = details[this.getResultIndex()];
                    Robj_interface_RJiLDEVIndex sVol = detail.getRobjSVolIndex();
                    this.sVolDN = BaseDeviceNumber.makeUniqueDN(sVol.getSLDKC(), sVol.getSCU(), sVol.getSLDEV());
                }
            }
            catch (WBEMException e) {
                we = e;
            }
            catch (ClassCastException cce) {
                we = new WBEMException(1, "Job " + this.getJobID() + ": " + cce, null, (Throwable)cce);
            }
            catch (Throwable t) {
                we = new WBEMException(1, "Job " + this.getJobID() + ": " + t, null, t);
            }
            finally {
                if (this.registeredCallback) {
                    CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.SNAPSHOT, this, null);
                }
            }
        }
        if (null != we) {
            this.getHitachiJobServiceObject().markServerJobDone(we);
            this.getHitachiJobServiceObject().markServerjobComplete();
            ret = false;
        } else {
            ret = true;
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateElementReplica [jobDone=");
        builder.append(this.jobDone);
        builder.append(", params=");
        builder.append(this.params);
        builder.append("]");
        return builder.toString();
    }

    static enum TypeOfReplica {
        Snapshot,
        Snap2Snap,
        FastClone;

    }
}

