/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedCreateModifyThinVolume;
import com.hitachi.smi.jobs.CreateModifyVolumeBase;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import com.hitachi.smi.jobs.HitachiJobCallbackIF2;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_AOUAddVvol;
import sanproject.common.Robj_interface_AOUsetAddVvol_OUT;

public class CreateModifyThinVolume
extends CreateModifyVolumeBase
implements HitachiJobCallbackIF2 {
    private final List<CreateThinVolumeData> vols;

    public CreateModifyThinVolume(String pUserName, String pIPAddress, CIMObjectPath owningService, ThinPool tp, long size, int emulationType, String elementName) throws WBEMException {
        this(pUserName, pIPAddress, owningService, tp, size, emulationType, new String[]{elementName});
    }

    public CreateModifyThinVolume(String pUserName, String pIPAddress, CIMObjectPath owningService, ThinPool tp, long size, int emulationType, String[] elementName) throws WBEMException {
        super(tp.getSerialNumber(), "CreateOrModifyElementFromStoragePool", pUserName, pIPAddress, owningService, new String[]{"HITACHI_AffectedJobElementStorageVolume", "HITACHI_AffectedJobElementThinProvisioningPool"}, "HITACHI_StorageCSOwningJobElement", null);
        if (tp.isSnapShotPool()) {
            throw new WBEMException("The passed in ThinPool (" + tp.getPoolID() + ") object is a SnapShot, it can not be used");
        }
        this.setCallback(this);
        this.vols = new ArrayList<CreateThinVolumeData>(elementName.length);
        for (String element : elementName) {
            CreateThinVolumeData data = new CreateThinVolumeData(tp, size, emulationType, element);
            this.vols.add(data);
        }
        this.setActionItem(this.vols);
    }

    @Override
    protected List<CreateThinVolumeData> getActionItem() {
        return this.vols;
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedCreateModifyThinVolume();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted();
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processJobComplete();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    @Override
    public boolean jobStepCompleted(HitachiJobCallbackIF2.StepCompleted step) {
        boolean ret = true;
        switch (step) {
            case AFTER_STEP_1: {
                ret = this.processStep1();
                break;
            }
            default: {
                mLogger.log(Level.WARNING, "{0} called for {1}, however; that step is not implemented", new Object[]{this.getClass().getSimpleName(), step});
            }
        }
        return ret;
    }

    private void processJobComplete() {
        WBEMException we = null;
        try {
            ArrayList<CIMObjectPath> affectedElems = new ArrayList<CIMObjectPath>(this.vols.size() + 1);
            BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation");
            for (CreateThinVolumeData volData : this.vols) {
                if (affectedElems.isEmpty()) {
                    BaseInstrumentation poolInst = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningPoolInstrumentation");
                    CIMObjectPath pool = poolInst.generateObjectPath(this.getOwningElement(), volData.getThinPool());
                    affectedElems.add(pool);
                }
                DeviceNumber createdDN = this.verifyVolumeCreated(volData);
                affectedElems.add(bi.generateObjectPath(this.getOwningElement(), createdDN));
            }
            this.setAffectedElements(affectedElems.toArray(new CIMObjectPath[affectedElems.size()]));
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    private boolean processStep1() {
        WBEMException we = null;
        boolean ret = false;
        try {
            Object vols = this.getActionItem();
            Robj_interface_AOUsetAddVvol_OUT jobRet = (Robj_interface_AOUsetAddVvol_OUT)this.getRMIResult();
            Robj_interface_AOUAddVvol[] data = jobRet.getAllAddVvol();
            for (int x = 0; x < vols.size(); ++x) {
                CreateThinVolumeData volData = (CreateThinVolumeData)vols.get(x);
                Robj_interface_AOUAddVvol addPoolData = data[this.getResultIndex() + x];
                long result = addPoolData.getResult();
                if (result == 0L) {
                    long dn = BaseDeviceNumber.makeUniqueDN(addPoolData.getSLDKC(), addPoolData.getSCU(), addPoolData.getSLDEV());
                    volData.setCreatedDNStr(Long.toString(dn));
                    ret = true;
                    continue;
                }
                String msg = "Job, " + this.getJobID() + ", received error 3005 - " + result;
                mLogger.log(Level.SEVERE, msg);
                we = new WBEMException(msg);
            }
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (ClassCastException cce) {
            we = new WBEMException(1, cce.toString(), null, (Throwable)cce);
        }
        catch (Throwable t) {
            we = new WBEMException(1, t.toString(), null, t);
        }
        if (null != we) {
            this.getHitachiJobServiceObject().markServerJobDone(we);
            this.getHitachiJobServiceObject().markServerjobComplete();
            ret = false;
        } else {
            ret = true;
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateModifyThinVolume ");
        builder.append(this.getActionItem());
        return builder.toString();
    }

    class CreateThinVolumeData
    implements CreateModifyVolumeBase.CreateVolumeDataBase {
        private final ThinPool tp;
        private final long size;
        private final int emulationType;
        private final String elementName;
        private String createdDNStr;

        public CreateThinVolumeData(ThinPool tp, long size, int emulationType, String elementName) {
            this.tp = tp;
            this.emulationType = emulationType;
            this.size = size;
            this.elementName = elementName;
            this.createdDNStr = null;
        }

        @Override
        public String getCreatedDNStr() {
            return this.createdDNStr;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        protected int getEmulationType() {
            return this.emulationType;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        protected ThinPool getThinPool() {
            return this.tp;
        }

        protected void setCreatedDNStr(String createdDNStr) {
            this.createdDNStr = createdDNStr;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CreateThinVolumeData [tp=");
            builder.append(this.tp);
            builder.append(", size=");
            builder.append(this.size);
            builder.append(", emulationType=");
            builder.append(this.emulationType);
            builder.append(", elementName=");
            builder.append(this.elementName);
            builder.append("]");
            return builder.toString();
        }
    }
}

