/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs.workers;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public abstract class KeyValueAPIBaseObject {
    protected static final Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private final String clientIP;
    private final SanData generalParameter;
    private final SanRequest request;
    private final RMIObjectCache rmiObj;
    private final SanRemote sanRemote;

    public KeyValueAPIBaseObject(RMIObjectCache rmi, String clientIP, String keyValueAPI2Call) throws WBEMException {
        try {
            this.rmiObj = rmi;
            this.clientIP = clientIP;
            this.sanRemote = this.rmiObj.keyValueAPI_GetSanRemote();
            this.generalParameter = this.rmiObj.keyValueAPI_GetStorageInfoParam(this.sanRemote, clientIP);
            this.request = this.sanRemote.newRequest(this.generalParameter, "MNTdeleteLdevs");
        }
        catch (SanDataException | SanRmiException | NotBoundException | RemoteException e) {
            throw new WBEMException(1, "Error creating Key/Value objects: " + e, null, e);
        }
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public SanData getGeneralParameter() {
        return this.generalParameter;
    }

    public SanRequest getRequest() {
        return this.request;
    }

    public RMIObjectCache getRmiObject() {
        return this.rmiObj;
    }

    public SanRemote getSanRemote() {
        return this.sanRemote;
    }
}

