/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.lock;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileInterface;

public class SJcAccountLock {
    private static final String LOG_FUNCTION = "SJcAccountLock";
    private static final String LOG_TITLE = "SJcAccountLock";

    private SJcAccountLock() {
    }

    public static boolean CountUp(String szName) {
        String LOG_SUBTITLE = "CountUp";
        boolean bRet = false;
        try {
            String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNT;
            String szFile = "LockoutUserInfo";
            String path = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNT + SJcFileInterface.separator + "AccountLock.properties";
            Properties localProps = SJcFileUty.loadProperties("", path);
            int iLockCount = Integer.parseInt(localProps.getProperty("SN_ACCOUNT_LOC_CNT", "3"));
            HashMap<String, String[]> mpData = null;
            try {
                mpData = (HashMap<String, String[]>)SJcFileUty.loadFile2Class(szDirectory, szFile);
            }
            catch (Exception e) {
                SJcLogUty.getLogger().info("SJcAccountLock", "SJcAccountLock", "CountUp", "Exception.", e);
                mpData = new HashMap<String, String[]>();
            }
            String[] szData = (String[])mpData.get(szName);
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
            String szNow = sdf1.format(new Date());
            if (szData == null) {
                String[] szNewData = new String[]{"1", szNow};
                int iLockMax = SJcEnvUty.getProperty2int("SN_ACCOUNT_LOCK_MAX", 1024);
                if (mpData.size() >= iLockMax) {
                    String szOldName = SJcAccountLock.getOldName(mpData);
                    mpData.remove(szOldName);
                }
                mpData.put(szName, szNewData);
                if (iLockCount == 1) {
                    bRet = true;
                }
            } else {
                int iCnt = Integer.valueOf(szData[0]);
                if (iLockCount >= 0) {
                    ++iCnt;
                }
                if (iCnt >= iLockCount) {
                    bRet = true;
                    mpData.remove(szName);
                } else {
                    szData[0] = String.valueOf(iCnt);
                    szData[1] = szNow;
                    mpData.put(szName, szData);
                }
            }
            SJcFileUty.saveClass2File(szDirectory, szFile, mpData);
            return bRet;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcAccountLock", "SJcAccountLock", "CountUp", "Exception.", e);
            return false;
        }
    }

    private static String getOldName(HashMap<String, String[]> mpData) {
        String szRet = "";
        String szOldTime = "";
        Iterator<Map.Entry<String, String[]>> it = mpData.entrySet().iterator();
        Map.Entry<String, String[]> entry = it.next();
        String[] szData = entry.getValue();
        szRet = entry.getKey();
        szOldTime = szData[1];
        while (it.hasNext()) {
            entry = it.next();
            szData = entry.getValue();
            if (szData[1].compareTo(szOldTime) >= 0) continue;
            szRet = entry.getKey();
            szOldTime = szData[1];
        }
        return szRet;
    }

    public static void delete(String szName) {
        String LOG_SUBTITLE = "delete";
        try {
            String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNT;
            String szFile = "LockoutUserInfo";
            HashMap mpData = null;
            try {
                mpData = (HashMap)SJcFileUty.loadFile2Class(szDirectory, szFile);
            }
            catch (Exception e) {
                SJcLogUty.getLogger().info("SJcAccountLock", "SJcAccountLock", "delete", "Exception.", e);
                mpData = new HashMap();
            }
            mpData.remove(szName);
            SJcFileUty.saveClass2File(szDirectory, szFile, mpData);
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcAccountLock", "SJcAccountLock", "delete", "Exception.", e);
        }
    }

    public static void lock(String szName) {
        String LOG_SUBTITLE = "lock";
        try {
            int iLockSec = SJcEnvUty.getProperty2int("SN_ACCOUNT_LOCK_SEC", 60);
            if (iLockSec <= 0) {
                return;
            }
            if (szName.equals("")) {
                return;
            }
            String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            String systemPath = SJcFileUty.concatFolderPath(dataPath, SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNTLOCK);
            String filePath = SJcFileUty.concatFolderPath(systemPath, szName);
            File lockfile = new File(filePath);
            if (!lockfile.exists()) {
                lockfile.createNewFile();
            } else {
                SJcLogUty.getLogger().info("SJcAccountLock", "SJcAccountLock", "lock", "Exist LockFile.");
            }
            Thread.sleep(iLockSec * 1000);
            lockfile.delete();
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcAccountLock", "SJcAccountLock", "lock", "Exception.", e);
        }
    }

    public static boolean isLock(String szName) {
        String LOG_SUBTITLE = "isLock";
        boolean bRet = false;
        try {
            int iLockSec = SJcEnvUty.getProperty2int("SN_ACCOUNT_LOCK_SEC", 60);
            if (szName.equals("")) {
                return false;
            }
            String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
            String systemPath = SJcFileUty.concatFolderPath(dataPath, SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNTLOCK);
            String filePath = SJcFileUty.concatFolderPath(systemPath, szName);
            File lockfile = new File(filePath);
            if (lockfile.exists()) {
                long deletetime;
                long filetime = lockfile.lastModified();
                if (filetime <= (deletetime = new Date().getTime() - (long)(iLockSec * 1000))) {
                    lockfile.delete();
                } else {
                    bRet = true;
                }
            }
            return bRet;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcAccountLock", "SJcAccountLock", "isLock", "Exception.", e);
            return false;
        }
    }
}

