/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfiguration;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public abstract class SJbaseConfigurationFactory {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseConfigurationFactory";
    public static final String SERVER_TYPE = "auth.server.type";
    public static final String SERVER_NAME = "auth.server.name";
    protected Properties properties = null;
    protected String serverType;

    public SJbaseConfigurationFactory() {
        String method = "constructor";
        logger.info(module, method, "", "start");
        try {
            String dataPath = System.getProperty("SN_DataPath");
            try {
                SJcFileUty.decryptFile("base\\setting\\extAuth\\", "ExtarnalAuth_Config.properties", "base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
            }
            catch (Exception ex) {
                logger.error(module, method, "ExtarnalAuth_Config.properties decrypt", "failed", ex);
                throw new SJbaseExCommunicationException();
            }
            String confFileName = SJcFileUty.setEndPathSeparator(dataPath) + SJcFileUty.setEndPathSeparator("data") + "base\\setting\\extAuth\\" + "ExtarnalAuth_Config_dec.properties";
            this.properties.load(new FileInputStream(confFileName));
            this.serverType = this.properties.getProperty(SERVER_TYPE);
        }
        catch (IOException e) {
            logger.info(module, method, "load a configuration file", "failed", e);
        }
        logger.info(module, method, "", "end");
    }

    public SJbaseConfigurationFactory(Properties properties) {
        this.properties = properties;
    }

    public abstract SJbaseConfiguration[] getConfigurations();
}

