/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldapgetgroup;

import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalConst;
import sanproject.sn2.base.authentication.module.external.common.SJbaseGroupConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseParamater;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseLdapGroupConfigurationFactory
extends SJbaseGroupConfigurationFactory
implements SJbaseExternalConst {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseLdapGroupConfigurationFactory";
    public static final String GROUP_BASE = "auth.group";
    public SJbaseParamater paramater;

    public SJbaseLdapGroupConfigurationFactory(SJbaseParamater paramater) {
        this.paramater = paramater;
        this.groupProperties = paramater.getProperties();
    }

    @Override
    public SJbaseLdapGroupConfiguration getGroupConfigurations() {
        SJbaseLdapGroupConfiguration config;
        String method = "getGroupConfigurations";
        logger.info(module, method, "", "start");
        if (this.groupProperties == null) {
            logger.info(module, method, "check the auth server configuration object ", "object does not exist");
            config = null;
        } else {
            String authServerType = this.paramater.getAuthServerType();
            if (authServerType.equalsIgnoreCase("ldap")) {
                logger.info(module, method, "check the anthentication server type", "authentication server type was LDAP");
                SJbaseLdapConfiguration ldapConf = this.paramater.getLdapConf();
                if (ldapConf == null) {
                    logger.info(module, method, "check the configuration file object ", "object does not exist");
                    config = null;
                } else {
                    config = new SJbaseLdapGroupConfiguration();
                    config.setProtocol(ldapConf.getProtocol());
                    config.setHost(ldapConf.getHost());
                    config.setPort(ldapConf.getPort());
                    config.setTimeout(ldapConf.getTimeout());
                    config.setRetryTimes(ldapConf.getRetryTimes());
                    config.setRetryInterval(ldapConf.getRetryInterval());
                    if (ldapConf.getSearchUserPassword() == null || ldapConf.getSearchUserPassword().length() == 0) {
                        config.setServerErrCode(10);
                    } else {
                        config.setSearchUserPassword(ldapConf.getSearchUserPassword());
                    }
                    if (ldapConf.getSearchUserDN() == null || ldapConf.getSearchUserDN().length() == 0) {
                        config.setServerErrCode(10);
                    } else {
                        config.setSearchUserDN(ldapConf.getSearchUserDN());
                    }
                    config.setSearchDN(ldapConf.getSearchDN());
                    config.setGrpMapping(ldapConf.getGrpMapping());
                    config.setUserAttr(ldapConf.getUserAttr());
                    logger.info(module, method, "finish constructing the group configuration object", ldapConf.getDomainName() + ":[" + 0 + "]");
                }
            } else if (authServerType.equalsIgnoreCase("radius")) {
                logger.info(module, method, "check the anthentication\tserver type", "authentication server type was RADIUS");
                SJbaseRadiusConfiguration radiusConf = this.paramater.getRadiusConf();
                if (radiusConf == null) {
                    logger.info(module, method, "check the auth server configuration object ", "object does not exist");
                    config = null;
                } else {
                    String domain_name = this.groupProperties.getProperty("auth.radius." + radiusConf.getSearverName() + "." + "domain.name");
                    String dnsLookup = this.groupProperties.getProperty("auth.radius." + radiusConf.getSearverName() + "." + "dns_lookup");
                    String host = this.groupProperties.getProperty("auth.group." + domain_name + "." + "host");
                    String port = this.groupProperties.getProperty("auth.group." + domain_name + "." + "port");
                    if (domain_name == null || domain_name.length() == 0) {
                        logger.info(module, method, "check the domain name", "invlaid");
                        config = null;
                    } else {
                        logger.info(module, method, "start to construct the configuration object", domain_name + ":[0]");
                        config = new SJbaseLdapGroupConfiguration();
                        if (host == null || host.length() == 0 || port == null || port.length() == 0) {
                            if (dnsLookup == null || dnsLookup.length() == 0) {
                                logger.info(module, method, "the value is invalid", "dns lookup");
                                config.setDnsLookup("false");
                            } else if (dnsLookup.equalsIgnoreCase("true") || dnsLookup.equalsIgnoreCase("false")) {
                                config.setDnsLookup(dnsLookup);
                            } else {
                                logger.info(module, method, "the value is invalid", "dns lookup");
                                config.setDnsLookup("false");
                            }
                        } else {
                            config.setDnsLookup("false");
                        }
                        config.setDomainName(domain_name);
                        this.setLdapProtocol(config, domain_name);
                        this.setHost(config, domain_name);
                        this.setPort(config, domain_name);
                        this.setTimeout(config, domain_name);
                        this.setRetryTimes(config, domain_name);
                        this.setRetryInterval(config, domain_name);
                        this.setSearchUserPassword(config, domain_name);
                        this.setSearchUserDN(config, domain_name);
                        this.setSearchDN(config, domain_name);
                        this.setGrpMapping(config, domain_name);
                        logger.info(module, method, "finish constructing the configuration object", domain_name + ":[" + 0 + "]");
                    }
                }
            } else if (authServerType.equalsIgnoreCase("kerberos")) {
                logger.info(module, method, "check the anthentication server type", "authentication server type was Kerberos");
                SJbaseKerberosConfiguration kerberosConf = this.paramater.getKerberosConf();
                if (kerberosConf == null) {
                    logger.info(module, method, "check the auth server configuration object ", "object does not exist");
                    config = null;
                } else {
                    config = new SJbaseLdapGroupConfiguration();
                    String realm_name = kerberosConf.getRealm_Name();
                    String dns_lookup = kerberosConf.getDns_Lookup_Kdc();
                    if (!(realm_name != null && realm_name.length() != 0 || dns_lookup != null && dns_lookup.length() != 0 && dns_lookup.equalsIgnoreCase("true"))) {
                        config = null;
                    } else {
                        if (realm_name == null) {
                            realm_name = "";
                            kerberosConf.setRealm("");
                        }
                        String host = null;
                        String kdc = kerberosConf.getKdc();
                        if (dns_lookup == null || dns_lookup.length() == 0 || !dns_lookup.equalsIgnoreCase("true") || kdc != null && !kdc.equals("")) {
                            int trimHost = kerberosConf.getKdc().indexOf(":");
                            host = trimHost > 0 ? kerberosConf.getKdc().substring(0, trimHost) : kerberosConf.getKdc();
                        }
                        config.setHost(host);
                        config.setDnsLookup("false");
                        this.setLdapProtocol(config, realm_name);
                        this.setPort(config, realm_name);
                        this.setTimeout(config, realm_name);
                        this.setRetryTimes(config, realm_name);
                        this.setRetryInterval(config, realm_name);
                        this.setSearchUserPassword(config, realm_name);
                        this.setSearchUserDN(config, realm_name);
                        this.setSearchDN(config, realm_name);
                        this.setGrpMapping(config, realm_name);
                    }
                    logger.info(module, method, "finish constructing the configuration object", realm_name + ":[" + 0 + "]");
                }
            } else {
                config = new SJbaseLdapGroupConfiguration();
            }
        }
        logger.info(module, method, "", "end");
        return config;
    }

    public void setLdapProtocol(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setLdapProtocol";
        logger.info(module, method, "", "start");
        String tmpProtocol = this.groupProperties.getProperty("auth.group." + domain_name + "." + "protocol");
        if (tmpProtocol == null || tmpProtocol.length() == 0) {
            logger.info(module, method, "the value is invalid", "protocol");
            conf.setProtocol("ldap");
        } else if (tmpProtocol.equalsIgnoreCase("ldap")) {
            conf.setProtocol("ldap");
        } else if (tmpProtocol.equalsIgnoreCase("ldaps") && conf.getDnsLookup().equalsIgnoreCase("false")) {
            conf.setProtocol("ldaps");
        } else if (tmpProtocol.equalsIgnoreCase("starttls")) {
            conf.setProtocol("starttls");
        } else {
            logger.info(module, method, "the value is invalid", "protocol");
            conf.setServerErrCode(10);
        }
        logger.info(module, method, "", "end");
    }

    public void setHost(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setHost";
        logger.info(module, method, "", "start");
        String tmpHost = this.groupProperties.getProperty("auth.group." + domain_name + "." + "host");
        if (tmpHost == null || tmpHost.length() == 0) {
            logger.info(module, method, "the value is not registered", "use authentication host");
            conf.setHost(this.paramater.getRadiusConf().getHost());
        } else {
            conf.setHost(tmpHost);
        }
        logger.info(module, method, "", "end");
    }

    public void setPort(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setPort";
        logger.info(module, method, "", "start");
        int tmpPort = 389;
        try {
            tmpPort = Integer.parseInt(this.groupProperties.getProperty("auth.group." + domain_name + "." + "port"));
            if (tmpPort < 1 || tmpPort > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "port number");
            tmpPort = 389;
        }
        conf.setPort(tmpPort);
        logger.info(module, method, "", "end");
    }

    public void setTimeout(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setTimeout";
        logger.info(module, method, "", "start");
        int tmpTimeout = 10;
        try {
            tmpTimeout = Integer.parseInt(this.groupProperties.getProperty("auth.group." + domain_name + "." + "timeout"));
            if (tmpTimeout < 1 || tmpTimeout > 120) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "timeout");
            tmpTimeout = 10;
        }
        conf.setTimeout(tmpTimeout);
        logger.info(module, method, "", "end");
    }

    public void setRetryTimes(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setRetryTimes";
        logger.info(module, method, "", "start");
        int tmpRetryTimes = 3;
        try {
            tmpRetryTimes = Integer.parseInt(this.groupProperties.getProperty("auth.group." + domain_name + "." + "retry.times"));
            if (tmpRetryTimes < 0 || tmpRetryTimes > 50) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "retry times");
            tmpRetryTimes = 3;
        }
        conf.setRetryTimes(tmpRetryTimes);
        logger.info(module, method, "", "end");
    }

    public void setRetryInterval(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setRetryInterval";
        logger.info(module, method, "", "start");
        int tmpRetryInterval = 1;
        try {
            tmpRetryInterval = Integer.parseInt(this.groupProperties.getProperty("auth.group." + domain_name + "." + "retry.interval"));
            if (tmpRetryInterval < 1 || tmpRetryInterval > 60) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            logger.info(module, method, "the value is invalid", "retry interval");
            tmpRetryInterval = 1;
        }
        conf.setRetryInterval(tmpRetryInterval);
        logger.info(module, method, "", "end");
    }

    public void setSearchUserPassword(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setSearchUserPassword";
        logger.info(module, method, "", "start");
        String tmpSearchPW = this.groupProperties.getProperty("auth.group." + domain_name + "." + "searchpw");
        if (tmpSearchPW == null || tmpSearchPW.length() == 0) {
            logger.info(module, method, "", "search user password is not registered");
            conf.setServerErrCode(10);
        } else {
            conf.setSearchUserPassword(tmpSearchPW);
        }
        logger.info(module, method, "", "end");
    }

    public void setSearchUserDN(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setSearchUserDN";
        logger.info(module, method, "", "start");
        String tmpSearchDN = this.groupProperties.getProperty("auth.group." + domain_name + "." + "searchdn");
        if (tmpSearchDN == null || tmpSearchDN.length() == 0) {
            logger.info(module, method, "", "search user is not registered");
            conf.setServerErrCode(10);
        } else {
            conf.setSearchUserDN(tmpSearchDN);
        }
        logger.info(module, method, "", "end");
    }

    public void setSearchDN(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setSearchDN";
        logger.info(module, method, "", "start");
        String tmpSearchBase = this.groupProperties.getProperty("auth.group." + domain_name + "." + "basedn");
        if (tmpSearchBase == null || tmpSearchBase.length() == 0) {
            logger.info(module, method, "the value is invalid", "base DN");
            conf.setSearchDN("abbr");
        } else {
            conf.setSearchDN(tmpSearchBase);
        }
        logger.info(module, method, "", "end");
    }

    public void setGrpMapping(SJbaseLdapGroupConfiguration conf, String domain_name) {
        String method = "setGrpMapping";
        logger.info(module, method, "", "start");
        String tmpGrpMapping = this.groupProperties.getProperty("auth.group.mapping");
        if (tmpGrpMapping == null || tmpGrpMapping.length() == 0) {
            logger.info(module, method, "the value is invalid", "GroupMapping");
            conf.setGrpMapping("false");
        } else {
            conf.setGrpMapping(tmpGrpMapping);
        }
        logger.info(module, method, "", "end");
    }
}

