/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.util.HashMap;
import java.util.UUID;
import sanproject.sn2.base.authentication.inf.SJbaseAuthenticationModulePluginInterface;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalLoginModule;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.account.SJcUserInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundUserException;

public class SJbaseAuthenticationExternal
implements SJbaseAuthenticationModulePluginInterface {
    private final String LOG_FUNCTION = "SJbaseAuthenticationExternal";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private static String szMsg;
    private String m_szUserName = null;
    private String m_SessionID = null;
    private String[] m_szGroupName = null;
    private SJbaseExternalAccountInfo m_clsAccountInfo = null;
    private String m_szPassword = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int authentication(String szUserName, String szPassword) {
        String LOG_SUBTITLE = "authentication";
        int iRet = 6;
        try {
            szMsg = "<" + szUserName + ">Start.";
            SJcLogUty.getLogger().info("SJbaseAuthenticationExternal", this.LOG_TITLE, "authentication", szMsg);
            String[] szAlyUser = new String[]{szUserName};
            SJcUserInfoContainer[] clsUserInfo = SJcUserInfoUty.getUserInfo(szAlyUser);
            if (clsUserInfo[0] == null) {
                throw new SJcNotFoundUserException();
            }
            if (clsUserInfo[0].getEnable()) {
                if (clsUserInfo[0].getAuthPtn() == SJcAccountConst.INT_AUTHPTN_EXTERNAL) {
                    try {
                        SJbaseExternalLoginModule clsExternal = new SJbaseExternalLoginModule();
                        this.m_clsAccountInfo = clsExternal.login(szUserName, szPassword);
                        iRet = 0;
                        this.m_szUserName = szUserName;
                        this.m_szPassword = szPassword;
                        String szUuid = UUID.randomUUID().toString().replaceAll("-", "");
                        String szSession = szUserName + szPassword + szUuid;
                        this.m_SessionID = SJcSecureUty.getHashValueStringHex(szSession).substring(0, 32);
                        this.m_szGroupName = clsUserInfo[0].getGrpName();
                    }
                    catch (SJbaseExAuthenticationException e) {
                        iRet = 1;
                    }
                    catch (SJbaseExCommunicationException e) {
                        iRet = 4;
                    }
                } else {
                    iRet = 7;
                }
            } else {
                iRet = 2;
            }
        }
        catch (SJcNotFoundUserException e) {
            iRet = 6;
            szMsg = "<" + szUserName + ">NotFound UserData.";
            SJcLogUty.getLogger().error("SJbaseAuthenticationExternal", this.LOG_TITLE, "authentication", szMsg);
        }
        catch (Exception e) {
            iRet = 11;
            szMsg = "<" + szUserName + ">";
            SJcLogUty.getLogger().error("SJbaseAuthenticationExternal", this.LOG_TITLE, "authentication", szMsg, e);
        }
        finally {
            szMsg = "<" + szUserName + ">End. - status:" + iRet;
            SJcLogUty.getLogger().info("SJbaseAuthenticationExternal", this.LOG_TITLE, "authentication", szMsg);
        }
        return iRet;
    }

    @Override
    public String getUserName() {
        return this.m_szUserName;
    }

    @Override
    public String[] getGroupID() {
        return this.m_szGroupName;
    }

    @Override
    public String getSessionID() {
        return this.m_SessionID;
    }

    @Override
    public String getAuthSystemName(String szSystem) {
        return szSystem;
    }

    @Override
    public HashMap getAuthObject() {
        return null;
    }

    @Override
    public String[] getRoleID() {
        return null;
    }

    @Override
    public boolean[] getResourceGrpMap() {
        return null;
    }

    @Override
    public boolean isAllRSG() {
        return false;
    }

    @Override
    public boolean[] getRoleMap() {
        return null;
    }

    @Override
    public String getPassword() {
        return this.m_szPassword;
    }
}

