/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import sanproject.sn2.base.property.SJbaseSystemPropertiesConst;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcUserUniqIDUty {
    private static final String LOG_FUNCTION = "SJcUserUniqIDUty";
    private static final String LOG_TITLE = "SJcUserUniqIDUty";

    private SJcUserUniqIDUty() {
    }

    public static String getUserUniqID(String szUserName, String szAuthName) {
        String LOG_SUBTITLE = "getUserUniqID";
        try {
            String szRet = null;
            String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNT;
            String szFile = "UserUniqIDList";
            String szKey = szUserName + "_" + szAuthName;
            HashMap<String, String[]> mpData = null;
            try {
                mpData = (HashMap<String, String[]>)SJcFileUty.loadFile2Class(szDirectory, szFile);
            }
            catch (Exception e) {
                SJcLogUty.getLogger().info("SJcUserUniqIDUty", "SJcUserUniqIDUty", "getUserUniqID", "Exception.", e);
                mpData = new HashMap<String, String[]>();
            }
            String[] szData = (String[])mpData.get(szKey);
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
            String szNow = sdf1.format(new Date());
            if (szData == null) {
                String[] szNewData = new String[]{UUID.randomUUID().toString(), szNow};
                int iMax = SJcEnvUty.getProperty2int("SN_Base_LimitSessionNum", 32) * 2;
                if (mpData.size() >= iMax) {
                    String szOldName = SJcUserUniqIDUty.getOldName(mpData);
                    mpData.remove(szOldName);
                }
                mpData.put(szKey, szNewData);
                szRet = szNewData[0];
            } else {
                szData[1] = szNow;
                mpData.put(szKey, szData);
                szRet = szData[0];
            }
            SJcFileUty.saveClass2File(szDirectory, szFile, mpData);
            return szRet;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserUniqIDUty", "SJcUserUniqIDUty", "getUserUniqID", "Exception.", e);
            return null;
        }
    }

    private static String getOldName(HashMap<String, String[]> mpData) {
        String szRet = "";
        String szOldTime = "";
        Iterator<Map.Entry<String, String[]>> it = mpData.entrySet().iterator();
        Map.Entry<String, String[]> entry = it.next();
        String[] szData = entry.getValue();
        szRet = entry.getKey();
        szOldTime = szData[1];
        while (it.hasNext()) {
            entry = it.next();
            szData = entry.getValue();
            if (szData[1].compareTo(szOldTime) >= 0) continue;
            szRet = entry.getKey();
            szOldTime = szData[1];
        }
        return szRet;
    }

    public static String[] getUserUniqIDList() {
        String LOG_SUBTITLE = "getUserUniqIDList";
        try {
            String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNT;
            String szFile = "UserUniqIDList";
            HashMap mpData = null;
            try {
                mpData = (HashMap)SJcFileUty.loadFile2Class(szDirectory, szFile);
            }
            catch (Exception e) {
                SJcLogUty.getLogger().info("SJcUserUniqIDUty", "SJcUserUniqIDUty", "getUserUniqIDList", "Exception.", e);
                mpData = new HashMap();
            }
            ArrayList<String> alRet = new ArrayList<String>();
            for (Map.Entry entry : mpData.entrySet()) {
                String[] data = (String[])entry.getValue();
                alRet.add(data[0]);
            }
            if (alRet.isEmpty()) {
                SJcLogUty.getLogger().warn("SJcUserUniqIDUty", "SJcUserUniqIDUty", "getUserUniqIDList", "NotFound Data.");
                return null;
            }
            return alRet.toArray(new String[0]);
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserUniqIDUty", "SJcUserUniqIDUty", "getUserUniqIDList", "Exception.", e);
            return null;
        }
    }

    public static void deleteUserUniqID(String[] szUserName, String szAuthName) {
        String LOG_SUBTITLE = "getUserUniqIDList";
        try {
            String szDirectory = SJbaseSystemPropertiesConst.SN_DIRECTORY_BASE_ACCOUNT;
            String szFile = "UserUniqIDList";
            HashMap mpData = (HashMap)SJcFileUty.loadFile2Class(szDirectory, szFile);
            for (int i = 0; i < szUserName.length; ++i) {
                String szKey = szUserName[i] + "_" + szAuthName;
                mpData.remove(szKey);
            }
            SJcFileUty.saveClass2File(szDirectory, szFile, mpData);
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserUniqIDUty", "SJcUserUniqIDUty", "getUserUniqIDList", "Exception.", e);
        }
    }
}

