/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import com.hitachi.sanproject.rmi.SanRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrProgress;
import sanproject.sn2.controller.com.SJctrProgressUtility;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoModelMgr;

public abstract class SJctrApplyController
implements SJctrProgress,
Serializable {
    private static final int SLEEP_TIME = 100;
    public static final int MAX_OBJECT_RMI_NUM = 20000;
    private static final int PROGRESS_100 = 100;
    private boolean abortFlg = false;
    protected boolean async = false;
    private SJctrError error;
    private int progress = 0;
    private int position;
    private transient SJctrTask task;
    protected String title = this.getClass().getSimpleName();
    private SJctrProgressUtility progressUtil;
    private transient boolean pauseMonitor = false;

    public SJctrApplyController() {
        this.error = new SJctrError(201, 22, -1);
    }

    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        ArrayList<Object> resultObject = null;
        try {
            int maxSend;
            ArrayList<?> setList = this.getSetList();
            ArrayList<Object> runOptList = this.getRunOptionList();
            if (runOptList == null) {
                int listSize = setList.size();
                runOptList = new ArrayList(listSize);
                for (int size = 0; size < listSize; ++size) {
                    runOptList.add(null);
                }
            }
            if ((maxSend = this.getMaxSend()) < 1 || 20000 < maxSend) {
                maxSend = 20000;
            }
            if (setList.size() <= maxSend) {
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!!");
                resultObject = supplier.applyStartEx(this.task.getLockId(), setList, runOptList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!!");
            } else {
                int nextEndCnt = 0;
                ArrayList<Object> resultArray = new ArrayList<Object>();
                int setEndCnt = 0;
                while (setEndCnt < setList.size()) {
                    nextEndCnt = setEndCnt + maxSend;
                    if (nextEndCnt > setList.size()) {
                        nextEndCnt = setList.size();
                    }
                    List<?> pickList = setList.subList(setEndCnt, nextEndCnt);
                    ArrayList subSetList = new ArrayList(pickList.size());
                    subSetList.addAll(pickList);
                    List<?> optList = setList.subList(setEndCnt, nextEndCnt);
                    ArrayList subOptList = new ArrayList(pickList.size());
                    subOptList.addAll(pickList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply Start!! This Send Cnt = " + subSetList.size() + ", Finished Cnt = " + setEndCnt);
                    Object resultSubObject = supplier.applyStartEx(this.task.getLockId(), subSetList, subOptList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply End!! Finished Cnt = " + nextEndCnt);
                    resultArray.add(resultSubObject);
                    setEndCnt = nextEndCnt;
                }
                resultObject = resultArray;
            }
            this.setApplyResult(resultObject);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Deprecated
    protected boolean isApplyEnd() {
        return true;
    }

    protected void setApplyResult(Object resultObject) {
        this.setError(this.error.getFunc(), this.error.getModule(), 0);
        if (!this.isAsync()) {
            this.setProgress(100);
        }
    }

    protected List<SJctrError> getResultData() {
        return null;
    }

    protected List<List<SJctrError>> getResultDataEx() {
        ArrayList<List<SJctrError>> ret = new ArrayList<List<SJctrError>>(1);
        List<SJctrError> result = this.getResultData();
        ret.add(result);
        return ret;
    }

    public boolean hasApplyResult() {
        boolean applyResultFlg = false;
        return applyResultFlg;
    }

    public SJctrError getError() {
        return this.error;
    }

    protected void setError(SJctrError err) {
        this.error = err;
    }

    protected void setError(int erf, int erp, int erc) {
        SJctrError err;
        this.error = err = new SJctrError(erf, erp, erc);
    }

    public boolean isAbort() {
        return this.abortFlg;
    }

    void abortStart(SJdsSupplierAgent supplier) {
        if (this.isAbortable()) {
            ArrayList<?> abortList = this.getAbortList();
            ArrayList<Object> abortOptList = this.getAbortRunOptionList();
            if (abortOptList == null) {
                int listSize = abortList.size();
                abortOptList = new ArrayList(listSize);
                for (int size = 0; size < listSize; ++size) {
                    abortOptList.add(null);
                }
            }
            supplier.applyStartEx(this.task.getLockId(), abortList, abortOptList);
        }
        this.abortFlg = true;
    }

    protected ArrayList<?> getAbortList() {
        return new ArrayList();
    }

    public boolean isAbortable() {
        return false;
    }

    public abstract ArrayList<?> getSetList();

    protected int getMaxSend() {
        return 20000;
    }

    public void initApply() {
        int leatTime = this.getLeadTime();
        this.progressUtil = new SJctrProgressUtility(leatTime);
    }

    @Override
    public int getProgress() {
        if (this.progressUtil != null) {
            this.progress = this.progressUtil.getProgress();
        }
        return this.progress;
    }

    protected void setProgress(int value) {
        if (this.progressUtil != null) {
            this.progressUtil.setProgress(true, value);
        }
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isRequestOnly() {
        return false;
    }

    public boolean isShrink() {
        return false;
    }

    public boolean isDelDRD() {
        return false;
    }

    protected boolean isNeedMonitorBackground() {
        boolean ret = false;
        SJctrError error = this.getError();
        if (error.getError() == 0) {
            ret = true;
        }
        return ret;
    }

    public SJctrError monitorBackground() {
        return new SJctrError(201, 22, 0);
    }

    @Deprecated
    public void stopMonitor() {
    }

    void pauseMonitor() {
        this.pauseMonitor = true;
    }

    public boolean isPauseMonitor() {
        return this.pauseMonitor;
    }

    protected SJmoModelMgr getModelMgr() {
        return SJmoModelMgr.getModelMgr();
    }

    protected Object getResultObjectInTask() throws SJcException {
        if (this.task == null) {
            SJctrLogUty.info(this.title, "getResultObjectInTask", "Logical Error has occured. input task is null!!");
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        return this.task.getApplyResult(this.position);
    }

    protected void setResultObjectInTask(Object resultObject) throws SJcException {
        if (this.task == null) {
            SJctrLogUty.info(this.title, "setResultObjectInTask", "Logical Error has occured. input task is null!!");
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        this.task.setApplyResult(this.position, resultObject);
    }

    protected void changeDispApplyResult(boolean applyResultFlg) throws SJcException {
        if (this.task == null) {
            SJctrLogUty.info(this.title, "changeDispApplyResult", "Logical Error has occured. input task is null!!");
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        this.task.setApplyResultFlgList(this.position, applyResultFlg);
    }

    protected String getTaskName() throws SJcException {
        if (this.task == null) {
            SJctrLogUty.error(this.title, "getTaskName", "Logical Error has occured. input task is null!!");
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        return this.task.getName();
    }

    void setPosition(int inpPos) {
        this.position = inpPos;
    }

    void setTask(SJctrTask inpTask) {
        this.task = inpTask;
    }

    protected long getSubmitTime() throws SJcException {
        if (this.task == null) {
            SJctrLogUty.error(this.title, "getSubmitTime", "Logical Error has occured. input task is null!!");
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        return this.task.getSubmitTime();
    }

    protected String getUserName() throws SJcException {
        if (this.task == null) {
            SJctrLogUty.error(this.title, "getUserName", "Logical Error has occured. input task is null!!");
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        return this.task.getUserId();
    }

    protected String getTaskType() throws SJcException {
        if (this.task == null) {
            SJctrLogUty.error(this.title, "getTaskType", "Logical Error has occured. input task is null!!");
            SJctrError err = new SJctrError(201, 22, 106004);
            SJcException exp = err.createException();
            throw exp;
        }
        return this.task.getType();
    }

    protected SanRequest newRequest(String funcid) {
        SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
        return agent.newRequest(funcid);
    }

    protected long getLockId() {
        return this.task.getLockId();
    }

    public ArrayList<?> getRunOptionList() {
        return null;
    }

    public ArrayList<?> getAbortRunOptionList() {
        return null;
    }
}

