/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.model.SJmoDataChange;

public class SJctrCapacityUtility
extends SJctrStringUtility {
    private static final String HALF_SPACE = " ";
    private static final Format BYTE_CHANGE_FORMAT = new DecimalFormat("0.00");
    private static final Format CYL_CHANGE_FORMAT = new DecimalFormat("0");
    private static final Map<String, Long> baseCylMap = Collections.synchronizedMap(new HashMap());

    public SJctrCapacityUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public long valueOf(long value, UNIT unit) {
        long result;
        if (unit == null) {
            return value;
        }
        switch (unit) {
            case KB: 
            case MB: 
            case GB: 
            case TB: {
                result = value * unit.getBase();
                break;
            }
            default: {
                result = value;
            }
        }
        return result;
    }

    public long valueOf(long value, String emuName) {
        long base = this.getBaseCyl(emuName);
        long result = value * base;
        return result;
    }

    public long valueOf(long value, int emuType) {
        String emuName = this.dataChange.getEmulationTypeName(emuType);
        return this.valueOf(value, emuName);
    }

    public long valueOf(long value, UNIT unit, int emuType) {
        long result = UNIT.CYL == unit ? this.valueOf(value, emuType) : this.valueOf(value, unit);
        return result;
    }

    public String toString(long block, UNIT unit) {
        if (unit == null) {
            return String.valueOf(block);
        }
        String result = "";
        switch (unit) {
            case KB: 
            case MB: 
            case GB: 
            case TB: {
                BigDecimal bdBlock = new BigDecimal(block);
                BigDecimal bdBase = new BigDecimal(unit.getBase());
                BigDecimal bdResult = bdBlock.divide(bdBase, 2, RoundingMode.DOWN);
                result = BYTE_CHANGE_FORMAT.format(bdResult);
                break;
            }
            default: {
                result = String.valueOf(block);
            }
        }
        return result;
    }

    private BigDecimal toCyl(long block, String emuName) {
        BigDecimal bdBlock = new BigDecimal(block);
        long base = this.getBaseCyl(emuName);
        BigDecimal bdBase = new BigDecimal(base);
        BigDecimal bdResult = bdBlock.divide(bdBase, 0, RoundingMode.DOWN);
        return bdResult;
    }

    public String toCylString(long block, String emuName) {
        BigDecimal bdResult = this.toCyl(block, emuName);
        String result = CYL_CHANGE_FORMAT.format(bdResult);
        return result;
    }

    public String toCylString(long block, int emuType) {
        String emuName = this.dataChange.getEmulationTypeName(emuType);
        return this.toCylString(block, emuName);
    }

    public long toCylValue(long block, String emuName) {
        BigDecimal bdResult = this.toCyl(block, emuName);
        return bdResult.longValue();
    }

    public long toCylValue(long block, int emuType) {
        String emuName = this.dataChange.getEmulationTypeName(emuType);
        return this.toCylValue(block, emuName);
    }

    public String toString(long block, UNIT unit, int emuType) {
        String result = UNIT.CYL == unit ? this.toCylString(block, emuType) : this.toString(block, unit);
        return result;
    }

    public String getUnitString(UNIT unit) {
        if (unit == null) {
            return "";
        }
        String result = this.guidanceHandle.getGuidance(unit.getPartsId());
        return result;
    }

    public UNIT getUnit(long block) {
        UNIT result = block < UNIT.GB.getBase() ? UNIT.MB : (block < UNIT.TB.getBase() ? UNIT.GB : UNIT.TB);
        return result;
    }

    public String toUnitString(long block) {
        UNIT unit = this.getUnit(block);
        String capString = this.toString(block, unit);
        String unitString = this.getUnitString(unit);
        return capString + HALF_SPACE + unitString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getBaseCyl(String emuName) {
        Map<String, Long> map = baseCylMap;
        synchronized (map) {
            Long base = baseCylMap.get(emuName);
            if (base == null) {
                int slotSize = this.dataChange.getEmuSlotSize(emuName);
                base = slotSize * 2 * 15;
                if (base <= 0L) {
                    base = 1L;
                }
                baseCylMap.put(emuName, base);
            }
            return base;
        }
    }

    public static enum UNIT {
        BLOCK(1L, "BLOCK2"),
        KB(2L, "KB"),
        MB(2048L, "MB"),
        GB(0x200000L, "GB"),
        TB(0x80000000L, "TB"),
        CYL(1L, "CYL"),
        PAGE(1L, "PAGE");

        private long base;
        private String partsId;

        private UNIT(long base, String partsId) {
            this.base = base;
            this.partsId = partsId;
        }

        private long getBase() {
            return this.base;
        }

        private String getPartsId() {
            return this.partsId;
        }
    }
}

