/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.common.Robj_interface_AuditUserInfo;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.inf.SJcSingletonInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.controller.com.SJctrBackgroundWorkerThread;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageExchanger;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrWorkerThread;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.modelrc.SJmoRscMgr;
import sanproject.sn2.sn2com.utility.SJsncTaskHashUty;

public class SJctrQueueController
implements SJcSingletonInterface {
    private static final String CLASS_NAME = SJctrQueueController.class.getSimpleName();
    static final int ERR_MAX_TASK = 105055;
    static final int ERR_QUEUE_STOP = 105056;
    static final int ERR_CHG_TASK_WAITING = 105054;
    static final int ERR_CHG_TASK_DELETED = 105059;
    static final int ERR_CHG_TASK_SUSPENDED = 105061;
    static final int ERR_CHG_TASK_RESUME = 105063;
    static final int ERR_CHG_TASK_ABORTING = 105065;
    static final int ERR_TASK_NO_ABORTING = 105066;
    static final int ERR_NOT_CHG_PROTECT_ENABLE = 105068;
    static final int ERR_NOT_CHG_PROTECT_DISABLE = 105069;
    private static SJctrQueueController mQueueCtr = null;
    public static final int ST_STOP = 0;
    public static final int ST_ACTIVE = 256;
    private int mStatus = 0;
    private static final int TASKID_SERIAL_MIN = 0;
    private static final int TASKID_SERIAL_MAX = 9999;
    private static final int TASKID_SERIAL_LEN = String.valueOf(9999).length();
    private int mTaskIdSerialNo;
    private static final SimpleDateFormat TASKID_FORMAT = new SimpleDateFormat("yyMMddHHmmss");
    private SJctrWorkerThread mWorker;
    private SJctrWorkerThread mBgWorker;
    private List<SJctrTask> mTaskQueue;
    private List<SJctrTask> mTaskRecord;
    private int mTaskQueueMax;
    private int mTaskRecordMax;
    private static final int DELETE_MODE_THREAD_NOSTART = 0;
    private static final int DELETE_MODE_THREAD_START = 1;
    private static final int SN_TASK_QUEUE_MAX = 128;
    private static final int SN_TASK_RECORD_MAX = 256;
    private List<String> mDeleteTaskList;
    private int mDeleteTaskIndex;
    private int mDeleteTaskMax;
    private static final int SN_DELETE_TASK_MAX = 1000;
    private static final String DIR_NAME_DELETE = SJcEnvUty.getProperty("SN_TASK_DELETE_PATH", "tasks");
    private static final String FILE_NAME_DELETE = "DeleteTaskListInfo.dat";
    private static final String KEY_DELETE_TASK_LIST = "KEY_DELETE_TASK_LIST";
    private static final String KEY_DELETE_TASK_INDEX = "KEY_DELETE_TASK_INDEX";
    private static final String ENPTY_STRING = "";
    private static final Comparator<SJctrTask> mTaskEndTimeComp = new Comparator<SJctrTask>(){

        @Override
        public int compare(SJctrTask o1, SJctrTask o2) {
            int ret = 0;
            if (o1.getApplyEndTime() < o2.getApplyEndTime()) {
                ret = -1;
            } else if (o1.getApplyEndTime() > o2.getApplyEndTime()) {
                ret = 1;
            }
            return ret;
        }
    };
    static final String DIR_NAME_QUEUE = SJcEnvUty.getProperty("SN_TASK_QUEUE_PATH", "tasks\\queue");
    static final String DIR_NAME_RECORD = SJcEnvUty.getProperty("SN_TASK_RECORD_PATH", "tasks\\record");
    static final String FILE_NAME_CONTROL = "_control.tsk";
    public static final String FILE_NAME_APPLY = "_apply.tsk";
    public static final String FILE_NAME_CONFIRM = "_confirm.tsk";
    public static final String FILE_NAME_RESULT = "_result.tsk";
    static final String DIR_NAME_DUMP = SJcEnvUty.getProperty("SN_TASK_DUMP_PATH", "tasks\\dump");
    private static final int SN_TASK_DUMP_MAX = 10;
    static final int DUMP_MAX = SJcEnvUty.getProperty2int("SN_TASK_DUMP_MAX", 10);
    private static final SimpleDateFormat DUMP_APPLY_TIME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private boolean applyLock = false;
    private static final int ERR_CODE_CONFLICT = 2000;
    private static int[] errorCodeRetrySetDkcLock = new int[]{2000};
    private static String TASK_EXT = ".tsk";
    private static String TASK_BACKUP_PREFIX = "_";
    private static String TASK_BACKUP_EXT = ".bak";
    private static String TASK_CONVERT_FILE = "tasks\\convert.enc";

    public static synchronized SJctrQueueController getInstance() {
        if (mQueueCtr == null) {
            SJctrLogUty.info(CLASS_NAME, "getInstance", "new");
            mQueueCtr = new SJctrQueueController();
        }
        return mQueueCtr;
    }

    public boolean isStop() {
        return this.getStatus() == 0;
    }

    public boolean isActive() {
        return this.getStatus() == 256;
    }

    public int getStatus() {
        return this.mStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String takeTaskId(Date submitTime) {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            ++this.mTaskIdSerialNo;
            if (this.mTaskIdSerialNo > 9999) {
                this.mTaskIdSerialNo = 0;
            }
            StringBuffer taskId = new StringBuffer();
            taskId.append(TASKID_FORMAT.format(submitTime));
            taskId.append("-");
            taskId.append(SJctrComUtility.toPaddingZeroString(this.mTaskIdSerialNo, TASKID_SERIAL_LEN));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return taskId.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUpWorkerThread() {
        SJctrWorkerThread sJctrWorkerThread;
        if (this.mWorker != null && this.mWorker.mWaitingWorkerThread) {
            sJctrWorkerThread = this.mWorker;
            synchronized (sJctrWorkerThread) {
                this.mWorker.notifyAll();
                this.mWorker.mWaitingWorkerThread = false;
            }
        }
        if (this.mBgWorker != null && this.mBgWorker.mWaitingWorkerThread) {
            sJctrWorkerThread = this.mBgWorker;
            synchronized (sJctrWorkerThread) {
                this.mBgWorker.notifyAll();
                this.mBgWorker.mWaitingWorkerThread = false;
            }
        }
    }

    private SJctrQueueController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            SJctrLogUty.info(CLASS_NAME, "constructor", "start");
            this.makeQueueDirectory();
            this.encryptTasks();
            this.mTaskQueueMax = SJcEnvUty.getProperty2int("SN_TASK_QUEUE_MAX", 128);
            this.mTaskRecordMax = SJcEnvUty.getProperty2int("SN_TASK_RECORD_MAX", 256);
            this.mDeleteTaskMax = SJcEnvUty.getProperty2int("SN_TASK_DELETE_MAX", 1000);
            this.mTaskIdSerialNo = -1;
            this.mTaskQueue = Collections.synchronizedList(new ArrayList(this.mTaskQueueMax));
            this.mTaskRecord = Collections.synchronizedList(new ArrayList(this.mTaskRecordMax));
            this.restoreQueueDirectory();
            this.restoreTaskRecord();
            this.restoreDeleteTaskList();
            this.mStatus = 256;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.mWorker = new SJctrWorkerThread(this);
            this.mWorker.start();
            this.mBgWorker = new SJctrBackgroundWorkerThread(this);
            this.mBgWorker.start();
            SJctrLogUty.info(CLASS_NAME, "constructor", "end");
            return;
        }
    }

    private void makeQueueDirectory() {
        String[] dirList;
        for (String dirName : dirList = new String[]{DIR_NAME_QUEUE, DIR_NAME_RECORD, DIR_NAME_DUMP}) {
            try {
                if (SJcFileUty.exists(dirName)) continue;
                boolean result = SJcFileUty.makeDirectory(dirName);
                SJctrLogUty.info(CLASS_NAME, "makeQueueDirectory", "createDir:" + dirName + ",result:" + result);
            }
            catch (Exception e) {
                SJctrLogUty.info(CLASS_NAME, "makeQueueDirectory", "createDir fail:" + dirName, e);
            }
        }
    }

    private void restoreQueueDirectory() {
        String directoryName = DIR_NAME_QUEUE;
        String[] fileNames = SJcFileUty.getFileList(directoryName);
        ArrayList<String> ctrFileNameList = new ArrayList<String>();
        for (String fileName : fileNames) {
            if (!SJctrQueueController.isControlFileName(fileName)) continue;
            ctrFileNameList.add(fileName);
        }
        for (String fileName : ctrFileNameList) {
            String taskId = SJctrQueueController.controlFileNameToTaskId(fileName);
            try {
                SJctrTask task = new SJctrTask();
                this.loadTaskControlData(taskId, task, directoryName);
                if (task.getStatus() == 258) {
                    this.loadTaskApplyData(task);
                    this.loadTaskConfirmData(task);
                    this.loadTaskResultData(task);
                    this.mTaskQueue.add(task);
                    SJctrLogUty.info(CLASS_NAME, "restoreQueueDirectory", "Monitor : " + fileName);
                    continue;
                }
                if (task.isExecute()) {
                    this.loadTaskApplyData(task);
                    if (task.isMonitorable()) {
                        this.loadTaskConfirmData(task);
                        this.loadTaskResultData(task);
                        this.mTaskQueue.add(task);
                        SJctrLogUty.info(CLASS_NAME, "restoreQueueDirectory", "Monitorable : " + fileName);
                        continue;
                    }
                    task.destroyResourceDiff();
                    this.toHistoryRemainQueue(task);
                    continue;
                }
                if (task.getStatus() == 1 || task.getStatus() == 2) {
                    SJctrError err = null;
                    if (!task.isRestartableTask()) {
                        err = new SJctrError(201, 22, 208001);
                    }
                    if (err == null && !this.restoreResourceDiff(task)) {
                        err = new SJctrError(201, 22, 207005);
                    }
                    if (err == null) {
                        task.changeStatus(2);
                        this.loadTaskApplyData(task);
                        this.loadTaskConfirmData(task);
                        this.mTaskQueue.add(task);
                    } else {
                        task.setError(err);
                        task.changeStatus(513);
                        task.destroyApplyData();
                        task.destroyResourceDiff();
                        this.toHistoryCotrolData(task);
                        this.toHistoryCofirmData(task);
                        this.toHistoryApplyResult(task);
                    }
                    SJctrLogUty.info(CLASS_NAME, "restoreQueueDirectory", "restore Task: " + taskId + " state = " + task.getStatus());
                    continue;
                }
                task.destroyResourceDiff();
                this.toHistoryRemainQueue(task);
            }
            catch (Exception e) {
                SJctrLogUty.warn(CLASS_NAME, "restoreQueueDirectory", "restore fail = " + taskId, e);
            }
        }
        String[] remainFileNames = SJcFileUty.getFileList(directoryName);
        if (remainFileNames.length > 0) {
            SJcFileUty.deleteFiles(directoryName, remainFileNames);
            SJctrLogUty.info(CLASS_NAME, "restoreQueueDirectory", "delete : " + fileNames.length);
        }
        for (SJctrTask task : this.mTaskQueue) {
            try {
                this.saveTaskControlData(task);
                this.saveTaskApplyData(task);
                this.saveTaskConfirmData(task);
                this.saveTaskResultData(task);
            }
            catch (Exception e) {
                SJctrLogUty.info(CLASS_NAME, "restoreQueueDirectory", "file write failed. " + task.mId, e);
            }
        }
    }

    private boolean restoreResourceDiff(SJctrTask task) {
        boolean ret = true;
        List<List<ArrayList<? extends SJmoModelData_Base>>> resourceList = task.getResourceDiff();
        if (resourceList != null && resourceList.size() > 0) {
            try {
                SJmoRscMgr rscMgr = SJmoRscMgr.getInstance();
                rscMgr.setDiffData(resourceList);
            }
            catch (Exception e) {
                SJctrLogUty.info(CLASS_NAME, "restoreResourceDiff", "setDiffData failed. " + task.mId, e);
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTaskRecord() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            SJctrTask delTask;
            String[] fileNames;
            ArrayList<SJctrTask> taskList = new ArrayList<SJctrTask>(this.mTaskRecordMax);
            for (String fileName : fileNames = SJcFileUty.getFileList(DIR_NAME_RECORD)) {
                SJctrTask task;
                block8: {
                    if (!SJctrQueueController.isControlFileName(fileName)) continue;
                    String taskId = SJctrQueueController.controlFileNameToTaskId(fileName);
                    try {
                        task = new SJctrTask();
                        this.loadTaskControlData(taskId, task, DIR_NAME_RECORD);
                        if (task.getStatus() == 515) {
                            SJctrLogUty.warn(CLASS_NAME, "restoreTaskRecord", "destroy DELETED Status File! : " + taskId);
                            this.deleteRecordFile(taskId);
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        SJctrLogUty.info(CLASS_NAME, "restoreTaskRecord", "restore fail = " + taskId, e);
                        this.deleteRecordFile(taskId);
                    }
                    continue;
                }
                taskList.add(task);
            }
            Collections.sort(taskList, mTaskEndTimeComp);
            while (taskList.size() > this.mTaskRecordMax && (delTask = SJctrQueueController.getDeleteTargetTask(taskList)) != null) {
                taskList.remove(delTask);
                this.deleteRecordFile(delTask.getId());
            }
            this.mTaskRecord.addAll(taskList);
            SJctrLogUty.trace(CLASS_NAME, "restoreTaskRecord", "TaskRecord count = " + this.mTaskRecord.size());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void deleteQueueFile(String taskId) {
        String directoryName = DIR_NAME_QUEUE;
        String applyFileName = SJctrQueueController.getApplyFileName(taskId);
        this.deleteFile(directoryName, applyFileName);
        String confirmFileName = SJctrQueueController.getConfirmFileName(taskId);
        this.deleteFile(directoryName, confirmFileName);
        String resultFileName = SJctrQueueController.getResultFileName(taskId);
        this.deleteFile(directoryName, resultFileName);
        String controlFileName = SJctrQueueController.getControlFileName(taskId);
        this.deleteFile(directoryName, controlFileName);
    }

    private void deleteRecordFile(String taskId) {
        String directoryName = DIR_NAME_RECORD;
        String controlFileName = SJctrQueueController.getControlFileName(taskId);
        this.deleteFile(directoryName, controlFileName);
        String confirmFileName = SJctrQueueController.getConfirmFileName(taskId);
        this.deleteFile(directoryName, confirmFileName);
        String resultFileName = SJctrQueueController.getResultFileName(taskId);
        this.deleteFile(directoryName, resultFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDeleteTaskList() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            List tempTaskList;
            int diffSize;
            Map map = Collections.EMPTY_MAP;
            try {
                map = (Map)((Object)SJcFileUty.loadFile2Class(DIR_NAME_DELETE, FILE_NAME_DELETE));
            }
            catch (Exception e) {
                SJctrLogUty.warn(CLASS_NAME, "restoreDeleteTaskList", "loadfile fail:" + e.getMessage());
            }
            List taskList = Collections.EMPTY_LIST;
            Object obj = map.get(KEY_DELETE_TASK_LIST);
            if (obj instanceof List) {
                taskList = (List)obj;
            }
            Integer index = 0;
            Object obj2 = map.get(KEY_DELETE_TASK_INDEX);
            if (obj2 instanceof Integer) {
                index = (Integer)obj2;
            }
            if (index > taskList.size()) {
                index = taskList.size();
            }
            if ((diffSize = (tempTaskList = this.getNormalizeRotateList(taskList, index)).size() - this.mDeleteTaskMax) > 0) {
                tempTaskList = tempTaskList.subList(diffSize, tempTaskList.size());
            }
            tempTaskList = new ArrayList(tempTaskList);
            this.mDeleteTaskList = Collections.synchronizedList(tempTaskList);
            this.mDeleteTaskIndex = this.mDeleteTaskList.size();
            if (this.mDeleteTaskIndex >= this.mDeleteTaskMax) {
                this.mDeleteTaskIndex = 0;
            }
            SJctrLogUty.info(CLASS_NAME, "restoreDeleteTaskList", "DeleteTaskIndex = " + this.mDeleteTaskIndex);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    List getNormalizeRotateList(List list, int index) {
        ArrayList ret = new ArrayList(list.size());
        List subList = list.subList(index, list.size());
        ret.addAll(subList);
        subList = list.subList(0, index);
        ret.addAll(subList);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            SJctrLogUty.info(CLASS_NAME, "finish", "start");
            this.mStatus = 0;
            SJctrLogUty.trace(CLASS_NAME, "finish", "TaskQueue count = " + this.mTaskQueue.size());
            for (SJctrTask task : this.mTaskQueue) {
                if (!task.isExecute()) continue;
                SJctrLogUty.info(CLASS_NAME, "finish", "stopTaskExec start.");
                task.stopTaskExec();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.wakeUpWorkerThread();
            boolean threadEnd = false;
            while (!threadEnd) {
                try {
                    this.mWorker.join();
                    threadEnd = true;
                }
                catch (InterruptedException e) {
                    SJctrLogUty.info(CLASS_NAME, "finish", "WorkerThreadEnd", e);
                }
            }
            threadEnd = false;
            while (!threadEnd) {
                try {
                    this.mBgWorker.join();
                    threadEnd = true;
                }
                catch (InterruptedException e) {
                    SJctrLogUty.info(CLASS_NAME, "finish", "BackgroundWorkerThreadEnd", e);
                }
            }
            this.mWorker = null;
            this.mBgWorker = null;
            this.mTaskRecord.clear();
            this.destroy();
            SJctrLogUty.info(CLASS_NAME, "finish", "end");
            return;
        }
    }

    @Override
    public boolean destroy() {
        mQueueCtr = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected SJctrTask takeTask(SJctrWorkerThread worker) {
        this.wakeUpWorkerThread();
        SJctrWorkerThread sJctrWorkerThread = worker;
        // MONITORENTER : sJctrWorkerThread
        SJctrTask ret = null;
        while (true) {
            Class<SJctrQueueController> clazz = SJctrQueueController.class;
            // MONITORENTER : sanproject.sn2.controller.com.SJctrQueueController.class
            SJctrLogUty.trace(CLASS_NAME, "takeTask", "TaskQueue count = " + this.mTaskQueue.size());
            ret = worker.getTask(this.mTaskQueue);
            if (ret != null && !this.makeSpaceHistoryTaskList()) {
                ret = null;
            }
            // MONITOREXIT : clazz
            if (!this.isActive()) {
                // MONITOREXIT : sJctrWorkerThread
                return null;
            }
            if (ret != null) {
                return ret;
            }
            SJctrLogUty.info(CLASS_NAME, "takeTask", "wait start");
            worker.mWaitingWorkerThread = true;
            try {
                worker.wait();
            }
            catch (InterruptedException e) {
                SJctrLogUty.info(CLASS_NAME, "takeTask", "catch interrupt");
            }
            SJctrLogUty.info(CLASS_NAME, "takeTask", "wait end");
        }
    }

    public static SJctrTask getDeleteTargetTask(List<SJctrTask> taskList) {
        if (taskList == null) {
            return null;
        }
        SJctrTask result = null;
        for (SJctrTask task : taskList) {
            if (task.isProtection()) continue;
            result = task;
            break;
        }
        return result;
    }

    protected void addTask(SJctrTask task) throws SJcException {
        try {
            this.setDkcLock(task);
        }
        catch (SJcException e) {
            SJctrLogUty.warn(CLASS_NAME, "addTask", "setDkcLock Fail. lockId=" + task.getLockId());
            this.setDkcLock(task);
        }
        try {
            this.addTaskMainRoutine(task);
        }
        catch (SJcException e) {
            this.releaseDkcLock(task);
            throw e;
        }
    }

    protected void addTaskForRegularBackup(SJctrTask task) throws SJcException {
        this.addTaskMainRoutine(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaskMainRoutine(SJctrTask task) throws SJcException {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (!this.isActive()) {
                SJctrLogUty.warn(CLASS_NAME, "addTask", "QueueStatus = " + this.getStatus());
                SJctrError err = new SJctrError(201, 22, 105056);
                SJcException exp = err.createException();
                throw exp;
            }
            if (this.mTaskQueue.size() >= this.mTaskQueueMax) {
                SJctrLogUty.warn(CLASS_NAME, "addTask", "TaskQueue max ");
                SJctrError err = new SJctrError(201, 22, 105055);
                SJcException exp = err.createException();
                throw exp;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            SJmoRscMgr rscMgr = SJmoRscMgr.getInstance();
            List<List<ArrayList<? extends SJmoModelData_Base>>> lsDiffList = task.getResourceDiff();
            rscMgr.setDiffData(lsDiffList);
            Class<SJctrQueueController> clazz2 = SJctrQueueController.class;
            synchronized (SJctrQueueController.class) {
                Date submitTime = new Date();
                task.setSubmitTime(submitTime.getTime());
                String taskId = this.takeTaskId(submitTime);
                task.setId(taskId);
                task.initBehavior();
                task.initLeadTime();
                try {
                    this.saveTaskApplyData(task);
                    task.destroyApplyData();
                }
                catch (Exception e) {
                    SJctrLogUty.warn(CLASS_NAME, "addTask", "create ApplyFile Fail : ", e);
                }
                try {
                    this.saveTaskConfirmData(task);
                    task.destroyConfirmData();
                }
                catch (Exception e) {
                    SJctrLogUty.warn(CLASS_NAME, "addTask", "create ConfirmFile Fail : ", e);
                }
                if (task.changeStatus(1) != 0) {
                    SJctrLogUty.warn(CLASS_NAME, "addTask", "invalid status (" + task.getStatus() + ")");
                    SJctrError err = new SJctrError(201, 22, 105054);
                    SJcException exp = err.createException();
                    throw exp;
                }
                try {
                    this.saveTaskControlData(task);
                }
                catch (Exception e) {
                    SJctrLogUty.warn(CLASS_NAME, "addTask", "create Task Control File Fail : ", e);
                }
                this.mTaskQueue.add(task);
                SJctrLogUty.trace(CLASS_NAME, "addTask", "ID = " + task.getId());
                SJctrLogUty.trace(CLASS_NAME, "addTask", "TaskQueue count = " + this.mTaskQueue.size());
                // ** MonitorExit[var4_8] (shouldn't be in output)
                this.wakeUpWorkerThread();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void toHistory(SJctrTask task) {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            SJctrLogUty.info(CLASS_NAME, "toHistory", "start");
            SJctrLogUty.trace(CLASS_NAME, "toHistory", "Queue to Record");
            this.mTaskQueue.remove(task);
            this.mTaskRecord.add(task);
            task.destroyApplyData();
            task.destroyResourceDiff();
            this.toHistoryCofirmData(task);
            this.toHistoryApplyResult(task);
            this.toHistoryCotrolData(task);
            String applyFileName = SJctrQueueController.getApplyFileName(task.getId());
            this.deleteFile(DIR_NAME_QUEUE, applyFileName);
            SJctrLogUty.trace(CLASS_NAME, "toHistory", "TaskQueue count = " + this.mTaskQueue.size());
            SJctrLogUty.trace(CLASS_NAME, "toHistory", "TaskRecord count = " + this.mTaskRecord.size());
            SJctrLogUty.info(CLASS_NAME, "toHistory", "end");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void toHistoryCotrolData(SJctrTask task) {
        try {
            this.saveTaskControlData(task);
            String controlFileName = SJctrQueueController.getControlFileName(task.getId());
            String filePath = DIR_NAME_QUEUE + "\\" + controlFileName;
            boolean fileExist = SJcFileUty.exists(filePath);
            if (fileExist) {
                SJcFileUty.deleteFile(DIR_NAME_QUEUE, controlFileName);
            }
        }
        catch (Exception e) {
            SJctrLogUty.warn(CLASS_NAME, "toHistoryCotrolData", "create ControlFile fail:" + task.getId(), e);
        }
    }

    private void toHistoryCofirmData(SJctrTask task) {
        String queueFilePath;
        boolean ququeFileExist;
        boolean recordMakeFlg = true;
        String confirmFileName = SJctrQueueController.getConfirmFileName(task.getId());
        String recordFilePath = DIR_NAME_RECORD + "\\" + confirmFileName;
        boolean recordFileExist = SJcFileUty.exists(recordFilePath);
        if (!recordFileExist) {
            if (task.getConfirmData() == null) {
                try {
                    SJcFileUty.copyFile(DIR_NAME_QUEUE, confirmFileName, DIR_NAME_RECORD, confirmFileName);
                }
                catch (Exception e) {
                    SJctrLogUty.warn(CLASS_NAME, "toHistoryCofirmData", "ConfirmFile move fail:" + confirmFileName, e);
                    recordMakeFlg = false;
                }
            } else {
                try {
                    this.saveTaskConfirmData(task);
                    task.destroyConfirmData();
                }
                catch (Exception e) {
                    SJctrLogUty.warn(CLASS_NAME, "toHistoryCofirmData", "create ConfirmFile fail:" + task.getId(), e);
                    recordMakeFlg = false;
                }
            }
        }
        if ((ququeFileExist = SJcFileUty.exists(queueFilePath = DIR_NAME_QUEUE + "\\" + confirmFileName)) && recordMakeFlg) {
            try {
                SJcFileUty.deleteFile(DIR_NAME_QUEUE, confirmFileName);
            }
            catch (Exception e) {
                SJctrLogUty.warn(CLASS_NAME, "toHistoryCofirmData", "delete ConfirmFile fail:" + task.getId(), e);
            }
        }
    }

    private void toHistoryApplyResult(SJctrTask task) {
        String resultFileName = SJctrQueueController.getResultFileName(task.getId());
        String filePath = DIR_NAME_QUEUE + "\\" + resultFileName;
        boolean fileExist = SJcFileUty.exists(filePath);
        if (fileExist) {
            try {
                SJcFileUty.moveFile(DIR_NAME_QUEUE, resultFileName, DIR_NAME_RECORD, resultFileName);
            }
            catch (Exception e) {
                SJctrLogUty.info(CLASS_NAME, "toHistoryApplyResult", "ApplyResultFile move fail:" + resultFileName, e);
            }
        } else {
            try {
                this.saveTaskResultData(task);
                task.destroyResultData();
            }
            catch (Exception e) {
                SJctrLogUty.warn(CLASS_NAME, "toHistoryApplyResult", "create ResultFile fail:" + task.getId(), e);
            }
        }
    }

    private void toHistoryRemainQueue(SJctrTask task) {
        boolean ret = task.toRemainFailed();
        if (ret) {
            this.toHistoryCotrolData(task);
            this.toHistoryCofirmData(task);
            this.toHistoryApplyResult(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskForRegularBackup(SJctrTask task) throws SJcException {
        this.removeTask(task, 1);
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            this.addDeleteTaskInfo(task);
            this.saveDeleteTaskListInfo();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTask(SJctrTask task) throws SJcException {
        this.removeTask(task, 1);
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            this.addDeleteTaskInfo(task);
            this.saveDeleteTaskListInfo();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTask(SJctrTask task, int removeMode) {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (task.changeStatus(515) != 0) {
                SJctrError err = new SJctrError(201, 22, 105059);
                SJcException exp = err.createException();
                throw exp;
            }
            if (this.mTaskQueue.remove(task)) {
                this.deleteQueueFile(task.getId());
                SJctrLogUty.trace(CLASS_NAME, "removeTask", "TaskQueue Del : " + task.getId());
                SJctrLogUty.trace(CLASS_NAME, "removeTask", "TaskQueue count = " + this.mTaskQueue.size());
                this.releaseResourceDiff(task, 1);
                this.releaseDkcLock(task);
            } else if (this.mTaskRecord.remove(task)) {
                this.deleteRecordFile(task.getId());
                SJctrLogUty.trace(CLASS_NAME, "removeTask", "TaskRecord Del : " + task.getId());
                SJctrLogUty.trace(CLASS_NAME, "removeTask", "TaskRecord count = " + this.mTaskRecord.size());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (removeMode == 1) {
                this.wakeUpWorkerThread();
            }
            return;
        }
    }

    private void addDeleteTaskInfo(SJctrTask task) {
        try {
            String hash = SJsncTaskHashUty.createHash(task);
            if (this.mDeleteTaskList.size() < this.mDeleteTaskMax) {
                this.mDeleteTaskList.add(hash);
            } else {
                this.mDeleteTaskList.set(this.mDeleteTaskIndex, hash);
            }
            ++this.mDeleteTaskIndex;
            if (this.mDeleteTaskIndex >= this.mDeleteTaskMax) {
                this.mDeleteTaskIndex = 0;
            }
            SJctrLogUty.info(CLASS_NAME, "addDeleteTaskInfo", "DeleteTaskIndex = " + this.mDeleteTaskIndex);
        }
        catch (Exception e) {
            SJctrLogUty.warn(CLASS_NAME, "addDeleteTaskInfo", "addDeleteTaskInfo fail");
        }
    }

    private void saveDeleteTaskListInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_DELETE_TASK_LIST, this.mDeleteTaskList);
        map.put(KEY_DELETE_TASK_INDEX, this.mDeleteTaskIndex);
        try {
            SJcFileUty.saveClass2File(DIR_NAME_DELETE, FILE_NAME_DELETE, map);
            SJctrLogUty.info(CLASS_NAME, "saveDeleteTaskListInfo", "DeleteTaskIndex = " + this.mDeleteTaskIndex);
        }
        catch (Exception e) {
            SJctrLogUty.warn(CLASS_NAME, "saveDeleteTaskListInfo", "save DeleteTaskListFile fail");
        }
    }

    protected void suspendTask(SJctrTask task) throws SJcException {
        if (task.changeStatus(2) != 0) {
            SJctrError err = new SJctrError(201, 22, 105061);
            SJcException exp = err.createException();
            throw exp;
        }
        this.wakeUpWorkerThread();
    }

    protected void resumeTask(SJctrTask task) throws SJcException {
        if (task.changeStatus(1) != 0) {
            SJctrError err = new SJctrError(201, 22, 105063);
            SJcException exp = err.createException();
            throw exp;
        }
        this.wakeUpWorkerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortTask(SJctrTask task, Robj_interface_AuditUserInfo userInfo) throws SJcException {
        if (!task.isAbortable()) {
            SJctrError err = new SJctrError(201, 22, 105066);
            SJcException exp = err.createException();
            throw exp;
        }
        this.setDkcLock(task);
        SJdsSupplierAgent supplier = SJdsSupplierMgr.getSupplierMgr().getAgent();
        SJctrLogUty.info(CLASS_NAME, "abortTask", "lock start.");
        this.setApplyLock();
        SJctrLogUty.info(CLASS_NAME, "abortTask", "lock finish.");
        try {
            if (task.changeStatus(257) != 0) {
                SJctrError err = new SJctrError(201, 22, 105065);
                SJcException exp = err.createException();
                throw exp;
            }
            task.abort(userInfo, supplier);
        }
        finally {
            SJctrLogUty.info(CLASS_NAME, "abortTask", "unlock start.");
            this.releaseApplyLock();
            this.releaseDkcLock(task);
            SJctrLogUty.info(CLASS_NAME, "abortTask", "unlock finish.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void protectTask(SJctrTask task, boolean protection) throws SJcException {
        boolean wakeUpFlg = false;
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (task.isProtection() == protection) {
                SJctrError err = protection ? new SJctrError(201, 22, 105068) : new SJctrError(201, 22, 105069);
                SJcException exp = err.createException();
                throw exp;
            }
            task.setProtection(protection);
            if (task.isFinish()) {
                try {
                    this.saveTaskControlData(task);
                }
                catch (Exception e) {
                    SJctrLogUty.warn(CLASS_NAME, "protectTask", "update ControlFile Fail : " + task.getId(), e);
                }
                if (!protection) {
                    wakeUpFlg = true;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (wakeUpFlg) {
                this.wakeUpWorkerThread();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SJctrTask> getTaskList() {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            ArrayList<SJctrTask> ret = null;
            ret = new ArrayList<SJctrTask>(this.mTaskQueue.size() + this.mTaskRecord.size());
            ret.addAll(this.mTaskQueue);
            ret.addAll(this.mTaskRecord);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SJctrTask> getSpecificStatusTaskList(int status) {
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            List<SJctrTask> allTask = this.getTaskList();
            ArrayList<SJctrTask> ret = new ArrayList<SJctrTask>(allTask.size());
            for (SJctrTask task : allTask) {
                if (task.getStatus() != status) continue;
                ret.add(task);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getDeleteTaskList() {
        ArrayList<String> ret = new ArrayList<String>(this.mDeleteTaskMax);
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            if (this.mDeleteTaskList.size() < this.mDeleteTaskMax) {
                ret.addAll(Collections.nCopies(this.mDeleteTaskMax - this.mDeleteTaskList.size(), ENPTY_STRING));
            }
            List deleteTaskList = this.getNormalizeRotateList(this.mDeleteTaskList, this.mDeleteTaskIndex);
            ret.addAll(deleteTaskList);
            SJctrLogUty.info(CLASS_NAME, "getDeleteTaskList", "size = " + ret.size());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    void loadTaskControlData(String taskId, SJctrTask task, String directoryName) throws Exception {
        String fileName = SJctrQueueController.getControlFileName(taskId);
        Serializable fileData = SJcFileUty.loadSerializeWithDec(directoryName, fileName);
        task.importControlData(fileData);
    }

    void saveTaskControlData(SJctrTask task) throws Exception {
        String directoryName = !task.isFinish() ? DIR_NAME_QUEUE : DIR_NAME_RECORD;
        String fileName = SJctrQueueController.getControlFileName(task.getId());
        SJcFileUty.saveSerializeWithEnc(directoryName, fileName, task.exportControlData());
    }

    void loadTaskApplyData(SJctrTask task) throws Exception {
        String directoryName = !task.isFinish() ? DIR_NAME_QUEUE : DIR_NAME_RECORD;
        String fileName = SJctrQueueController.getApplyFileName(task.getId());
        Serializable fileData = SJcFileUty.loadSerializeWithDec(directoryName, fileName);
        task.importApplyData(fileData);
    }

    void saveTaskApplyData(SJctrTask task) throws Exception {
        String directoryName = !task.isFinish() ? DIR_NAME_QUEUE : DIR_NAME_RECORD;
        String fileName = SJctrQueueController.getApplyFileName(task.getId());
        SJcFileUty.saveSerializeWithEnc(directoryName, fileName, task.exportApplyData());
    }

    void loadTaskConfirmData(SJctrTask task) throws Exception {
        Serializable fileData = this.getTaskConfirmData(task);
        task.importConfirmData(fileData);
    }

    Serializable getTaskConfirmData(SJctrTask task) throws Exception {
        Serializable fileData;
        String directoryName = this.getTaskDirectory(task);
        String fileName = SJctrQueueController.getConfirmFileName(task.getId());
        try {
            fileData = SJcFileUty.loadSerializeWithDec(directoryName, fileName);
        }
        catch (Exception e) {
            SJctrLogUty.warn(CLASS_NAME, "getTaskConfirmData", "File load Failed.", e);
            String anotherDirectoryName = this.getAnotherTaskDirectory(task);
            fileData = SJcFileUty.loadSerializeWithDec(anotherDirectoryName, fileName);
        }
        return fileData;
    }

    void saveTaskConfirmData(SJctrTask task) throws Exception {
        String directoryName = !task.isFinish() ? DIR_NAME_QUEUE : DIR_NAME_RECORD;
        String fileName = SJctrQueueController.getConfirmFileName(task.getId());
        SJcFileUty.saveSerializeWithEnc(directoryName, fileName, task.exportConfirmData());
    }

    void copyConfirmDataFile(SJctrTask task) throws Exception {
        String confirmFileName = SJctrQueueController.getConfirmFileName(task.getId());
        SJcFileUty.copyFile(DIR_NAME_QUEUE, confirmFileName, DIR_NAME_RECORD, confirmFileName);
    }

    void loadTaskResultData(SJctrTask task) throws Exception {
        Serializable fileData = this.getTaskResultData(task);
        task.mApplyResultList = (List)((Object)fileData);
    }

    Serializable getTaskResultData(SJctrTask task) throws Exception {
        String directoryName = this.getTaskDirectory(task);
        String fileName = SJctrQueueController.getResultFileName(task.getId());
        Serializable fileData = SJcFileUty.loadSerializeWithDec(directoryName, fileName);
        return fileData;
    }

    void saveTaskResultData(SJctrTask task) throws Exception {
        String directoryName = this.getTaskDirectory(task);
        String fileName = SJctrQueueController.getResultFileName(task.getId());
        SJcFileUty.saveSerializeWithEnc(directoryName, fileName, task.exportApplyResult());
    }

    void saveTaskDump(SJctrTask task) throws Exception {
        Serializable ser = task.exportControlData();
        String fileName = DUMP_APPLY_TIME_FORMAT.format(task.getApplyStartTime());
        fileName = fileName + "_" + SJctrQueueController.getControlFileName(task.getId());
        SJcFileUty.saveSerializeWithEnc(DIR_NAME_DUMP, fileName, ser);
        Object[] files = SJcFileUty.getFileList(DIR_NAME_DUMP);
        if (files.length > DUMP_MAX) {
            Arrays.sort(files);
            int i = 0;
            while (files.length - i > DUMP_MAX) {
                this.deleteFile(DIR_NAME_DUMP, (String)files[i]);
                ++i;
            }
        }
    }

    String getTaskDirectory(SJctrTask task) {
        String directoryName = !task.isFinish() ? DIR_NAME_QUEUE : DIR_NAME_RECORD;
        return directoryName;
    }

    String getAnotherTaskDirectory(SJctrTask task) {
        String directoryName = task.isFinish() ? DIR_NAME_QUEUE : DIR_NAME_RECORD;
        return directoryName;
    }

    public static String getControlFileName(String taskId) {
        StringBuilder ret = new StringBuilder();
        ret.append(taskId);
        ret.append(FILE_NAME_CONTROL);
        return ret.toString();
    }

    public static boolean isControlFileName(String fileName) {
        int lastIndex = fileName.lastIndexOf(FILE_NAME_CONTROL);
        if (lastIndex < 0) {
            return false;
        }
        return lastIndex + FILE_NAME_CONTROL.length() == fileName.length();
    }

    public static String controlFileNameToTaskId(String controlFileName) {
        String ret = ENPTY_STRING;
        int lastIndex = controlFileName.lastIndexOf(FILE_NAME_CONTROL);
        if (lastIndex >= 0) {
            ret = controlFileName.substring(0, lastIndex);
        }
        return ret;
    }

    public static String getApplyFileName(String taskId) {
        StringBuilder ret = new StringBuilder();
        ret.append(taskId);
        ret.append(FILE_NAME_APPLY);
        return ret.toString();
    }

    public static String getConfirmFileName(String taskId) {
        StringBuilder ret = new StringBuilder();
        ret.append(taskId);
        ret.append(FILE_NAME_CONFIRM);
        return ret.toString();
    }

    public static String getResultFileName(String taskId) {
        StringBuilder ret = new StringBuilder();
        ret.append(taskId);
        ret.append(FILE_NAME_RESULT);
        return ret.toString();
    }

    boolean deleteFile(String directoryName, String fileName) {
        boolean result = false;
        try {
            SJcFileUty.deleteFile(directoryName, fileName);
            result = true;
        }
        catch (Exception e) {
            SJctrLogUty.info(CLASS_NAME, "deleteFile", "delete fail:dir=" + directoryName + ",file=" + fileName, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isHistoryAccept() {
        boolean ret = true;
        int noProtectTaskCount = 0;
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            int beginExecCount = this.mTaskRecord.size() + this.getExecuteTaskCnt();
            int needDeleteCount = beginExecCount - (this.mTaskRecordMax - 1);
            if (needDeleteCount > 0) {
                ret = false;
                for (SJctrTask task : this.mTaskRecord) {
                    if (!task.isProtection()) {
                        ++noProtectTaskCount;
                    }
                    if (noProtectTaskCount < needDeleteCount) continue;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return true;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    private boolean makeSpaceHistoryTaskList() {
        boolean ret = true;
        int execCnt = this.getExecuteTaskCnt();
        while (this.mTaskRecord.size() + execCnt >= this.mTaskRecordMax) {
            SJctrTask delTask = SJctrQueueController.getDeleteTargetTask(this.mTaskRecord);
            if (delTask == null) {
                SJctrLogUty.info(CLASS_NAME, "makeSpaceHistoryTaskList", "TaskRecord All Protected");
                return false;
            }
            try {
                this.removeTask(delTask, 0);
            }
            catch (SJcException e) {
                SJctrLogUty.info(CLASS_NAME, "makeSpaceHistoryTaskList", "old Task Deleted fail:" + delTask.getId(), e);
                return false;
            }
        }
        return ret;
    }

    public int getExecuteTaskCnt() {
        int execCnt = 0;
        for (SJctrTask queueingTask : this.mTaskQueue) {
            if (!queueingTask.isExecute()) continue;
            ++execCnt;
        }
        return execCnt;
    }

    public void setDkcLock(SJctrTask task) throws SJcException {
        long lockId = task.getLockId();
        boolean allRSGFlg = task.getAllRSGFlg();
        int lockType = SJctrQueueController.getLockType(allRSGFlg);
        task.setLockId(-1L);
        BitSet lockBit = task.getResourceGroupIdSet();
        if (lockType == 0) {
            lockBit = null;
        }
        int ssoOpt = task.getSsoOpt();
        SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
        try {
            if (lockId == -1L) {
                String userId = task.getUserId();
                String pass = task.getPassword();
                String IPAdress = task.getUserInfo().getStrIPaddress();
                lockId = agent.setDkcLock(-1L, userId, pass, lockBit, lockType, IPAdress, ssoOpt);
            } else {
                lockId = agent.setDkcLock(lockId, null, null, lockBit, lockType, null, ssoOpt);
            }
        }
        catch (SJcException e) {
            throw SJctrMessageExchanger.exchange(e);
        }
        task.setLockId(lockId);
        SJctrLogUty.info(CLASS_NAME, "setDkcLock", "lockId=" + lockId);
    }

    public void releaseDkcLock(SJctrTask task) {
        try {
            SJdsSupplierAgent agent = SJdsSupplierMgr.getSupplierMgr().getAgent();
            long lockId = task.getLockId();
            boolean allRSGFlg = task.getAllRSGFlg();
            int lockType = SJctrQueueController.getLockType(allRSGFlg);
            BitSet lockBit = task.getResourceGroupIdSet();
            if (lockType == 0) {
                lockBit = null;
            }
            agent.releaseDkcLock(lockId, lockBit, lockType);
        }
        catch (SJmoException e) {
            SJctrLogUty.warn(CLASS_NAME, "releaseDkcLock", "Release DKC Lock fail", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SJctrGuidance> getQueueingTaskActNameList() {
        ArrayList<SJctrGuidance> ret = new ArrayList<SJctrGuidance>();
        Class<SJctrQueueController> clazz = SJctrQueueController.class;
        synchronized (SJctrQueueController.class) {
            for (SJctrTask queueingTask : this.mTaskQueue) {
                List<SJctrGuidance> guidList = queueingTask.mActionGuidance;
                for (SJctrGuidance guid : guidList) {
                    ret.add(guid);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    public void releaseResourceDiff(SJctrTask task, int opportunity) {
        SJmoRscMgr rscMgr = SJmoRscMgr.getInstance();
        List<List<ArrayList<? extends SJmoModelData_Base>>> lsDiffList = task.getResourceDiff();
        try {
            rscMgr.delDiffData(lsDiffList, opportunity);
        }
        catch (SJmoException e) {
            SJctrLogUty.warn(CLASS_NAME, "releaseResourceDiff", "Diff Data Delete Error." + task.getId(), e);
        }
    }

    public void releaseResourceDiff(int opportunity) {
        SJmoRscMgr rscMgr = SJmoRscMgr.getInstance();
        try {
            rscMgr.delDiffData(null, opportunity);
        }
        catch (SJmoException e) {
            SJctrLogUty.warn(CLASS_NAME, "releaseResourceDiff", "Diff Data Delete Error.", e);
        }
    }

    boolean setApplyLock() {
        boolean ret = true;
        if (this.applyLock) {
            ret = false;
            SJctrLogUty.warn(CLASS_NAME, "setApplyLock", "Apply Lock Error.");
        } else {
            this.applyLock = true;
        }
        return ret;
    }

    void releaseApplyLock() {
        if (!this.applyLock) {
            SJctrLogUty.warn(CLASS_NAME, "releaseApplyLock", "Apply Unlock.");
        } else {
            this.applyLock = false;
        }
    }

    public static int getLockType(boolean allRSGFlg) {
        int ret = 1;
        if (allRSGFlg) {
            ret = 0;
        }
        return ret;
    }

    public static boolean checkErrorCodeRetrySetDkcLock(int errorCode) {
        boolean ret = false;
        for (int err : errorCodeRetrySetDkcLock) {
            if (errorCode != err) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void encryptTasks() {
        String LOG_SUBTITLE = "encryptTasks";
        if (SJcFileUty.exists(TASK_CONVERT_FILE)) {
            SJctrLogUty.info(CLASS_NAME, "encryptTasks", "Start.");
            long startTime = new Date().getTime();
            this.encryptTaskFiles(DIR_NAME_QUEUE);
            this.encryptTaskFiles(DIR_NAME_RECORD);
            this.encryptTaskFiles(DIR_NAME_DUMP);
            try {
                SJcFileUty.deleteFile(ENPTY_STRING, TASK_CONVERT_FILE);
            }
            catch (Exception ex) {
                // empty catch block
            }
            long endTime = new Date().getTime();
            SJctrLogUty.info(CLASS_NAME, "encryptTasks", "End. (" + (endTime - startTime) + " ms.)");
        } else {
            SJctrLogUty.info(CLASS_NAME, "encryptTasks", TASK_CONVERT_FILE + " not exists.");
        }
    }

    private boolean encryptTaskFiles(String dirName) {
        String[] fileNames;
        String LOG_SUBTITLE = "encryptTaskFiles";
        boolean failed = false;
        for (String fileName : fileNames = SJcFileUty.getFileList(dirName)) {
            if (!fileName.endsWith(TASK_EXT)) continue;
            String fileNameBack = TASK_BACKUP_PREFIX + fileName + TASK_BACKUP_EXT;
            try {
                Serializable task = null;
                if (this.isEncryptedTask(dirName, fileName)) {
                    SJctrLogUty.info(CLASS_NAME, "encryptTaskFiles", "Encrypted Task File : " + fileName);
                    continue;
                }
                SJctrLogUty.info(CLASS_NAME, "encryptTaskFiles", "Unencrypted Task File : " + fileName);
                task = SJcFileUty.loadSerializeNoLock(dirName, fileName);
                SJcFileUty.copyFile(dirName, fileName, dirName, fileNameBack);
                SJcFileUty.saveSerializeWithEnc(dirName, fileName, task);
                SJcFileUty.deleteFile(dirName, fileNameBack);
                SJctrLogUty.info(CLASS_NAME, "encryptTaskFiles", "Encryption success.");
            }
            catch (Exception ex) {
                failed = true;
                SJctrLogUty.warn(CLASS_NAME, "encryptTaskFiles", "Encryption error. : " + fileName);
                try {
                    SJcFileUty.copyFile(dirName, fileNameBack, dirName, fileName);
                    SJcFileUty.deleteFile(dirName, fileNameBack);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
        return failed;
    }

    private boolean isEncryptedTask(String dirName, String fileName) {
        boolean result = false;
        try {
            byte[] binData = SJcFileUty.loadBinary(dirName, fileName, 0, -1);
            SJcSecureUty.decryptByte(binData);
            result = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result;
    }
}

