/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDirectLauncher;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;

public abstract class SJctrTabDataController
extends SJctrDataController {
    private static final String KEY_TAB = "COM_TAB";
    private static final String KEY_CHILD = "COM_CHILD";
    private Class<?> defaultDCClass = null;
    private SJctrRelatedDispDataObject childDisp;
    private Object[] childArgs;

    public SJctrTabDataController(int dispId) throws SJcException {
        super(dispId);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public void setParameter(Object ... args) {
        if (args[0] instanceof Class) {
            this.setDefaultDCClass((Class)args[0]);
        }
        this.childArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, this.childArgs, 0, this.childArgs.length);
    }

    public void setDefaultDCClass(Class<?> cls) {
        this.defaultDCClass = cls;
    }

    protected void addTab(String key, String label, Class<? extends SJctrDataController> cls) {
        SJctrComboBoxDataModel tabModel = this.getTabModel();
        tabModel.addItem(key, label);
        tabModel.setItemObject(key, cls);
    }

    protected void setSelectedTabIndex(int index) {
        SJctrComboBoxDataModel tabModel = this.getTabModel();
        tabModel.setSelectedIndex(index);
    }

    protected void setSelectedTabKey(String key) {
        SJctrComboBoxDataModel tabModel = this.getTabModel();
        tabModel.setSelection(key);
    }

    protected boolean setSelectedTabClass(Class<?> cls) {
        SJctrComboBoxDataModel tabModel = this.getTabModel();
        for (HashMap<String, Object> item : tabModel.getItemMap().values()) {
            Class itemClass = (Class)SJctrComboBoxDataModel.Item.getObject(item);
            if (itemClass != cls) continue;
            return tabModel.setSelection(SJctrComboBoxDataModel.Item.getName(item));
        }
        return false;
    }

    public SJctrComboBoxDataModel getTabModel() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_TAB);
    }

    protected void setDefaultSelected() {
        if (this.defaultDCClass != null) {
            this.setSelectedTabClass(this.defaultDCClass);
        }
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TAB, new SJctrComboBoxDataModel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void makeDataObject() {
                try {
                    this.setEnableListener(false);
                    SJctrTabDataController.this.setDefaultSelected();
                    if (this.getSelection() == null && !this.isRestoreFlg()) {
                        this.setSelectedIndex(0);
                    }
                }
                finally {
                    this.setEnableListener(true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOwnControlData(HashMap<String, Object> controlData) {
                try {
                    this.setEnableListener(false);
                    this.restoreTabSelection(controlData);
                }
                finally {
                    this.setEnableListener(true);
                }
            }

            private void restoreTabSelection(HashMap<String, Object> controlData) {
                if (this.getSelection() != null) {
                    return;
                }
                super.setOwnControlData(controlData);
                if (this.getSelection() == null) {
                    SJctrTabDataController.this.setSelectedTabIndex(0);
                }
            }
        });
        this.addDataObjectModel(KEY_CHILD, new SJctrSimpleDataModel(){

            @Override
            public Map<String, Map<String, Object>> getActionMenu() {
                Map<String, Map<String, Object>> actionMap = super.getActionMenu();
                SJctrDataController dc = SJctrTabDataController.this.getOwner().getDataController(SJctrTabDataController.this.childDisp);
                if (dc != null) {
                    Map<String, Map<String, Object>> map = dc.getActionMenu();
                    actionMap.putAll(map);
                }
                return actionMap;
            }

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                SJctrUserController uc = SJctrTabDataController.this.getOwner();
                SJctrComboBoxDataModel tab = SJctrTabDataController.this.getTabModel();
                String key = tab.getSelection();
                HashMap<String, Object> item = tab.getItem(key);
                Class cls = (Class)SJctrComboBoxDataModel.Item.getObject(item);
                SJctrTabDataController.this.childDisp = uc.createRelatedDispData(cls);
                SJctrDataController childDc = uc.getDataController(SJctrTabDataController.this.childDisp);
                childDc.setParameter(SJctrTabDataController.this.childArgs);
                ArrayList<SJctrRelatedDispDataObject> retObject = new ArrayList<SJctrRelatedDispDataObject>(2);
                retObject.add(SJctrTabDataController.this.childDisp);
                if (SJctrDataController.isDispKind(childDc.getDisplayId(), 0)) {
                    SJctrDirectLauncher dl = uc.getDirectLauncher();
                    SJctrRelatedDispDataObject directLaunch = dl.makeDirectLaunchDispData(childDc);
                    if (directLaunch != null) {
                        retObject.add(directLaunch);
                    }
                    SJctrRelatedDispDataObject topRelated = uc.getRelatedDispData(SJctrTopWindowDC.class);
                    SJctrTopWindowDC topDc = (SJctrTopWindowDC)uc.getDataController(topRelated);
                    topDc.setDirtyTopMenu();
                    topDc.setDirtyAuditLog();
                    topDc.setDirtyLastUpdate();
                    SJctrRelatedDispDataObject updateRelated = topDc.getUpdateDisp();
                    retObject.add(updateRelated);
                }
                return retObject;
            }
        });
    }

    private void initListener() {
        final SJctrComboBoxDataModel tabModel = this.getTabModel();
        tabModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    String key = (String)event.getChangeObject();
                    HashMap<String, Object> item = tabModel.getItem(key);
                    Class cls = (Class)SJctrComboBoxDataModel.Item.getObject(item);
                    event.getSource().clearDirty();
                    ArrayList<Object> param = new ArrayList<Object>();
                    param.add(cls);
                    for (Object obj : SJctrTabDataController.this.childArgs) {
                        param.add(obj);
                    }
                    SJctrTopWindowDC topDc = SJctrTabDataController.this.getTopWindow();
                    if (topDc != null) {
                        SJctrDataController.NOTIFY_STATE moveMsg = topDc.getActiveAccordionTreeMsg();
                        if (moveMsg != null) {
                            SJctrTabDataController.this.fireMessageEvent(moveMsg, param);
                        } else {
                            SJctrTabDataController.this.getLogUty().putlog("selectChanged", "moveMsg = null", 40000);
                        }
                    } else {
                        SJctrTabDataController.this.getLogUty().putlog("selectChanged", "topDc = null", 40000);
                    }
                }
            }
        });
    }

    public String getLabel() {
        String sLabel = null;
        String sName = null;
        HashMap<String, Object> item = null;
        SJctrComboBoxDataModel tabModel = this.getTabModel();
        sName = tabModel.getSelection();
        item = tabModel.getItem(sName);
        sLabel = SJctrComboBoxDataModel.Item.getLabel(item);
        return sLabel;
    }

    public SJctrRelatedDispDataObject getChildDisp() {
        return this.childDisp;
    }

    public int getTabDisplayID() {
        int childDispID;
        int retDispId = -1;
        if (this.childDisp != null && SJctrTabDataController.isDispKind(childDispID = this.childDisp.dispId().intValue(), 0)) {
            retDispId = childDispID;
        }
        return retDispId;
    }
}

