/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.base.session.inf.SJbaseUserCtrInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcSessionUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.SJctrControllerManager;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDirectLauncher;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrQueueBox;
import sanproject.sn2.controller.com.SJctrRequestInterface;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUniqueIdManager;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.data.system.SJmoPPKget1PPInfo;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrUserController
implements SJctrRequestInterface,
SJbaseUserCtrInterface {
    private static final int SN_SESSION_SYSTEM_MAX = 33;
    private static final SJctrUniqueIdManager userIdManager;
    protected SJbaseUserSessionInterface userSession = null;
    protected SJctrLogUty logUty = new SJctrLogUty();
    protected String logFunc = "ctr";
    private int mUserNo;
    private SJmoGetAgent modelAgent;
    private SJctrUniqueIdManager uIdManager;
    private Map<Integer, SJctrDataController> dataControllerMap;
    private SJctrDataController useChildWindowDC;
    private SJctrDataController useTabDC;
    private SJctrQueueBox queueBox;
    private List<SJctrWizardWindowDC> mWizardList;
    private SJctrComUtility utility;
    private HashMap<Integer, Object> mControlDataMap = new HashMap();
    private Properties property = new Properties();
    private static int mClientCount;
    private static final int SN_UID_MAX = 100;
    public static final String KEY_VIEWINFO = "COM_VIEWINFO";
    public static final String USERSAVE = "usersave.dat";
    SJctrAuthorizeContainer authorizeContainer;
    private boolean flgResetViewSettings = false;
    public static final Set<String> RESET_USER_PROPERTY_KEY;
    private SJctrDirectLauncher mDirectLauncher = new SJctrDirectLauncher();
    private long lockId;
    private static final String GUID_HM800 = "VSPGX00";
    private static final String GUID_HM800H = "VSPG800";
    private static final String GUID_HM800M3 = "VSPG600";
    private static final String GUID_HM800M2 = "VSPG400";
    private static final String GUID_HM800S1 = "VSPG200";
    private static final String GUID_HM800S0 = "VSPG100";
    private static final String GUID_HM800H_AFA = "VSPF800";
    private static final String GUID_HM800M3_AFA = "VSPF600";
    private static final String GUID_HM800M2_AFA = "VSPF400";
    public static String strHM800;
    public static String strHM800H;
    public static String strHM800M3;
    public static String strHM800M2;
    public static String strHM800S1;
    public static String strHM800S0;
    public static String strHM800H_AFA;
    public static String strHM800M3_AFA;
    public static String strHM800M2_AFA;
    public static String strStogageSystemType;
    private int ssoOpt = 0;

    public SJctrUserController() {
    }

    public SJctrUserController(String name) {
        SJbaseUserSession session = new SJbaseUserSession();
        session.setUserName(name);
        session.setLoginType("NOR");
        String lang = SJctrEncryptionKeysUtility.getLanguageType();
        session.setLanguageType(lang);
        try {
            session.setAddress(InetAddress.getLocalHost());
            this.initializeForRegularBackup(session);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void initialize(SJbaseUserSessionInterface userSession) throws Exception {
        SJctrLogUty.info("SJctrUserController", "initialize", "start");
        Object obj = SJcSingletonManagerUty.getInstance(SJctrControllerManager.class);
        if (!(obj instanceof SJctrControllerManager)) {
            SJctrLogUty.error("SJctrUserController", "initialize", "obj = " + obj);
            throw new SJcException();
        }
        SJctrControllerManager mng = (SJctrControllerManager)obj;
        if (mng.getStatus().getPhase() != 2) {
            SJctrLogUty.error("SJctrUserController", "initialize", "ControllerManager Phase: " + mng.getStatus().getPhase());
            throw new SJcException();
        }
        try {
            this.userSession = userSession;
            this.mUserNo = userIdManager.acquireId();
            this.logFunc = "ctr:" + this.mUserNo;
            SJctrLogUty logUty = this.createLogUty();
            logUty.setTitle(this.getClass().getSimpleName());
            this.setLogUty(logUty);
            this.useChildWindowDC = null;
            this.dataControllerMap = new HashMap<Integer, SJctrDataController>();
            this.mWizardList = new ArrayList<SJctrWizardWindowDC>();
            int UID_MAX = SJcEnvUty.getProperty2int("SN_UID_MAX", 100);
            this.uIdManager = new SJctrUniqueIdManager(UID_MAX);
            SJmoDataChange dataChange = null;
            SJmoModelMgr mgr = SJmoModelMgr.getModelMgr();
            this.modelAgent = mgr.getDataAgent();
            dataChange = mgr.getDataChange();
            this.utility = new SJctrComUtility(dataChange, userSession.getGuidanceInfo(), userSession.getMessageInfo());
            this.queueBox = new SJctrQueueBox(this);
            this.initAuthorizeContainer();
            Class<SJctrTopWindowDC> initDisp = SJctrTopWindowDC.class;
            SJctrRelatedDispDataObject top = this.getRelatedDispData(initDisp);
            SJctrSystemParamContainer spc = this.authorizeContainer.getSystemParamContainer();
            if (!spc.isLocalHost()) {
                if (mClientCount == 0) {
                    this.modelAgent.setRebootRestrainFlag(true);
                }
                ++mClientCount;
            }
            this.loadUserDataFile();
            this.mDirectLauncher.initialize(userSession);
            this.lockId = -1L;
            this.ssoOpt = SJcSessionUty.getSsoOption(userSession);
            logUty.putlog("initialize", "SsoOption=" + this.ssoOpt);
        }
        catch (Exception e) {
            this.logUty.putlog("initialize", "Exception", e, 40000);
            throw e;
        }
        this.setProductName();
        String msg = "Create User Controller:Name=" + userSession.getUserName() + "-No=" + this.mUserNo;
        this.logUty.putlog("initialize", msg);
    }

    public void initializeForRegularBackup(SJbaseUserSessionInterface userSession) throws Exception {
        SJctrLogUty.info("SJctrUserController", "initializeForRegularBackup", "start");
        Object obj = SJcSingletonManagerUty.getInstance(SJctrControllerManager.class);
        if (!(obj instanceof SJctrControllerManager)) {
            SJctrLogUty.error("SJctrUserController", "initializeForRegularBackup", "obj = " + obj);
            throw new SJcException();
        }
        SJctrControllerManager mng = (SJctrControllerManager)obj;
        if (mng.getStatus().getPhase() != 2) {
            SJctrLogUty.error("SJctrUserController", "initializeForRegularBackup", "ControllerManager Phase: " + mng.getStatus().getPhase());
            throw new SJcException();
        }
        try {
            this.userSession = userSession;
            this.mUserNo = userIdManager.acquireId();
            this.logFunc = "ctr:" + this.mUserNo;
            SJctrLogUty logUty = this.createLogUty();
            logUty.setTitle(this.getClass().getSimpleName());
            this.setLogUty(logUty);
            this.useChildWindowDC = null;
            this.dataControllerMap = new HashMap<Integer, SJctrDataController>();
            this.mWizardList = new ArrayList<SJctrWizardWindowDC>();
            int UID_MAX = SJcEnvUty.getProperty2int("SN_UID_MAX", 100);
            this.uIdManager = new SJctrUniqueIdManager(UID_MAX);
            SJmoDataChange dataChange = null;
            SJmoModelMgr mgr = SJmoModelMgr.getModelMgr();
            this.modelAgent = mgr.getDataAgent();
            dataChange = mgr.getDataChange();
            this.utility = new SJctrComUtility(dataChange, userSession.getGuidanceInfo(), userSession.getMessageInfo());
            this.queueBox = new SJctrQueueBox(this);
            this.loadUserDataFile();
            this.lockId = -1L;
            this.ssoOpt = SJcSessionUty.getSsoOption(userSession);
            logUty.putlog("initializeForRegularBackup", "SsoOption=" + this.ssoOpt);
        }
        catch (Exception e) {
            this.logUty.putlog("initializeForRegularBackup", "Exception", e, 40000);
            throw e;
        }
        this.setProductName();
        String msg = "Create User Controller:Name=" + userSession.getUserName() + "-No=" + this.mUserNo;
        this.logUty.putlog("initializeForRegularBackup", msg);
    }

    public final SJctrComUtility getComUtility() {
        return this.utility;
    }

    public SJbaseUserSessionInterface getUserSession() {
        return this.userSession;
    }

    public int getUserNo() {
        return this.mUserNo;
    }

    public SJctrLogUty createLogUty() {
        SJctrLogUty logUtil = new SJctrLogUty();
        logUtil.setLogger(this.getUserSession().getLogger());
        logUtil.setFunc(this.logFunc);
        return logUtil;
    }

    public SJctrLogUty getLogUty() {
        return this.logUty;
    }

    public void setLogUty(SJctrLogUty logUty) {
        this.logUty = logUty;
    }

    public SJmoGetAgent getModelAgent() {
        return this.modelAgent;
    }

    public SJctrQueueBox getQueueBox() {
        return this.queueBox;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SJctrRequestDataObject post(SJctrRequestDataObject req) throws Exception {
        Long sTime = System.currentTimeMillis();
        Integer request = req.request();
        this.logUty.putlog("post", "request=0x" + SJctrComUtility.toHexString(request));
        try {
            switch (request) {
                case 0: {
                    SJctrRequestDataObject ret = this.requestPostDc(req);
                    this.restoreViewInfo(req, ret);
                    return ret;
                }
                case 0x1000000: {
                    this.saveViewInfo(req);
                    SJctrRequestDataObject ret = this.requestPostDc(req);
                    return ret;
                }
                case 256: {
                    SJctrRequestDataObject ret = this.requestGetRefreshProgress(req);
                    return ret;
                }
                case 0x1000001: {
                    SJctrRequestDataObject ret = this.requestSetRefreshAll(req);
                    return ret;
                }
                case 0x1000002: {
                    SJctrRequestDataObject ret = this.requestSetRefreshView(req);
                    return ret;
                }
                default: {
                    SJctrRequestDataObject ret = this.requestPostDc(req);
                    return ret;
                }
            }
        }
        catch (Exception e) {
            this.logUty.putlog("post", "fail", e, 20000);
            throw e;
        }
        finally {
            Long time = System.currentTimeMillis() - sTime;
            this.logUty.putlog("post", "end execute time(ms)=" + time);
        }
    }

    private SJctrRequestDataObject requestGetRefreshProgress(SJctrRequestDataObject request) throws Exception {
        int progress = 0;
        progress = this.modelAgent.getRefreshProg();
        this.getLogUty().putlog("requestGetRefreshProgress", "progress=" + progress);
        if (progress < 0 || SJctrRequestDataObject.PROGRESS_MAX < progress) {
            progress = SJctrRequestDataObject.PROGRESS_MAX;
        }
        SJctrRequestDataObject ret = progress != SJctrRequestDataObject.PROGRESS_MAX ? request.createDefualtResponse() : this.refresh(request);
        ret.refreshProgress(progress);
        return ret;
    }

    private SJctrRequestDataObject requestSetRefreshAll(SJctrRequestDataObject request) throws Exception {
        this.modelAgent.requestRefreshAll();
        return request.createDefualtResponse();
    }

    private SJctrRequestDataObject requestSetRefreshView(SJctrRequestDataObject request) throws Exception {
        this.modelAgent.requestRefreshView();
        return request.createDefualtResponse();
    }

    private SJctrRequestDataObject requestPostDc(SJctrRequestDataObject req) throws Exception {
        SJctrRequestDataObject ret;
        Integer uId = req.uId();
        SJctrDataController dc = this.getDataController(uId);
        this.logUty.putlog("requestPostDc", "DispID=0x" + SJctrComUtility.toHexString(req.dispId()) + ",UID=" + uId + ",DC:" + dc);
        if (dc != null) {
            this.setUseController(dc);
            ret = dc.post(req);
        } else {
            ret = req.createDefualtResponse();
        }
        return ret;
    }

    private SJctrRequestDataObject refresh(SJctrRequestDataObject request) {
        TreeMap<Integer, SJctrDataController> dcMap = new TreeMap<Integer, SJctrDataController>(this.dataControllerMap);
        Set<Map.Entry<Integer, SJctrDataController>> dcSet = dcMap.entrySet();
        this.getLogUty().putlog("refresh", "target:" + dcSet);
        ArrayList<SJctrRelatedDispDataObject> updateDisp = new ArrayList<SJctrRelatedDispDataObject>(dcSet.size());
        for (Map.Entry<Integer, SJctrDataController> entry : dcSet) {
            SJctrDataController dc = entry.getValue();
            dc.saveControlData();
            dc.clearData();
            updateDisp.add(this.getRelatedDispData(dc.getuId()));
        }
        SJctrRequestDataObject ret = request.createDefualtResponse();
        ret.update(updateDisp);
        this.refreshAuthorizeContainer();
        return ret;
    }

    private void setUseController(SJctrDataController dc) {
        if (dc == null || dc == this.useChildWindowDC || dc == this.useTabDC) {
            return;
        }
        SJctrDataController oldDC = null;
        if (this.isChildOfTopWindow(dc)) {
            oldDC = this.useChildWindowDC;
            this.useChildWindowDC = dc;
        } else if (SJctrDataController.isDispKind(dc.getDisplayId(), 0x100000)) {
            oldDC = this.useTabDC;
            this.useTabDC = dc;
        }
        if (oldDC != null) {
            this.removeRelatedDispData(oldDC.getuId());
        }
    }

    private SJctrDataController createDataController(Class<?> cls, int uid) {
        this.getLogUty().putlog("createDataController", "uId=" + uid + ",dc=" + cls);
        SJctrDataController dc = null;
        try {
            dc = (SJctrDataController)cls.newInstance();
            dc.setUId(uid);
            dc.initialize(this);
        }
        catch (Exception e) {
            String msg = "Can't create [" + (cls == null ? "null" : cls.getName()) + "]";
            this.logUty.putlog("createDataController", msg, e, 30000);
        }
        return dc;
    }

    public SJctrRelatedDispDataObject createRelatedDispData(Class<?> cls) {
        Integer uid = this.uIdManager.acquireId();
        int uIdCnt = this.uIdManager.getUseSize();
        this.getLogUty().putlog("createRelatedDispData", "uIdCnt=" + uIdCnt);
        SJctrDataController dc = this.createDataController(cls, uid);
        this.dataControllerMap.put(uid, dc);
        if (dc instanceof SJctrWizardWindowDC) {
            this.mWizardList.add((SJctrWizardWindowDC)dc);
        }
        SJctrRelatedDispDataObject relatedDispData = new SJctrRelatedDispDataObject();
        relatedDispData.dispId(dc.getDisplayId());
        relatedDispData.uId(uid);
        relatedDispData.status(0);
        return relatedDispData;
    }

    public SJctrRelatedDispDataObject getRelatedDispData(Class<?> cls) {
        SJctrRelatedDispDataObject relatedDispData = null;
        Collection<SJctrDataController> c = this.dataControllerMap.values();
        for (SJctrDataController dc : c) {
            if (!dc.getClass().equals(cls)) continue;
            relatedDispData = new SJctrRelatedDispDataObject();
            relatedDispData.dispId(dc.getDisplayId());
            relatedDispData.uId(dc.getuId());
            relatedDispData.status(1);
            break;
        }
        if (relatedDispData == null) {
            relatedDispData = this.createRelatedDispData(cls);
        }
        return relatedDispData;
    }

    public SJctrRelatedDispDataObject getRelatedDispData(Integer uid) {
        SJctrRelatedDispDataObject relatedDispData = null;
        SJctrDataController dc = this.getDataController(uid);
        if (dc != null) {
            relatedDispData = new SJctrRelatedDispDataObject();
            relatedDispData.dispId(dc.getDisplayId());
            relatedDispData.uId(dc.getuId());
            relatedDispData.status(1);
        }
        return relatedDispData;
    }

    public SJctrRelatedDispDataObject removeRelatedDispData(int uId) {
        SJctrRelatedDispDataObject relatedDispData = new SJctrRelatedDispDataObject();
        this.uIdManager.releaseId(uId);
        SJctrDataController dc = this.dataControllerMap.remove(uId);
        this.getLogUty().putlog("removeRelatedDispData", "uId=" + uId + ",dc=" + dc);
        if (dc != null) {
            relatedDispData.dispId(dc.getDisplayId());
            if (dc instanceof SJctrWizardWindowDC) {
                this.mWizardList.remove(dc);
            }
            try {
                dc.finish();
            }
            catch (Exception e) {
                this.getLogUty().putlog("removeRelatedDispData", "finish fail", e, 20000);
            }
        }
        relatedDispData.uId(uId);
        relatedDispData.status(2);
        return relatedDispData;
    }

    public SJctrDataController getDataController(Integer uId) {
        SJctrDataController dc = this.dataControllerMap.get(uId);
        return dc;
    }

    public SJctrDataController getDataController(SJctrRelatedDispDataObject relatedDisp) {
        Integer uId = null;
        if (relatedDisp != null) {
            uId = relatedDisp.uId();
        }
        return this.getDataController(uId);
    }

    @Override
    public void finish() {
        SJctrSystemParamContainer spc = this.authorizeContainer.getSystemParamContainer();
        if (!spc.isLocalHost() && --mClientCount == 0) {
            try {
                this.modelAgent.setRebootRestrainFlag(false);
            }
            catch (SJmoException e) {
                SJctrLogUty.warn(SJctrUserController.class.getSimpleName(), "finish", "Release SVP Reboot Restrain fail", e);
            }
        }
        ArrayList<SJctrWizardWindowDC> list = new ArrayList<SJctrWizardWindowDC>();
        list.addAll(this.mWizardList);
        for (SJctrWizardWindowDC dc : list) {
            dc.abort();
            this.removeRelatedDispData(dc.getuId());
        }
        ArrayList<SJctrDataController> dcList = new ArrayList<SJctrDataController>(this.dataControllerMap.values());
        for (SJctrDataController dc : dcList) {
            this.removeRelatedDispData(dc.getuId());
        }
        this.saveUserDataFile();
        this.modelAgent = null;
        this.authorizeContainer = null;
        userIdManager.releaseId(this.mUserNo);
        String msg = "Finish User Controller:Name=" + this.userSession.getUserName() + "-No=" + this.mUserNo;
        this.logUty.putlog("finish", msg);
    }

    boolean isChildOfTopWindow(SJctrDataController dc) {
        boolean result = false;
        if (dc.getDisplayId() != 0 && dc.isDispKind(0)) {
            result = true;
        }
        return result;
    }

    public HashMap<String, Object> getControlData(Integer displayId) {
        HashMap<String, Object> map;
        Object obj;
        if (this.mControlDataMap == null) {
            this.mControlDataMap = new HashMap();
        }
        if ((obj = this.mControlDataMap.get(displayId)) instanceof HashMap) {
            map = (HashMap<String, Object>)obj;
        } else {
            map = new HashMap<String, Object>();
            HashMap<String, Object> oldValue = this.mControlDataMap.put(displayId, map);
            this.getLogUty().putlog("getControlData", "map create:oldValue=" + oldValue);
        }
        return map;
    }

    public void putControlData(Integer displayId, HashMap<String, Object> data) {
        if (this.mControlDataMap == null) {
            this.mControlDataMap = new HashMap();
        }
        this.mControlDataMap.put(displayId, data);
    }

    void saveViewInfo(SJctrRequestDataObject req) {
        try {
            SJctrDataObject inputObject = (SJctrDataObject)req.getData("COM_TARGET");
            if (inputObject == null || !inputObject.containsKey(KEY_VIEWINFO)) {
                return;
            }
            Object viewInfo = inputObject.getData(KEY_VIEWINFO);
            HashMap<String, Object> controlData = this.getControlData(req.dispId());
            controlData.put(KEY_VIEWINFO, viewInfo);
            this.putControlData(req.dispId(), controlData);
        }
        catch (Exception e) {
            this.getLogUty().putlog("saveViewInfo", "fail", e, 20000);
        }
    }

    void restoreViewInfo(SJctrRequestDataObject req, SJctrRequestDataObject ret) {
        try {
            SJctrDataObject inputObject = (SJctrDataObject)req.getData("COM_TARGET");
            if (inputObject != null && !inputObject.containsKey(KEY_VIEWINFO)) {
                return;
            }
            SJctrDataObject target = new SJctrDataObject();
            target.getDataMap().putAll(ret.target().getDataMap());
            ret.target(target);
            HashMap<String, Object> controlData = this.getControlData(req.dispId());
            Object viewInfo = controlData.get(KEY_VIEWINFO);
            ret.target().setData(KEY_VIEWINFO, viewInfo);
        }
        catch (Exception e) {
            this.getLogUty().putlog("restoreViewInfo", "fail", e, 20000);
        }
    }

    public Properties getProperty() {
        return this.property;
    }

    public String getProperty(String key) {
        return this.property.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.property.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        return this.property.setProperty(key, value);
    }

    public SJctrAuthorizeContainer getAuthorizeContainer() {
        return this.authorizeContainer;
    }

    private void initAuthorizeContainer() {
        this.authorizeContainer = new SJctrAuthorizeContainer();
        this.authorizeContainer.setRoleResourceContainer(this.getRoleResourceContainer());
        this.authorizeContainer.setLisenceContainer(new SJctrLicenseContainer(this));
        this.authorizeContainer.setSystemParamContainer(new SJctrSystemParamContainer(this));
        this.printAuthorizationStatus();
    }

    private SJcRoleResourceContainer getRoleResourceContainer() {
        return this.getUserSession().getRoleResourceInfo();
    }

    private void refreshAuthorizeContainer() {
        SJctrAuthorizeContainer newAuthorizeContainer = new SJctrAuthorizeContainer();
        newAuthorizeContainer.setRoleResourceContainer(this.authorizeContainer.getRoleResourceContainer());
        newAuthorizeContainer.setLisenceContainer(new SJctrLicenseContainer(this));
        newAuthorizeContainer.setSystemParamContainer(new SJctrSystemParamContainer(this));
        this.authorizeContainer = newAuthorizeContainer;
        this.printAuthorizationStatus();
    }

    private void printAuthorizationStatus() {
        SJctrLogUty logger = this.getLogUty();
        SJcRoleResourceContainer roleResource = this.authorizeContainer.getRoleResourceContainer();
        logger.putlog("Role", roleResource.getAllAuthBit());
        SJctrLicenseContainer lisence = this.authorizeContainer.getLisenceContainer();
        HashMap<Integer, StringBuffer> ppMap = new HashMap<Integer, StringBuffer>();
        List<SJmoPPKget1PPInfo> licenseList = lisence.getLicenseInfoList();
        for (SJmoPPKget1PPInfo ppInfo : licenseList) {
            if (ppInfo == null) continue;
            String ppName = ppInfo.getStrPPName();
            int iStatus = ppInfo.getIStatus();
            if (ppMap.containsKey(iStatus)) {
                ((StringBuffer)ppMap.get(iStatus)).append("," + ppName);
                continue;
            }
            ppMap.put(iStatus, new StringBuffer(ppName));
        }
        Set ppSet = ppMap.entrySet();
        if (ppSet.size() == 0) {
            logger.putlog("License", "null");
        } else {
            for (Map.Entry set : ppSet) {
                logger.putlog("License", "Status " + set.getKey() + ":" + set.getValue());
            }
        }
    }

    private void loadUserDataFile() {
        SJbaseUserSessionInterface session = this.getUserSession();
        Serializable data = session.getUserProperty(USERSAVE);
        if (data instanceof HashMap) {
            this.mControlDataMap = (HashMap)data;
        } else {
            this.logUty.putlog("loadUserDataFile", "Warning", 30000);
        }
    }

    private Set<String> getUserDataKey() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(KEY_VIEWINFO);
        return keySet;
    }

    private void saveUserDataFile() {
        Set<String> saveKey = this.getUserDataKey();
        HashMap<Integer, HashMap<String, Object>> data = new HashMap<Integer, HashMap<String, Object>>();
        for (Map.Entry<Integer, Object> entry : this.mControlDataMap.entrySet()) {
            HashMap value = (HashMap)entry.getValue();
            value.put("CTRL_USER", saveKey);
            HashMap<String, Object> userData = this.createUserData(value);
            if (userData == null) continue;
            Integer key = entry.getKey();
            data.put(key, userData);
        }
        if (!data.isEmpty()) {
            SJbaseUserSessionInterface session = this.getUserSession();
            session.setUserProperty(USERSAVE, data);
        }
    }

    private HashMap<String, Object> createUserData(HashMap<String, Object> baseMap) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Set keySet = (Set)baseMap.get("CTRL_USER");
        if (keySet == null) {
            keySet = Collections.emptySet();
        }
        for (Map.Entry<String, Object> entry : baseMap.entrySet()) {
            HashMap childMap;
            HashMap<String, Object> data;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (keySet.contains(key)) {
                retMap.put(key, value);
                continue;
            }
            if (!(value instanceof HashMap) || (data = this.createUserData(childMap = (HashMap)value)) == null) continue;
            retMap.put(key, data);
        }
        if (retMap.isEmpty()) {
            retMap = null;
        }
        return retMap;
    }

    public boolean getResetViewSettings() {
        return this.flgResetViewSettings;
    }

    public void setResetViewSettings(boolean flg) {
        this.flgResetViewSettings = flg;
    }

    void resetDispInf() {
        if (!this.flgResetViewSettings) {
            return;
        }
        HashSet<String> keySet = new HashSet<String>();
        keySet.add(KEY_VIEWINFO);
        for (String string : SJctrTableDataModel.RESET_VIEW_SETTTING_KEY) {
            keySet.add(string);
        }
        for (Map.Entry entry : this.mControlDataMap.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            this.removeDispInfo((Map)entry.getValue(), keySet);
        }
    }

    void removeDispInfo(Map<String, Object> map, Set<String> keys) {
        Set<Map.Entry<String, Object>> entrys = map.entrySet();
        ArrayList<Map.Entry<String, Object>> removeList = new ArrayList<Map.Entry<String, Object>>(entrys.size());
        for (Map.Entry<String, Object> entry : entrys) {
            String entryKey = entry.getKey();
            Object entryObj = entry.getValue();
            if (keys.contains(entryKey)) {
                removeList.add(entry);
                continue;
            }
            if (!(entryObj instanceof Map)) continue;
            this.removeDispInfo((Map)entryObj, keys);
        }
        entrys.removeAll(removeList);
    }

    void resetUserProperty() {
        if (!this.flgResetViewSettings) {
            return;
        }
        for (String key : RESET_USER_PROPERTY_KEY) {
            boolean ret = this.getUserSession().resetUserProperty(key);
            if (ret) continue;
            this.getLogUty().putlog("resetUserProperty", "fail Key:" + key);
        }
    }

    public boolean updateLicenseInfo() {
        boolean ret = false;
        SJctrLicenseContainer newLicense = new SJctrLicenseContainer(this);
        SJctrLicenseContainer oldLicense = this.getAuthorizeContainer().getLisenceContainer();
        if (!newLicense.equalsPpEnable(oldLicense)) {
            this.refreshAuthorizeContainer();
            ret = true;
        }
        return ret;
    }

    public SJctrDirectLauncher getDirectLauncher() {
        return this.mDirectLauncher;
    }

    public void setLockId(long lockId) {
        this.lockId = lockId;
    }

    public long getLockId() {
        return this.lockId;
    }

    private void setProductName() {
        strHM800 = this.utility.getGuidance(GUID_HM800);
        strHM800H = this.utility.getGuidance(GUID_HM800H);
        strHM800M3 = this.utility.getGuidance(GUID_HM800M3);
        strHM800M2 = this.utility.getGuidance(GUID_HM800M2);
        strHM800S1 = this.utility.getGuidance(GUID_HM800S1);
        strHM800S0 = this.utility.getGuidance(GUID_HM800S0);
        strHM800H_AFA = this.utility.getGuidance(GUID_HM800H_AFA);
        strHM800M3_AFA = this.utility.getGuidance(GUID_HM800M3_AFA);
        strHM800M2_AFA = this.utility.getGuidance(GUID_HM800M2_AFA);
        strStogageSystemType = strHM800;
    }

    public String getProductName() {
        String ret = strStogageSystemType;
        int ver = SJsncProductModelUty.getProductModel();
        boolean upgrade = this.getAuthorizeContainer().getLisenceContainer().checkPP(SJctrLicenseContainer.PPID_MUL);
        boolean afa = this.getAuthorizeContainer().getLisenceContainer().checkPP(SJctrLicenseContainer.PPID_AFA);
        switch (ver) {
            case 20: {
                if (upgrade) {
                    ret = strHM800S1;
                    break;
                }
                ret = strHM800S0;
                break;
            }
            case 40: {
                if (upgrade) {
                    if (afa) {
                        ret = strHM800M3_AFA;
                        break;
                    }
                    ret = strHM800M3;
                    break;
                }
                if (afa) {
                    ret = strHM800M2_AFA;
                    break;
                }
                ret = strHM800M2;
                break;
            }
            case 60: {
                ret = afa ? strHM800H_AFA : strHM800H;
            }
        }
        return ret;
    }

    public int getSsoOpt() {
        return this.ssoOpt;
    }

    public void setSsoOpt(int option) {
        this.ssoOpt = option;
    }

    static {
        int USER_ID = SJcEnvUty.getProperty2int("SN_SESSION_SYSTEM_MAX", 33);
        userIdManager = new SJctrUniqueIdManager(USER_ID);
        mClientCount = 0;
        RESET_USER_PROPERTY_KEY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SN_LUN_ID_DEC")));
        strHM800 = "VSP Gx00 and VSP Fx00";
        strHM800H = "VSP G800";
        strHM800M3 = "VSP G600";
        strHM800M2 = "VSP G400";
        strHM800S1 = "VSP G200";
        strHM800S0 = "VSP G100";
        strHM800H_AFA = "VSP F800";
        strHM800M3_AFA = "VSP F600";
        strHM800M2_AFA = "VSP F400";
        strStogageSystemType = strHM800;
    }
}

