/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrPoolCurrentCapacityColumnFromPoolDetail
extends SJctrCapacityColumn {
    public SJctrPoolCurrentCapacityColumnFromPoolDetail(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("USED_PERCENT"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> alList = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        alList.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        return alList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "";
        if (null != dataList && 0 != dataList.size()) {
            Object obj = dataList.get(0);
            if (obj instanceof SJmoPoolDetail) {
                SJmoPoolDetail poolDtl = (SJmoPoolDetail)obj;
                SJctrComUtility comUtl = this.getTable().getComUtility();
                SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
                String strClmUnit = this.getTable().getUnitMenu();
                strRtn = poolUtl.toCurrentPoolCapacity(poolDtl, comUtl, strClmUnit);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is class error");
                strRtn = "?";
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "toDispString", "dataList is null or size 0");
            strRtn = "?";
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long lCrntPoolCapa;
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)this.getPrimaryKeyObject(dat);
        SJctrComUtility comUtl = this.getTable().getComUtility();
        SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
        String strClmUnit = this.getTable().getUnitMenu();
        String strCrntPoolCapa = poolUtl.toCurrentPoolCapacity(poolDtl, comUtl, strClmUnit);
        try {
            lCrntPoolCapa = Long.parseLong(strCrntPoolCapa);
        }
        catch (NumberFormatException e) {
            lCrntPoolCapa = -2L;
        }
        return lCrntPoolCapa;
    }
}

