/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.iscsi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;

public class SJctrChapUsedColumnFromPortDetail
extends SJctrColumn {
    private String strYes = "?";
    private String strNo = "?";

    public SJctrChapUsedColumnFromPortDetail(String key) {
        super(key);
        this.setPartsId("USED");
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.strYes = util.getGuidance("YES");
        this.strNo = util.getGuidance("NO");
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortIscsiTargetPathInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPortDetail> retList = new ArrayList<SJmoPortDetail>();
        SJmoPortDetail portDetail = (SJmoPortDetail)index;
        if (!SJctrPortUtility.isIscsiPort(portDetail)) {
            retList.add(portDetail);
            return retList;
        }
        List<?> portIscsiTargetPath = modelData.get(SJmoGetPortIscsiTargetPathInfo.class);
        int portIndex = Collections.binarySearch(portIscsiTargetPath, portDetail);
        if (portIndex > -1) {
            retList.add((SJmoPortDetail)portIscsiTargetPath.get(portIndex));
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = this.strNo;
        if (dataList == null || dataList.size() == 0) {
            return ret;
        }
        Object modelData = dataList.get(0);
        if (modelData instanceof SJmoPortIscsiTargetPathInfo) {
            SJmoPortIscsiTargetPathInfo ptIscsiTarPath = (SJmoPortIscsiTargetPathInfo)modelData;
            for (SJmoIscsiTargetPathInfo iscsiTarPath : ptIscsiTarPath.getAlPortIscsiTargetPath()) {
                if (iscsiTarPath.getIAuthentSwitch() != 1) continue;
                ret = this.strYes;
                break;
            }
        } else {
            ret = "-";
        }
        return ret;
    }
}

