/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.iscsi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;

public class SJctrNumberOfLunsColumnFromIscsiTargetInfo
extends SJctrColumn {
    public static final int ISCSI_DATA_INDEX = 0;
    public static final int PORT_LUN_LIST_INDEX = 1;

    public SJctrNumberOfLunsColumnFromIscsiTargetInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("NUM_OF_LUN"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>(1);
        list.add(SJmoGetPortLunInfo.class);
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPortIndex> retList = new ArrayList<SJmoPortIndex>();
        SJmoIscsiTargetInfo iscsiInfo = (SJmoIscsiTargetInfo)index;
        List<?> portLunInfoList = modelData.get(SJmoGetPortLunInfo.class);
        for (SJmoPortLunInfo ptLun : portLunInfoList) {
            if (iscsiInfo.getSPort() != ptLun.getSPort()) continue;
            retList.add(iscsiInfo);
            retList.add(ptLun);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList.size() == 0) {
            ret = String.valueOf(0);
        } else {
            SJmoIscsiTargetInfo iscsiInfo = (SJmoIscsiTargetInfo)dataList.get(0);
            SJmoPortLunInfo lunInfo = (SJmoPortLunInfo)dataList.get(1);
            ret = String.valueOf(lunInfo.getAlHostGroupLun(iscsiInfo.getSIscsiTarget()).size());
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        String strNumber = (String)dat.get(this.getMyKey());
        long retNum = Long.valueOf(strNumber);
        return retNum;
    }
}

