/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.license;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.controller.com.SJctrPPLicenseUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLicenseDetail;
import sanproject.sn2.model.data.system.SJmoPPKget1PPInfo;

public class SJctrLicenseUsedCapacityColumnFromPPKget1PPInfo
extends SJctrColumn {
    public SJctrLicenseUsedCapacityColumnFromPPKget1PPInfo(String key) {
        super(key);
        this.setPartsId("USED_TB");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetLicenseDetail.class);
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        return "^\\d{1,19}(\\.\\d{1,2})?$";
    }

    @Override
    protected long getInputValueNumber(List<String> list, String regex) {
        long resultValue = 0L;
        String decimalStr = list.get(0);
        Matcher matcher = Pattern.compile(regex).matcher(decimalStr);
        if (matcher.matches()) {
            BigDecimal baseDecimal = new BigDecimal(100);
            BigDecimal decimal = new BigDecimal(decimalStr);
            decimal = decimal.multiply(baseDecimal);
            BigDecimal max = new BigDecimal(Long.MAX_VALUE);
            BigDecimal value = max.min(decimal);
            resultValue = value.longValue();
        } else {
            this.getTable().getLogUty().putlog("getInputValueNumber", "Filter data: " + decimalStr, 30000);
        }
        return resultValue;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        SJmoPPKget1PPInfo ppInfo = (SJmoPPKget1PPInfo)this.getPrimaryKeyObject(dat);
        return SJctrPPLicenseUtility.getUsedCapaciryValue(ppInfo);
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrPPLicenseUtility ppUtil = this.getTable().getComUtility().getPPLicenseUtility();
        SJmoPPKget1PPInfo ppInfo = (SJmoPPKget1PPInfo)dataList.get(0);
        return ppUtil.getUsedCapaciryDisplay(ppInfo);
    }
}

