/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.replication.remote.SJmoTrueCopyPairVolInfo;

public class SJctrCopyPaceColumnFromReplicaTcPairVolInfo
extends SJctrColumn {
    public SJctrCopyPaceColumnFromReplicaTcPairVolInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("COPY_PACE"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public long getNumber(Map<String, Object> dat) {
        SJmoTrueCopyPairVolInfo tblData = (SJmoTrueCopyPairVolInfo)this.getPrimaryKeyObject(dat);
        long number = -1L;
        if (tblData != null && SJctrRemoteReplicationUtility.isSvol(tblData)) {
            int track = tblData.getITracks();
            if (SJctrRemoteReplicationUtility.isOpen(tblData)) {
                if (129 <= track && track <= 143) {
                    number = track &= 0xFFFFFF7F;
                }
            } else if (SJctrRemoteReplicationUtility.isMainframe(tblData) && 0 <= track && track <= 255) {
                number = track == 1 ? Long.valueOf("3").longValue() : Long.valueOf("15").longValue();
            }
        }
        return number;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoTrueCopyPairVolInfo pairInfo = (SJmoTrueCopyPairVolInfo)dataList.get(0);
        SJctrRemoteReplicationUtility repUty = this.getTable().getComUtility().getRemoteReplicationUtility();
        return repUty.getCopyPaceString(pairInfo);
    }
}

