/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;

public class SJctrCtgIdColumnFromHaPairVolInfo
extends SJctrColumn {
    public SJctrCtgIdColumnFromHaPairVolInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("CTG_ID"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public long getNumber(Map<String, Object> dat) {
        SJmoHAPairVolInfo tblData = (SJmoHAPairVolInfo)this.getPrimaryKeyObject(dat);
        long ctgID = -1L;
        if (tblData != null) {
            SJctrHaUtility haUtil = this.getTable().getComUtility().getHaUtility();
            ctgID = SJctrHaUtility.getCtgIdNumber(tblData);
        }
        return ctgID;
    }

    @Override
    public String getInputFormat() {
        return "^([0-9A-Fa-f]{1,3})$";
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList != null && dataList.size() != 0) {
            SJmoHAPairVolInfo pairInfo = (SJmoHAPairVolInfo)dataList.get(0);
            SJctrHaUtility haUty = this.getTable().getComUtility().getHaUtility();
            ret = haUty.getCtgIdString(pairInfo);
        }
        return ret;
    }
}

