/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetLDEVLUPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrPVolLUNIDColumnFromPairVolInfo
extends SJctrColumn {
    protected Map<Integer, List<SJmoPortLunDetail>> ldevLUPathInfoMap = null;
    private boolean bDecDisplay = false;
    protected final short LUNPATH_NOTHING = (short)-2;

    public SJctrPVolLUNIDColumnFromPairVolInfo(String key) {
        super(key);
        this.setPartsId("LUN_ID");
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrUserController uc = this.getTable().getDataController().getOwner();
        this.bDecDisplay = SJctrPortUtility.isLunIdDecimal(uc.getUserSession());
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoPortLunDetail> retList = new ArrayList<SJmoPortLunDetail>();
        SJmoLocalReplicationPairVolInfo pairVolInfo = (SJmoLocalReplicationPairVolInfo)index;
        if (pairVolInfo.isVolPos(256)) {
            return retList;
        }
        this.ldevLUPathInfoMap = (Map)modelData.get(SJctrGetLDEVLUPathInfo.class).get(0);
        SJmoLdevIndex pVolIndex = pairVolInfo.getPVolIndex();
        if (pVolIndex != null) {
            List<SJmoPortLunDetail> portLunDtlList = this.ldevLUPathInfoMap.get(SJctrReplicationUtility.getLdevIndexKey(pVolIndex));
            if (portLunDtlList != null) {
                SJmoPortLunDetail portLunDtl = portLunDtlList.get(0);
                retList.add(portLunDtl);
            } else {
                SJmoPortLunDetail portLunDtl = new SJmoPortLunDetail();
                portLunDtl.setSLUN((short)-2);
                retList.add(portLunDtl);
            }
        }
        return retList;
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        String ret = "^([0-9A-Fa-f]{1,4})$";
        if (this.bDecDisplay) {
            ret = "^\\d{1,19}$";
        }
        return ret;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "-";
        if (!dataList.isEmpty()) {
            SJmoPortLunDetail portLunDtl = (SJmoPortLunDetail)dataList.get(0);
            ret = portLunDtl != null ? (portLunDtl.getSLUN() == -2 ? "" : (this.bDecDisplay ? SJctrComUtility.toDecString(portLunDtl.getSLUN()) : SJctrComUtility.toHexString(portLunDtl.getSLUN(), 4, true))) : "?";
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int lun = -1;
        SJmoLocalReplicationPairVolInfo primaryKeyObj = (SJmoLocalReplicationPairVolInfo)this.getPrimaryKeyObject(dat);
        if (primaryKeyObj.isVolPos(256)) {
            return lun;
        }
        SJmoLdevIndex pVolIndex = primaryKeyObj.getPVolIndex();
        if (pVolIndex != null) {
            List<SJmoPortLunDetail> portLunDtlList = this.ldevLUPathInfoMap.get(SJctrReplicationUtility.getLdevIndexKey(pVolIndex));
            if (portLunDtlList != null && !portLunDtlList.isEmpty()) {
                SJmoPortLunDetail luPathInfo = portLunDtlList.get(0);
                lun = luPathInfo.getSLUN();
            } else {
                lun = -2;
            }
        }
        return lun;
    }
}

