/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdProfileInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExdProfileInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdProfileInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;

public class SJctrProfilePathModeColumnFromExdVolumeInfo
extends SJctrColumn {
    public SJctrProfilePathModeColumnFromExdVolumeInfo(String key) {
        super(key);
        this.setPartsId("PROFILE_PATH_MODE");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetExdVolumeInfoMgr.class);
        list.add(SJmoGetExdSubsystemInfoMgr.class);
        list.add(SJmoGetExdProfileInfoMgr.class);
        return list;
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoExdProfileInfo> list = new ArrayList<SJmoExdProfileInfo>();
        SJmoExdVolumeInfo volumeInfo = (SJmoExdVolumeInfo)index;
        int subSystemID = volumeInfo.getRmiExdVolumeInfo().getExternalDeviceInfo().referSubsystemID();
        SJmoExdSubsystemInfoMgr subSystemMgr = (SJmoExdSubsystemInfoMgr)modelData.get(SJmoGetExdSubsystemInfoMgr.class).get(0);
        SJmoExdSubsystemInfo subSystemInfo = subSystemMgr.getExdSubsystemInfo(subSystemID);
        if (subSystemInfo != null) {
            int profileID = subSystemInfo.getRmiExdSubsystemInfo().referProfileId();
            SJmoExdProfileInfoMgr profileInfoMgr = (SJmoExdProfileInfoMgr)modelData.get(SJmoGetExdProfileInfoMgr.class).get(0);
            SJmoExdProfileInfo profileInfo = profileInfoMgr.getExdProfileInfo(profileID);
            if (profileInfo != null) {
                list.add(profileInfo);
            }
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoExdProfileInfo profile;
        String ret = "?";
        if (!dataList.isEmpty() && (profile = (SJmoExdProfileInfo)dataList.get(0)) != null) {
            SJctrExtUtility util = this.getTable().getComUtility().getExtUtility();
            byte pathMode = profile.getRmiExdProfileInfo().getPathMode();
            ret = util.toPathModeDisplay(pathMode);
        }
        return ret;
    }
}

