/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.util.BitSet;
import java.util.List;
import sanproject.serverux.dataimpl.BASEgetDkcLockList;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlElemCon;
import sanproject.sn2.com.utility.Logger.SJcAuditLogElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrOperationLockStatus;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockSummaryModel;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockTableKey;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockTableModel;
import sanproject.sn2.controller.topwindow.base.SJctrUnlockAllAuditLog;
import sanproject.sn2.controller.topwindow.base.SJctrUnlockAuditLog;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrResourceLockDC
extends SJctrDialogDataController {
    public static final int DISP_ID = 34664470;
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_UNLOCKBTN = "COM_UNLOCKBTN";
    public static final String KEY_FOOTER = "COM_FOOTER";
    private static final int MSG_FUNCTION_COMMON = 201;
    private static final int MSG_MODULE_CONTROLLER = 22;
    private static final int MSG_UNLOCK_RSG_CONTAINS = 105305;
    private static final String MSG_FUNCTION_COMMON_STR = "201";
    private static final String MSG_MODULE_CONTROLLER_STR = "22";
    private static final String MSG_UNLOCK_CHECK_STR = "109022";
    private static final int BITSET_SIZE = 1024;
    private static final int BITSET_FROM = 0;
    private SJctrButtonDataModel unLockButtonModel = null;
    private SJctrOperationLockStatus operationLockStatus = null;
    private SJmoRSGgetAllRsgs rsgData = null;
    private BASEgetDkcLockList[] dkcLockList = null;

    public SJctrResourceLockDC() throws SJcException {
        super(34664470);
        this.initDataModel();
    }

    public void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrResourceLockSummaryModel());
        this.addDataObjectModel(KEY_TABLE, new SJctrResourceLockTableModel());
        this.unLockButtonModel = new SJctrButtonDataModel();
        this.unLockButtonModel.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrResourceLockDC.this.unlockAllAction();
            }
        });
        this.addDataObjectModel(KEY_UNLOCKBTN, this.unLockButtonModel);
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void unlockCheck() {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("unlockAction", "not selected");
            return;
        }
        this.dkcLockList = new BASEgetDkcLockList[selectedRowList.size()];
        int ctrLock = 0;
        for (Object selectRow : selectedRowList) {
            SJctrResourceLockTableKey tableKey = (SJctrResourceLockTableKey)selectRow;
            BASEgetDkcLockList lockInfo = tableKey.getLockInfo();
            if (lockInfo == null) {
                this.getLogUty().putlog("unlockAction", "Unlock selected");
                SJctrError err = new SJctrError(201, 22, 105305);
                SJcException exp = err.createException();
                throw exp;
            }
            this.dkcLockList[ctrLock++] = lockInfo;
        }
        SJctrRelatedDispDataObject unlockRelated = this.createUnlockMsg();
        this.addUpdateDisp(unlockRelated);
    }

    private SJctrRelatedDispDataObject createUnlockMsg() {
        SJctrUserController uc = this.getOwner();
        SJcMessage msg = new SJcMessage(MSG_FUNCTION_COMMON_STR, MSG_MODULE_CONTROLLER_STR, MSG_UNLOCK_CHECK_STR);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrResourceLockDC.this.unlockAction();
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        return related;
    }

    private void unlockAction() {
        SJcMessage auditMsg = null;
        String auditResult = "Success";
        try {
            if (this.dkcLockList == null || this.dkcLockList.length == 0) {
                this.getLogUty().putlog("unlockAction", "unLock ");
            } else {
                this.forcetoUnlock(this.dkcLockList);
            }
        }
        catch (SJcException e) {
            auditMsg = e.getMsg();
            auditResult = "Error";
            throw e;
        }
        finally {
            this.outPutAuditLog(auditMsg, auditResult, this.dkcLockList);
        }
        SJctrDataObjectModel<? extends SJctrDataObject> tabledata = this.getDataObjectModel(KEY_TABLE);
        ((SJctrResourceLockTableModel)tabledata).doRefresh();
        ((SJctrResourceLockTableModel)tabledata).setVScrollReset(true);
        tabledata.setDirty();
        SJctrDataObjectModel<? extends SJctrDataObject> summarydata = this.getDataObjectModel(KEY_SUMMARY);
        summarydata.setDirty();
    }

    private void unlockAllAction() {
        SJcMessage auditMsg = null;
        String auditResult = "Success";
        try {
            this.forcetoUnlockAll();
        }
        catch (SJcException e) {
            try {
                auditMsg = e.getMsg();
                auditResult = "Error";
                throw e;
            }
            catch (Throwable throwable) {
                this.outPutAuditLogBase(auditMsg, auditResult);
                throw throwable;
            }
        }
        this.outPutAuditLogBase(auditMsg, auditResult);
        SJctrDataObjectModel<? extends SJctrDataObject> tabledata = this.getDataObjectModel(KEY_TABLE);
        ((SJctrResourceLockTableModel)tabledata).doRefresh();
        ((SJctrResourceLockTableModel)tabledata).setVScrollReset(true);
        tabledata.setDirty();
        SJctrDataObjectModel<? extends SJctrDataObject> summarydata = this.getDataObjectModel(KEY_SUMMARY);
        summarydata.setDirty();
    }

    public boolean getAuthority(int statusDkcLock) {
        boolean ret = false;
        SJctrUserController uc = this.getOwner();
        SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
        SJcRoleResourceContainer rr = ac.getRoleResourceContainer();
        SJctrLicenseContainer lc = ac.getLisenceContainer();
        SJctrSystemParamContainer spc = ac.getSystemParamContainer();
        ret = rr.checkAuthority(32);
        ret = ret && rr.checkAuthority(42);
        boolean host = spc.isLocalHost();
        if (!host) {
            ret = ret && lc.checkPP(SJctrLicenseContainer.PPID_SN);
        }
        ret = ret && rr.checkAllResourceGroup();
        return ret;
    }

    private void forcetoUnlock(BASEgetDkcLockList[] lockList) {
        BitSet releseSet = new BitSet();
        for (BASEgetDkcLockList dkcLockList : lockList) {
            releseSet.set(dkcLockList.getIResourceId());
        }
        SJmoGetAgent moAgent = this.getOwner().getModelAgent();
    }

    private void forcetoUnlockAll() {
        BitSet releseSet = new BitSet(1024);
        releseSet.set(0, 1024);
        SJmoGetAgent moAgent = this.getOwner().getModelAgent();
        SJctrUserController uc = this.getOwner();
        SJbaseUserSessionInterface us = uc.getUserSession();
        String userId = us.getUserName();
        String pass = ((SJbaseUserSessionInterfaceInternal)us).getPassword();
        int ssoOpt = uc.getSsoOpt();
        moAgent.forceReleaseSystemAndResourceLock(userId, pass, ssoOpt);
    }

    private void outPutAuditLog(SJcMessage auditMsg, String auditResult, BASEgetDkcLockList[] dkcLockList) {
        SJctrUserController userCtr = this.getOwner();
        SJctrUnlockAuditLog auditLog = new SJctrUnlockAuditLog(userCtr);
        SJcAuditLogCtrlElemCon container = auditLog.createElemCon();
        container.setOperationResult(auditResult);
        container.setOperationErrorCode(auditMsg);
        for (BASEgetDkcLockList dkcLock : dkcLockList) {
            String strId = Integer.toString(dkcLock.iResourceId);
            SJctrAuditLogData element = auditLog.createElement(strId);
            container.setAdtDetailList(element);
        }
        SJcAuditLoggerInterface adtLogger = userCtr.getUserSession().getAuditLogger();
        if (adtLogger != null) {
            adtLogger.putLog(container);
        } else {
            this.getLogUty().putlog("outAuditlog", "AuditLogger is null.");
        }
    }

    private void outPutAuditLogBase(SJcMessage auditMsg, String auditResult) {
        SJctrUserController userCtr = this.getOwner();
        SJctrUnlockAllAuditLog auditLog = new SJctrUnlockAllAuditLog(userCtr);
        SJcAuditLogElemCon container = auditLog.createElemCon();
        container.setOperationResult(auditResult);
        container.setOperationErrorCode(auditMsg);
        SJcAuditLoggerInterface adtLogger = userCtr.getUserSession().getAuditLogger();
        if (adtLogger != null) {
            adtLogger.putLog(container);
        } else {
            this.getLogUty().putlog("outAuditlog", "AuditLogger is null.");
        }
    }

    public SJctrButtonDataModel getUnLockButtonModel() {
        return this.unLockButtonModel;
    }

    public SJctrOperationLockStatus getOperationLockStatus() {
        return this.operationLockStatus;
    }

    public void setOperationLockStatus(SJctrOperationLockStatus operationLockStatus) {
        this.operationLockStatus = operationLockStatus;
    }

    public SJmoRSGgetAllRsgs getRsgData() {
        return this.rsgData;
    }

    public void setRsgData(SJmoRSGgetAllRsgs rsgData) {
        this.rsgData = rsgData;
    }
}

