/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.comdialog.lundetail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.comdialog.lundetail.SJctrLunInfoPropertyDC;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLuPathLdevIndex;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevUuidInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetThinProvisioningVolumesStatus;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevUuidInfo;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;

public class SJctrLunInfoPropertySummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_LUN = "COM_LUN";
    public static final String KEY_LDEV = "COM_LDEV";
    public static final String KEY_LDEV_NAME = "COM_LDEV_NAME";
    public static final String KEY_UUID = "COM_UUID";
    public static final String KEY_HG_NAME = "COM_HG_NAME";
    public static final String KEY_HOSTMODE = "COM_HOSTMODE";
    public static final String KEY_HOSTMODE_OP = "COM_HOSTMODE_OP";
    public static final String KEY_PT_NAME = "COM_PT_NAME";
    public static final String KEY_CAP = "COM_CAP";
    public static final String KEY_EMU = "COM_EMU";
    public static final String KEY_CLPR = "COM_CLPR";
    public static final String KEY_VT = "COM_VT";
    public static final String KEY_LDEVATTR = "COM_LDEVATTR";
    public static final String KEY_ENCRYPTION = "COM_ENCRYPTION";
    public static final String KEY_ALUAUSED = "COM_ALUA_MODE";
    public static final String KEY_ALUASTATE = "COM_ASYM_STATE";
    public static final String KEY_T10PI = "COM_T10PI";
    public static final String KEY_DATA_DIRECT_MAP_LDEV = "COM_DATA_DIRECT_MAP_LDEV";
    public static final String KEY_CAPACITY_SAVING = "COM_CAPACITY_SAVING";
    public static final String KEY_CAPACITY_SAVING_STATUS = "COM_CAPACITY_SAVING_STATUS";
    public static final String KEY_DEDUPLICATION_DATA = "COM_DEDUPLICATION_DATA";
    public static final String KEY_VSS_MDL_SN = "COM_VSS_MDL_SN";
    public static final String KEY_VSS_LDEVID = "COM_VSS_LDEVID";
    public static final String KEY_VSS_DEVNAME = "COM_VSS_DEVNAME";
    public static final String KEY_VSS_SSID = "COM_VSS_SSID";
    public static final String KEY_VSS_LDEVATTR = "COM_VSS_LDEVATTR";
    public static final String KEY_CMDDEVSEC = "COM_CMDDEVSEC";
    public static final String KEY_CMDDEVUSER = "COM_CMDDEVUSER";
    public static final String KEY_CMDDEVDEVGP = "COM_CMDDEVDEVGP";
    public static final String KEY_PATHNUM = "COM_PATHNUM";
    public static final String KEY_ACCATTR = "COM_ACC_ATTR";
    private SJctrComUtility comUtil = null;
    private SJctrLdevUtility ldevUtil = null;
    private SJctrPortUtility portUtil = null;
    private SJctrCapacityUtility capUtil = null;
    private SJctrPoolUtility poolUtil = null;
    private SJctrRsgUtility rsgUtil = null;
    public static final String KEY_COL_HOSTMODE = "COM_COL_HOSTMODE";
    public static final String KEY_HGN_ITA = "COM_HGN_ITA";
    public static final String KEY_ISCSI_TARGET_NAME = "COM_ISCSI_TARGET_NAME";
    public static final String KEY_PTTYPE = "COM_PTTYPE";

    @Override
    public void makeDataObject() {
        SJmoHUVMvboxIndex targetDkc;
        int vDkcIndex;
        int vLdevIndex;
        ArrayList<Object> summaryList = new ArrayList<Object>();
        List<SJmoGetLdevDetail> ldevDetailList = this.getBasicDataList(SJmoGetLdevDetail.class);
        List<SJmoGetLdevLuseInfo> luseInfoList = this.getBasicDataList(SJmoGetLdevLuseInfo.class);
        SJmoLdevDetail ldevDetailSummary = this.getLdevDetailSummary(ldevDetailList);
        SJctrLdevDetailLUSEInfo ldevDtlLuseSummary = SJctrLdevUtility.getLdevDetailLUListSEInfo(ldevDetailSummary, ldevDetailList, luseInfoList);
        summaryList.add(ldevDtlLuseSummary);
        List<SJmoGetPortLunInfo> ptLunList = this.getBasicDataList(SJmoGetPortLunInfo.class);
        summaryList.add(this.getPortLunSummary(ptLunList));
        List<SJmoGetPortHostGroupInfo> ptHgInfoList = this.getBasicDataList(SJmoGetPortHostGroupInfo.class);
        summaryList.add(this.getPortHostGroupInfoSummary(ptHgInfoList));
        List<SJmoGetPortDetail> ptDetail = this.getBasicDataList(SJmoGetPortDetail.class);
        summaryList.add(this.getPortDetailSummary(ptDetail));
        List<SJmoGetClprInfo> ClprInfoList = this.getBasicDataList(SJmoGetClprInfo.class);
        SJmoClprIndex clprIndex = new SJmoClprIndex();
        clprIndex.setSClpr(ldevDetailSummary.getSCLPR());
        int index = Collections.binarySearch(ClprInfoList, clprIndex);
        SJmoClprInfo clprInfo = null;
        if (index >= 0) {
            clprInfo = (SJmoClprInfo)((Object)ClprInfoList.get(index));
        }
        summaryList.add(clprInfo);
        List<SJmoGetLdevUuidInfo> ldevUuidList = this.getBasicDataList(SJmoGetLdevUuidInfo.class);
        summaryList.add(this.getLdevUuidInfoSummary(ldevUuidList));
        List<SJmoGetLdevNicknameInfo> ldevNicknameList = this.getBasicDataList(SJmoGetLdevNicknameInfo.class);
        summaryList.add(this.getLdevNicknameInfoSummary(ldevNicknameList));
        List<SJmoGetLdevGuardInfo> ldevGrdList = this.getBasicDataList(SJmoGetLdevGuardInfo.class);
        summaryList.add(this.getLdevGrdInfoSummary(ldevGrdList));
        List<SJmoGetHUVMVirtualLdev> huvmVLdev = this.getBasicDataList(SJmoGetHUVMVirtualLdev.class);
        SJmoHUVMVirtualLdev vLdev = null;
        if (huvmVLdev != null && (vLdevIndex = Collections.binarySearch(huvmVLdev, ldevDetailSummary)) >= 0) {
            vLdev = (SJmoHUVMVirtualLdev)((Object)huvmVLdev.get(vLdevIndex));
        }
        summaryList.add(vLdev);
        SJmoHUVMVirtualDkc vDkc = null;
        List<SJmoGetHUVMVirtualDkc> allDkcInfo = this.getBasicDataList(SJmoGetHUVMVirtualDkc.class);
        if (vLdev != null && (vDkcIndex = Collections.binarySearch(allDkcInfo, targetDkc = vLdev.getVBoxIndex())) >= 0) {
            vDkc = (SJmoHUVMVirtualDkc)((Object)allDkcInfo.get(vDkcIndex));
        }
        summaryList.add(vDkc);
        List<SJmoGetPortIscsiTargetInfo> itPtInfoList = this.getBasicDataList(SJmoGetPortIscsiTargetInfo.class);
        summaryList.add(this.getIscsiTargetInfoSummary(itPtInfoList));
        summaryList.add(this.getLdevDetailSummary(ldevDetailList));
        List<SJmoGetHDPRelation> hdpRelationList = this.getBasicDataList(SJmoGetHDPRelation.class);
        summaryList.add(this.getLDEVDetailInfoSummary(ldevDetailSummary, hdpRelationList));
        List<SJmoGetThinProvisioningVolumesStatus> thinProVolStatus = this.getBasicDataList(SJmoGetThinProvisioningVolumesStatus.class);
        summaryList.add(thinProVolStatus);
        this.makeSummary(summaryList);
    }

    public SJmoLdevDetail getLdevDetailSummary(List<SJmoLdevDetail> ldevDetailList) {
        SJmoLdevDetail ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoLdevIndex selectLdevIndex = new SJmoLdevIndex();
            selectLdevIndex.setLdevIndex(selectData.getLdkc(), selectData.getCu(), selectData.getLdev());
            Object[] data = ldevDetailList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectLdevIndex);
            if (index >= 0) {
                ret = (SJmoLdevDetail)data[index];
            }
        }
        return ret;
    }

    public SJmoPortLunDetail getPortLunSummary(List<SJmoPortLunInfo> ptLunInfoList) {
        SJmoPortLunDetail ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoPortIndex selectPortIndex = new SJmoPortIndex();
            selectPortIndex.setSPort(selectData.getPort());
            short selectHostGroup = selectData.getHostGroup();
            short selectLun = selectData.getLun();
            Object[] data = ptLunInfoList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectPortIndex);
            if (index >= 0) {
                SJmoPortLunInfo ptLunInfo = (SJmoPortLunInfo)data[index];
                ArrayList ptLunDetailList = ptLunInfo.getAlHostGroupLun(selectHostGroup);
                for (SJmoPortLunDetail ptLunDetail : ptLunDetailList) {
                    if (ptLunDetail.getSLUN() != selectLun) continue;
                    ret = ptLunDetail;
                    break;
                }
            }
        }
        return ret;
    }

    public SJmoHostGroupInfo getPortHostGroupInfoSummary(List<SJmoPortHostGroupInfo> ptHgInfoList) {
        SJmoHostGroupInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoPortIndex selectPortIndex = new SJmoPortIndex();
            selectPortIndex.setSPort(selectData.getPort());
            short selectHostGroup = selectData.getHostGroup();
            Object[] data = ptHgInfoList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectPortIndex);
            if (index >= 0) {
                SJmoPortHostGroupInfo ptHgInfo = (SJmoPortHostGroupInfo)data[index];
                ArrayList hgInfolList = ptHgInfo.getAlPortHostGroup();
                for (SJmoHostGroupInfo hgInfo : hgInfolList) {
                    if (hgInfo.getSHostGroup() != selectHostGroup) continue;
                    ret = hgInfo;
                    break;
                }
            }
        }
        return ret;
    }

    public SJmoPortDetail getPortDetailSummary(List<SJmoPortDetail> ptDetailList) {
        SJmoPortDetail ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoPortIndex selectPortIndex = new SJmoPortIndex();
            selectPortIndex.setSPort(selectData.getPort());
            Object[] data = ptDetailList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectPortIndex);
            if (index >= 0) {
                ret = (SJmoPortDetail)data[index];
            }
        }
        return ret;
    }

    public SJmoLdevUuidInfo getLdevUuidInfoSummary(List<SJmoLdevUuidInfo> ldevUuidList) {
        SJmoLdevUuidInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoLdevIndex selectLdevIndex = new SJmoLdevIndex();
            selectLdevIndex.setLdevIndex(selectData.getLdkc(), selectData.getCu(), selectData.getLdev());
            Object[] data = ldevUuidList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectLdevIndex);
            if (index >= 0) {
                ret = (SJmoLdevUuidInfo)data[index];
            }
        }
        return ret;
    }

    public SJmoLdevNicknameInfo getLdevNicknameInfoSummary(List<SJmoLdevNicknameInfo> ldevNickList) {
        SJmoLdevNicknameInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoLdevIndex selectLdevIndex = new SJmoLdevIndex();
            selectLdevIndex.setLdevIndex(selectData.getLdkc(), selectData.getCu(), selectData.getLdev());
            Object[] data = ldevNickList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectLdevIndex);
            if (index >= 0) {
                ret = (SJmoLdevNicknameInfo)data[index];
            }
        }
        return ret;
    }

    public SJmoLdevGuardInfo getLdevGrdInfoSummary(List<SJmoLdevGuardInfo> ldevGrdList) {
        SJmoLdevGuardInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoLdevIndex selectLdevIndex = new SJmoLdevIndex();
            selectLdevIndex.setLdevIndex(selectData.getLdkc(), selectData.getCu(), selectData.getLdev());
            Object[] data = ldevGrdList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectLdevIndex);
            if (index >= 0) {
                ret = (SJmoLdevGuardInfo)data[index];
            }
        }
        return ret;
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetLdevDetail ldevDetail_kind = new SJmoGetLdevDetail();
        SJmoGetRange_IF ldevDetail_range = null;
        ArrayList ldevDetail_filterList = new ArrayList();
        SJmoGetDirect ldevDetail_direct = new SJmoGetDirect(ldevDetail_kind, ldevDetail_range, ldevDetail_filterList);
        this.directList.add(new SJctrGetDirectWrapper(ldevDetail_direct));
        SJmoGetPortLunInfo portLun_kind = new SJmoGetPortLunInfo();
        SJmoGetRange_IF portLun_range = null;
        ArrayList portLun_filterList = new ArrayList();
        SJmoGetDirect portLun_direct = new SJmoGetDirect(portLun_kind, portLun_range, portLun_filterList);
        this.directList.add(new SJctrGetDirectWrapper(portLun_direct));
        SJmoGetPortHostGroupInfo portHostGroup_kind = new SJmoGetPortHostGroupInfo();
        SJmoGetRange_IF portHostGroup_range = null;
        ArrayList portHostGroup_filterList = new ArrayList();
        SJmoGetDirect portHostGroup_direct = new SJmoGetDirect(portHostGroup_kind, portHostGroup_range, portHostGroup_filterList);
        this.directList.add(new SJctrGetDirectWrapper(portHostGroup_direct));
        SJmoGetPortDetail portDetail_kind = new SJmoGetPortDetail();
        SJmoGetRange_IF portDetail_range = null;
        ArrayList portDetail_filterList = new ArrayList();
        SJmoGetDirect portDetail_direct = new SJmoGetDirect(portDetail_kind, portDetail_range, portDetail_filterList);
        this.directList.add(new SJctrGetDirectWrapper(portDetail_direct));
        SJmoGetClprInfo clprInfo_kind = new SJmoGetClprInfo();
        SJmoGetRange_IF clprInfo_range = null;
        ArrayList clprInfo_filterList = new ArrayList();
        SJmoGetDirect clprInfo_direct = new SJmoGetDirect(clprInfo_kind, clprInfo_range, clprInfo_filterList);
        this.directList.add(new SJctrGetDirectWrapper(clprInfo_direct));
        SJmoGetLdevLuseInfo luseInfo_kind = new SJmoGetLdevLuseInfo();
        SJmoGetRange_IF luseInfo_range = null;
        ArrayList luseInfo_filterList = new ArrayList();
        SJmoGetDirect luseInfo_direct = new SJmoGetDirect(luseInfo_kind, luseInfo_range, luseInfo_filterList);
        this.directList.add(new SJctrGetDirectWrapper(luseInfo_direct));
        SJmoGetLdevUuidInfo uuidInfo_kind = new SJmoGetLdevUuidInfo();
        SJmoGetRange_IF uuidInfo_range = null;
        ArrayList uuidInfo_filterList = new ArrayList();
        SJmoGetDirect uuidInfo_direct = new SJmoGetDirect(uuidInfo_kind, uuidInfo_range, uuidInfo_filterList);
        this.directList.add(new SJctrGetDirectWrapper(uuidInfo_direct));
        SJmoGetLdevNicknameInfo ldevNickInfo_kind = new SJmoGetLdevNicknameInfo();
        SJmoGetRange_IF ldevNickInfo_range = null;
        ArrayList ldevNickInfo_filterList = new ArrayList();
        SJmoGetDirect ldevNickInfo_direct = new SJmoGetDirect(ldevNickInfo_kind, ldevNickInfo_range, ldevNickInfo_filterList);
        this.directList.add(new SJctrGetDirectWrapper(ldevNickInfo_direct));
        SJmoGetLdevGuardInfo grdInfo_kind = new SJmoGetLdevGuardInfo();
        SJmoGetRange_IF grdInfo_range = null;
        ArrayList grdInfo_filterList = new ArrayList();
        SJmoGetDirect grdInfo_direct = new SJmoGetDirect(grdInfo_kind, grdInfo_range, grdInfo_filterList);
        this.directList.add(new SJctrGetDirectWrapper(grdInfo_direct));
        SJmoGetHUVMVirtualLdev vLdev_kind = new SJmoGetHUVMVirtualLdev();
        SJmoGetRange_IF vLdev_range = null;
        ArrayList vLdev_filterList = new ArrayList();
        SJmoGetDirect vLdev_direct = new SJmoGetDirect(vLdev_kind, vLdev_range, vLdev_filterList);
        this.directList.add(new SJctrGetDirectWrapper(vLdev_direct));
        SJmoGetHUVMVirtualDkc vDkc_kind = new SJmoGetHUVMVirtualDkc();
        SJmoGetRange_IF vDkc_range = null;
        ArrayList vDkc_filterList = new ArrayList();
        SJmoGetDirect vDkc_direct = new SJmoGetDirect(vDkc_kind, vDkc_range, vDkc_filterList);
        this.directList.add(new SJctrGetDirectWrapper(vDkc_direct));
        SJmoGetPortIscsiTargetInfo it_kind = new SJmoGetPortIscsiTargetInfo();
        SJmoGetRange_IF it_range = null;
        ArrayList it_filterList = new ArrayList();
        SJmoGetDirect it_direct = new SJmoGetDirect(it_kind, it_range, it_filterList);
        this.directList.add(new SJctrGetDirectWrapper(it_direct));
        SJmoGetHDPRelation hdpRelation_kind = new SJmoGetHDPRelation();
        SJmoGetRange_IF hdpRelation_range = null;
        ArrayList hdpRelation_filterList = new ArrayList();
        SJmoGetDirect hdpRelation_direct = new SJmoGetDirect(hdpRelation_kind, hdpRelation_range, hdpRelation_filterList);
        this.directList.add(new SJctrGetDirectWrapper(hdpRelation_direct));
        SJmoGetThinProvisioningVolumesStatus tpVolStatus_kind = new SJmoGetThinProvisioningVolumesStatus();
        SJmoGetRange_IF tpVolStatus_range = null;
        ArrayList tpVolStatus_filterList = new ArrayList();
        SJmoGetDirect tpVolStatus_direct = new SJmoGetDirect(tpVolStatus_kind, tpVolStatus_range, tpVolStatus_filterList);
        this.directList.add(new SJctrGetDirectWrapper(tpVolStatus_direct));
    }

    protected void makeSummary(List<?> summaryList) {
        SJctrLdevDetailLUSEInfo ldevDetail = (SJctrLdevDetailLUSEInfo)summaryList.get(0);
        SJmoPortLunDetail ptLunDetail = (SJmoPortLunDetail)summaryList.get(1);
        SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)summaryList.get(2);
        SJmoPortDetail ptDetail = (SJmoPortDetail)summaryList.get(3);
        SJmoClprInfo clprInfo = (SJmoClprInfo)summaryList.get(4);
        SJmoLdevUuidInfo uuidInfo = (SJmoLdevUuidInfo)summaryList.get(5);
        SJmoLdevNicknameInfo ldevNickname = (SJmoLdevNicknameInfo)summaryList.get(6);
        SJmoLdevGuardInfo grdInfo = (SJmoLdevGuardInfo)summaryList.get(7);
        SJmoHUVMVirtualLdev vLdev = (SJmoHUVMVirtualLdev)summaryList.get(8);
        SJmoHUVMVirtualDkc vDkc = (SJmoHUVMVirtualDkc)summaryList.get(9);
        SJmoIscsiTargetInfo itInfo = (SJmoIscsiTargetInfo)summaryList.get(10);
        SJmoLdevDetail ldevDetailModel = (SJmoLdevDetail)summaryList.get(11);
        SJctrLDEVDetail ctrLDEVDetail = (SJctrLDEVDetail)summaryList.get(12);
        List dpStatusInfoList = (List)summaryList.get(13);
        SJmoThinProvisioningVolumesStatus dpStatusInfo = SJctrPoolUtility.getDPVolumesStatusInfo(ctrLDEVDetail, dpStatusInfoList);
        this.getUtility();
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_LUN, this.getLunID(ptLunDetail));
        ((SJctrDataObject)summaryData).setData(KEY_LDEV, this.getLdevID(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_LDEV_NAME, this.getLdevName(ldevNickname));
        if (!SJctrPortUtility.isIscsiPort(ptDetail)) {
            ((SJctrDataObject)summaryData).setData(KEY_UUID, this.getUuID(uuidInfo, hgInfo));
            ((SJctrDataObject)summaryData).setData(KEY_HG_NAME, this.getHostGroupName(hgInfo));
            ((SJctrDataObject)summaryData).setData(KEY_ISCSI_TARGET_NAME, SJctrPortUtility.STR_HYPHEN);
            ((SJctrDataObject)summaryData).setData(KEY_HOSTMODE, this.getHostMode(hgInfo));
            ((SJctrDataObject)summaryData).setData(KEY_HOSTMODE_OP, this.getHostModeOption(hgInfo));
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_UUID, this.getUuID(uuidInfo, itInfo));
            ((SJctrDataObject)summaryData).setData(KEY_HG_NAME, this.getIscsiTargetAlias(itInfo));
            ((SJctrDataObject)summaryData).setData(KEY_ISCSI_TARGET_NAME, this.getHostGroupName(itInfo));
            ((SJctrDataObject)summaryData).setData(KEY_HOSTMODE, this.getHostMode(itInfo));
            ((SJctrDataObject)summaryData).setData(KEY_HOSTMODE_OP, this.getHostModeOption(itInfo));
        }
        ((SJctrDataObject)summaryData).setData(KEY_PT_NAME, this.getPortName(ptDetail));
        ((SJctrDataObject)summaryData).setData(KEY_PTTYPE, this.getPortKindName(ptDetail));
        ((SJctrDataObject)summaryData).setData(KEY_CAP, this.getCapacity(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_EMU, this.getEmulationType(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_CLPR, this.getClpr(clprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_VT, this.getVolumeType(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_LDEVATTR, this.getAttribute(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_CMDDEVSEC, this.getCmdDevSec(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_CMDDEVUSER, this.getCmdDevUser(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_CMDDEVDEVGP, this.getCmdDevGrpDef(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_PATHNUM, this.getPathNum(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_ACCATTR, this.getAccAttr(ldevDetail, grdInfo));
        ((SJctrDataObject)summaryData).setData(KEY_ENCRYPTION, this.ldevUtil.toEncryptionDisplay(ldevDetailModel));
        ((SJctrDataObject)summaryData).setData(KEY_T10PI, this.ldevUtil.toT10PIDisplay(ldevDetailModel));
        ((SJctrDataObject)summaryData).setData(KEY_DATA_DIRECT_MAP_LDEV, this.toDataDirectMapLdev(ldevDetailModel));
        ((SJctrDataObject)summaryData).setData(KEY_ALUAUSED, this.comUtil.getCVSUtility().getALUAModeDisplay(ldevDetail));
        ((SJctrDataObject)summaryData).setData(KEY_ALUASTATE, this.portUtil.toAluaStateDisplay(ptLunDetail));
        ((SJctrDataObject)summaryData).setData(KEY_CAPACITY_SAVING, this.comUtil.getCVSUtility().toDataSavingDisplay(ctrLDEVDetail, false));
        ((SJctrDataObject)summaryData).setData(KEY_CAPACITY_SAVING_STATUS, this.poolUtil.getSavingStatus(ldevDetailModel, dpStatusInfoList, true));
        ((SJctrDataObject)summaryData).setData(KEY_DEDUPLICATION_DATA, this.getDeduplicationData(ctrLDEVDetail, dpStatusInfo));
        ((SJctrDataObject)summaryData).setData(KEY_VSS_MDL_SN, this.rsgUtil.toDispStringVssModelSerialNo(vDkc));
        ((SJctrDataObject)summaryData).setData(KEY_VSS_LDEVID, this.rsgUtil.toDispStringVssLdevID(vLdev, this.ldevUtil));
        ((SJctrDataObject)summaryData).setData(KEY_VSS_DEVNAME, this.rsgUtil.toDispStringVssDeviceName(vLdev, this.ldevUtil));
        ((SJctrDataObject)summaryData).setData(KEY_VSS_SSID, this.rsgUtil.toDispStringVssSsid(vLdev));
        ((SJctrDataObject)summaryData).setData(KEY_VSS_LDEVATTR, this.rsgUtil.toDispStringVssAttribute(vLdev));
    }

    private void getUtility() {
        SJctrUserController uc = this.getDataController().getOwner();
        this.comUtil = uc.getComUtility();
        this.ldevUtil = this.comUtil.getLdevUtility();
        this.portUtil = this.comUtil.getPortUtility();
        this.capUtil = this.comUtil.getCapacityUtility();
        this.rsgUtil = this.comUtil.getRsgUtility();
        this.poolUtil = this.comUtil.getPoolUtility();
    }

    private String getLunID(SJmoPortLunDetail ptLunDetail) {
        String id = "?";
        if (ptLunDetail != null) {
            id = this.isLunIdNotationDec() ? SJctrComUtility.toDecString(ptLunDetail.getSLUN()) : SJctrComUtility.toHexString(ptLunDetail.getSLUN(), 4, true);
        }
        return id;
    }

    private String getLdevID(SJmoLdevDetail ldevDetail) {
        String id = "?";
        if (ldevDetail != null) {
            id = this.ldevUtil.toLdevDisplay(ldevDetail);
        }
        return id;
    }

    private String getLdevName(SJmoLdevNicknameInfo ldevNickname) {
        String name = "?";
        if (ldevNickname != null) {
            name = ldevNickname.getStrNickname();
        }
        return name;
    }

    private String getUuID(SJmoLdevUuidInfo uuidInfo, SJmoHostGroupInfo hgInfo) {
        String id = "?";
        if (uuidInfo != null) {
            SJctrLdevUtility util = this.getComUtility().getLdevUtility();
            id = !util.isOpenVMSBit(uuidInfo, hgInfo) && !uuidInfo.getStrUuid().equals("") ? "-" : uuidInfo.getStrUuid();
        }
        return id;
    }

    private String getHostGroupName(SJmoHostGroupInfo hgInfo) {
        String name = "?";
        if (hgInfo != null) {
            name = hgInfo.getStrHostgroupNickName();
        }
        return name;
    }

    private String getHostGroupName(SJmoIscsiTargetInfo itInfo) {
        String name = "?";
        if (itInfo != null) {
            name = itInfo.getStrIscsiTargetName();
        }
        return name;
    }

    private String getHostMode(SJmoHostGroupInfo hgInfo) {
        String mode = "?";
        if (hgInfo != null) {
            mode = this.portUtil.toHostModeDisplay(hgInfo);
        }
        return mode;
    }

    private String getHostModeOption(SJmoHostGroupInfo hgInfo) {
        StringBuffer optionNumber = new StringBuffer();
        if (hgInfo != null) {
            BitSet optbt = hgInfo.getBtOption();
            for (int optIndex = 0; optIndex <= optbt.size(); ++optIndex) {
                if (!optbt.get(optIndex)) continue;
                if (optionNumber.length() != 0) {
                    optionNumber.append(",");
                }
                optionNumber.append(optIndex);
            }
        }
        return optionNumber.toString();
    }

    private String getPortName(SJmoPortDetail ptDetail) {
        String name = "?";
        if (ptDetail != null) {
            name = ptDetail.getStrPortDisplayName();
        }
        return name;
    }

    private String getArrayGroupNo(SJmoLdevDetail ldevDetail) {
        String id = "?";
        if (ldevDetail != null) {
            id = this.ldevUtil.toArrayGroupDisplay(ldevDetail);
        }
        return id;
    }

    private String getRaidLevel(SJmoLdevDetail ldevDetail) {
        String lev = "?";
        if (ldevDetail != null) {
            lev = this.ldevUtil.toRaidLevelDisplay(ldevDetail);
        }
        return lev;
    }

    private String getDriveType(SJmoLdevDetail ldevDetail) {
        String type = "?";
        if (ldevDetail != null) {
            type = this.ldevUtil.toDriveTypeDisplay(ldevDetail);
        }
        return type;
    }

    private String getCapacity(SJctrLdevDetailLUSEInfo ldevDetail) {
        String capa = "?";
        if (ldevDetail != null) {
            capa = this.capUtil.toUnitString(ldevDetail.getLTotalLBASize());
        }
        return capa;
    }

    private String getEmulationType(SJmoLdevDetail ldevDetail) {
        String type = "?";
        if (ldevDetail != null) {
            type = this.ldevUtil.toEmuDisplay(ldevDetail);
        }
        return type;
    }

    private String getClpr(SJmoClprInfo clprInfo) {
        String clpr = "?";
        if (clprInfo != null) {
            clpr = this.ldevUtil.toClprDisplay(clprInfo);
        }
        return clpr;
    }

    private String getVolumeType(SJmoLdevDetail ldevDetail) {
        String type = "?";
        if (ldevDetail != null) {
            type = this.ldevUtil.toVolumeTypeDisplay(ldevDetail);
        }
        return type;
    }

    private String getAttribute(SJmoLdevDetail ldevDetail) {
        String attribute = "?";
        if (ldevDetail != null) {
            attribute = this.ldevUtil.toLdevAttributeDisplay(ldevDetail);
        }
        return attribute;
    }

    private String getCmdDevSec(SJmoLdevDetail ldevDetail) {
        String status = "?";
        if (ldevDetail != null) {
            status = ldevDetail.getbLUPathCmdDev() && !ldevDetail.getbRmtComDev() ? this.ldevUtil.toCommandDeviceSecurityDisplay(ldevDetail) : "-";
        }
        return status;
    }

    private String getCmdDevUser(SJmoLdevDetail ldevDetail) {
        String status = "?";
        if (ldevDetail != null) {
            status = ldevDetail.getbLUPathCmdDev() && !ldevDetail.getbRmtComDev() ? this.ldevUtil.toCommandDeviceAuthenticationDisplay(ldevDetail) : "-";
        }
        return status;
    }

    private String getCmdDevGrpDef(SJmoLdevDetail ldevDetail) {
        String status = "?";
        if (ldevDetail != null) {
            status = ldevDetail.getbLUPathCmdDev() && !ldevDetail.getbRmtComDev() ? this.ldevUtil.toDeviceGrpDifinitionDisplay(ldevDetail) : "-";
        }
        return status;
    }

    private String getPathNum(SJmoLdevDetail ldevDetail) {
        String status = "?";
        if (ldevDetail != null) {
            status = this.ldevUtil.toPathDisplay(ldevDetail);
        }
        return status;
    }

    private String toDataDirectMapLdev(SJmoLdevDetail ldevDetail) {
        if (ldevDetail == null) {
            return "?";
        }
        String str = "";
        SJmoLdevIndex dmLdev = null;
        if (ldevDetail.getBDM()) {
            dmLdev = ldevDetail.getCnctLDEVIndex();
        }
        if (dmLdev != null) {
            str = this.ldevUtil.toLdevDisplay(dmLdev);
        }
        return str;
    }

    private String getAccAttr(SJmoLdevDetail ldevDetail, SJmoLdevGuardInfo grdInfo) {
        String status = "?";
        if (ldevDetail != null && grdInfo != null) {
            status = this.ldevUtil.getGuardAttrStr(grdInfo.getByLdevGuardStatus(), ldevDetail.getbVma(), ldevDetail.getbExtent());
        }
        return status;
    }

    private boolean isLunIdNotationDec() {
        boolean bRet = false;
        SJbaseUserSessionInterface userSession = this.getDataController().getOwner().getUserSession();
        bRet = SJctrPortUtility.isLunIdDecimal(userSession);
        return bRet;
    }

    private String getUuID(SJmoLdevUuidInfo uuidInfo, SJmoIscsiTargetInfo itInfo) {
        SJmoHostGroupInfo hgInfo = null;
        if (uuidInfo != null && itInfo != null) {
            hgInfo = new SJmoHostGroupInfo();
            byte hostMode = (byte)itInfo.getIHostMode();
            hgInfo.setByHostMode(hostMode);
        }
        return this.getUuID(uuidInfo, hgInfo);
    }

    private String getIscsiTargetAlias(SJmoIscsiTargetInfo itInfo) {
        String name = "?";
        if (itInfo != null) {
            name = itInfo.getStrIscsiTargetAlias();
        }
        return name;
    }

    private String getIscsiTargetName(SJmoHostGroupInfo itInfo) {
        return SJctrPortUtility.STR_HYPHEN;
    }

    private String getHostMode(SJmoIscsiTargetInfo itInfo) {
        SJmoIscsiTargetInfo iscsiTargetInfo = null;
        if (itInfo != null) {
            iscsiTargetInfo = new SJmoIscsiTargetInfo();
            iscsiTargetInfo.setIHostMode(itInfo.getIHostMode());
        }
        return this.portUtil.toHostModeDisplay(iscsiTargetInfo);
    }

    private String getHostModeOption(SJmoIscsiTargetInfo itInfo) {
        SJmoHostGroupInfo iscsiTargetInfo = null;
        if (itInfo != null) {
            iscsiTargetInfo = new SJmoHostGroupInfo();
            iscsiTargetInfo.setBtOption(itInfo.getBtOption());
        }
        return this.getHostModeOption(iscsiTargetInfo);
    }

    private String getPortKindName(SJmoPortDetail ptDetail) {
        String name = "?";
        if (ptDetail != null) {
            name = ptDetail.getStrPortKindName();
        }
        return name;
    }

    public SJmoIscsiTargetInfo getIscsiTargetInfoSummary(List<SJmoPortIscsiTargetInfo> ptItInfoList) {
        SJmoIscsiTargetInfo ret = null;
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoPortIndex selectPortIndex = new SJmoPortIndex();
            selectPortIndex.setSPort(selectData.getPort());
            short selectIscsiTarget = selectData.getHostGroup();
            Object[] data = ptItInfoList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectPortIndex);
            if (index >= 0) {
                SJmoPortIscsiTargetInfo ptItInfo = (SJmoPortIscsiTargetInfo)data[index];
                ArrayList<SJmoIscsiTargetInfo> itInfolList = ptItInfo.getAlPortIscsiTarget();
                for (SJmoIscsiTargetInfo itInfo : itInfolList) {
                    if (itInfo.getSIscsiTarget() != selectIscsiTarget) continue;
                    ret = itInfo;
                    break;
                }
            }
        }
        return ret;
    }

    public SJctrLDEVDetail getLDEVDetailInfoSummary(SJmoLdevDetail ldevDetailSummary, List<SJmoHDPRelation> hdpRelationList) {
        SJctrLDEVDetail ldevDetail = new SJctrLDEVDetail();
        SJmoHDPRelation ret = null;
        ldevDetail.setDetailData(ldevDetailSummary);
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrLunInfoPropertyDC) {
            SJctrLunInfoPropertyDC propertyDc = (SJctrLunInfoPropertyDC)dc;
            SJctrLuPathLdevIndex selectData = propertyDc.getSelectData();
            SJmoLdevIndex selectLdevIndex = new SJmoLdevIndex();
            selectLdevIndex.setLdevIndex(selectData.getLdkc(), selectData.getCu(), selectData.getLdev());
            Object[] data = hdpRelationList.toArray();
            Arrays.sort(data);
            int index = Arrays.binarySearch(data, selectLdevIndex);
            if (index >= 0) {
                ret = (SJmoHDPRelation)data[index];
                ldevDetail.setRelationData(ret);
            }
        }
        return ldevDetail;
    }

    private String getDeduplicationData(SJctrLDEVDetail ldevDetail, SJmoThinProvisioningVolumesStatus dpVolStatus) {
        if (ldevDetail == null) {
            return "?";
        }
        if (dpVolStatus != null) {
            ldevDetail.setDPVolStatus(dpVolStatus);
        }
        SJctrComCVSUtility cvsUty = this.getComUtility().getCVSUtility();
        return cvsUty.toDeduplicationDataDisplay(ldevDetail);
    }
}

