/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.exstorage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.uvm.editpolicy.SJctrExdPolicyData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdPhysicalPathInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdSubsystemInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdSubsystemInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPathGroupInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPhysicalPathInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdSubsystemInfoMgr;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdVolumeInfoMgr;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrExsSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_EXT_STORAGE_NUM = "COM_EXT_STORAGE_NUM";
    public static final String KEY_EXT_PATH_NUM = "COM_EXT_PATH_NUM";
    public static final String KEY_EXT_ISCSI_PATH_NUM = "COM_EXT_ISCSI_PATH_NUM";
    public static final String KEY_EXT_VOL_NUM = "COM_EXT_VOL_NUM";
    public static final String KEY_EXT_VOL_CAP = "COM_EXT_VOL_CAP";
    private SJmoExdSubsystemInfoMgr subsystemMgr = null;
    private SJmoExdPhysicalPathInfoMgr physicalPathMgr = null;
    private SJmoExdPathGroupInfoMgr pathGroupMgr = null;
    private SJmoExdVolumeInfoMgr exdVolMgr = null;
    private List<SJmoPortIscsiTargetPathInfo> portITPathList = Collections.emptyList();
    private SJctrResourceGroupUtility rsgUtil = null;
    private SJctrExdPolicyData policyData = null;

    @Override
    public void makeDataObject() {
        List<SJmoGetKind_IF> list = this.getBasicDataList(SJmoGetRSGgetAllRsgs.class);
        if (list != null && list.size() != 0) {
            SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)((Object)list.get(0));
            this.rsgUtil = new SJctrResourceGroupUtility(this.getDataController().getOwner(), rsgInfo);
        }
        if ((list = this.getBasicDataList(SJmoGetExdSubsystemInfoMgr.class)) != null && list.size() != 0) {
            this.subsystemMgr = (SJmoExdSubsystemInfoMgr)((Object)list.get(0));
        }
        if ((list = this.getBasicDataList(SJmoGetExdPhysicalPathInfoMgr.class)) != null && list.size() != 0) {
            this.physicalPathMgr = (SJmoExdPhysicalPathInfoMgr)((Object)list.get(0));
        }
        if ((list = this.getBasicDataList(SJmoGetExdPathGroupInfoMgr.class)) != null && list.size() != 0) {
            this.pathGroupMgr = (SJmoExdPathGroupInfoMgr)((Object)list.get(0));
        }
        if ((list = this.getBasicDataList(SJmoGetExdVolumeInfoMgr.class)) != null && list.size() != 0) {
            this.exdVolMgr = (SJmoExdVolumeInfoMgr)((Object)list.get(0));
        }
        if ((list = this.getBasicDataList(SJmoGetPortIscsiTargetPathInfo.class)) != null) {
            this.portITPathList = list;
        }
        this.makeSummary();
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetKind_IF kind = new SJmoGetExdSubsystemInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPhysicalPathInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdPathGroupInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetExdVolumeInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetPathInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    protected void makeSummary() {
        this.policyData = new SJctrExdPolicyData(this.getDataController().getOwner());
        SJctrDataController dc = this.getDataController();
        SJctrComUtility comUtil = dc.getOwner().getComUtility();
        SJctrExtUtility extUtil = comUtil.getExtUtility();
        ArrayList subsystemList = this.subsystemMgr.getAlExdSubsystemInfo();
        List<SJmoExdSubsystemInfo> usableSubsystemList = extUtil.getUsableSubsystemInfo(this.rsgUtil, subsystemList, this.pathGroupMgr, this.physicalPathMgr, this.exdVolMgr);
        ArrayList exdPathGrpList = this.pathGroupMgr.getAlExdPathGroupInfo();
        List<SJmoExdPathGroupInfo> usablePathGrpList = extUtil.getUsableExdPathGrpInfo(this.rsgUtil, exdPathGrpList, this.physicalPathMgr, this.exdVolMgr);
        List<SJmoExdPhysicalPathInfo> usablePhysicalPathList = extUtil.getAllPhysicalPathInfo(usablePathGrpList, this.physicalPathMgr);
        List<SJmoExdVolumeInfo> usableVolList = extUtil.getUsableExdVolInfoonPathGrp(this.rsgUtil, exdPathGrpList, this.exdVolMgr);
        int numOfExtStr = this.getExtSubSystemNum(usableSubsystemList);
        int numOfExtPath = this.getExtPhysicalPathNum(usablePhysicalPathList);
        int numOfiSCSIPath = this.getiSCSITargetPathNum(this.portITPathList, this.rsgUtil);
        int numOfExtVol = this.getExtVolumeNum(usableVolList);
        String extVolCap = this.getExtVolumeCapacity(usableVolList);
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_EXT_STORAGE_NUM, SJctrComUtility.toDecString(numOfExtStr));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_PATH_NUM, SJctrComUtility.toDecString(numOfExtPath));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_ISCSI_PATH_NUM, SJctrComUtility.toDecString(numOfiSCSIPath));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_VOL_NUM, SJctrComUtility.toDecString(numOfExtVol));
        ((SJctrDataObject)summaryData).setData(KEY_EXT_VOL_CAP, extVolCap);
    }

    private int getExtSubSystemNum(List<SJmoExdSubsystemInfo> subsystemList) {
        int num = 0;
        for (SJmoExdSubsystemInfo subsystemInfo : subsystemList) {
            int subSystemId = subsystemInfo.getRmiExdSubsystemInfo().getId();
            ArrayList pathGrpList = this.pathGroupMgr.getAlPathGroupInfoOfSubsystemId(subSystemId);
            if (pathGrpList == null || pathGrpList.isEmpty()) continue;
            ++num;
        }
        return num;
    }

    private int getExtPhysicalPathNum(List<SJmoExdPhysicalPathInfo> physicalPathList) {
        int num = 0;
        num = physicalPathList.size();
        return num;
    }

    private int getiSCSITargetPathNum(List<SJmoPortIscsiTargetPathInfo> portITPathList, SJctrResourceGroupUtility rsgUtil) {
        int num = 0;
        List<SJmoPortIndex> unUsablePortList = rsgUtil.extractImpossiblePort(portITPathList);
        Collections.sort(unUsablePortList);
        for (SJmoPortIscsiTargetPathInfo portITPathInfo : portITPathList) {
            if (Collections.binarySearch(unUsablePortList, portITPathInfo) >= 0) continue;
            ArrayList<SJmoIscsiTargetPathInfo> iTPathList = portITPathInfo.getAlPortIscsiTargetPath();
            for (SJmoIscsiTargetPathInfo iscsiPath : iTPathList) {
                if (iscsiPath.getIFunction() != 0) continue;
                ++num;
            }
        }
        return num;
    }

    private int getExtVolumeNum(List<SJmoExdVolumeInfo> exdVolList) {
        int num = 0;
        num = exdVolList.size();
        return num;
    }

    private String getExtVolumeCapacity(List<SJmoExdVolumeInfo> exdVolList) {
        long cap = 0L;
        for (SJmoExdVolumeInfo exdVol : exdVolList) {
            cap += exdVol.getRmiExdVolumeInfo().getExternalDeviceInfo().getVolumeSize();
        }
        SJctrCapacityUtility capUtil = this.getComUtility().getCapacityUtility();
        return capUtil.toUnitString(cap);
    }

    public SJmoExdSubsystemInfoMgr getExdSubsystemInfoMgr() {
        return this.subsystemMgr;
    }

    public SJmoExdPhysicalPathInfoMgr getExdPhysicalPathInfoMgr() {
        return this.physicalPathMgr;
    }

    public SJmoExdPathGroupInfoMgr getExdPathGroupInfoMgr() {
        return this.pathGroupMgr;
    }

    public SJmoExdVolumeInfoMgr getExdVolumeInfoMgr() {
        return this.exdVolMgr;
    }
}

